/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.AttributeDescriptor;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

public class RuntimeIterator
extends AbstractCompiledValue {
    private static final SelectResults UNINITIALIZED = new ResultsBag(0, null);
    private Object current = UNINITIALIZED;
    private String name;
    private SelectResults collection = UNINITIALIZED;
    private CompiledIteratorDef cmpIteratorDefn;
    private ObjectType elementType;
    private String internalId = null;
    private String definition = null;
    private String index_internal_id = null;
    private int scopeID = -1;

    @Override
    public int getType() {
        return 48;
    }

    public ObjectType getElementType() {
        return this.elementType;
    }

    RuntimeIterator(CompiledIteratorDef cmpIteratorDefn, ObjectType elementType) {
        if (elementType == null || cmpIteratorDefn == null) {
            throw new IllegalArgumentException(LocalizedStrings.RuntimeIterator_ELEMENTTYPE_ANDOR_CMPITERATORDEFN_SHOULD_NOT_BE_NULL.toLocalizedString());
        }
        this.name = cmpIteratorDefn.getName();
        this.elementType = elementType;
        this.cmpIteratorDefn = cmpIteratorDefn;
    }

    CompiledIteratorDef getCmpIteratorDefn() {
        return this.cmpIteratorDefn;
    }

    public String getName() {
        return this.name;
    }

    public SelectResults evaluateCollection(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.collection != UNINITIALIZED && !this.cmpIteratorDefn.isDependentOnAnyIteratorOfScopeLessThanItsOwn(context) && this.scopeID != IndexCreationHelper.INDEX_QUERY_SCOPE_ID) {
            return this.collection;
        }
        this.collection = this.cmpIteratorDefn.evaluateCollection(context, this);
        if (this.collection == null) {
            return null;
        }
        if (!this.elementType.equals(TypeUtils.OBJECT_TYPE)) {
            this.collection.setElementType(this.elementType);
        } else {
            this.elementType = this.collection.getCollectionType().getElementType();
        }
        return this.collection;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) {
        return Collections.singleton(this);
    }

    @Override
    public boolean isDependentOnIterator(RuntimeIterator itr, ExecutionContext context) {
        if (itr == this) {
            return true;
        }
        return this.cmpIteratorDefn.isDependentOnIterator(itr, context);
    }

    @Override
    public boolean isDependentOnCurrentScope(ExecutionContext context) {
        return this.cmpIteratorDefn.isDependentOnCurrentScope(context);
    }

    public void setCurrent(Object current) {
        this.current = current;
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        Support.Assert(this.current != UNINITIALIZED, "error to evaluate RuntimeIterator without setting current first");
        return this.current;
    }

    boolean containsProperty(String name, int numArgs, boolean mustBeMethod) throws AmbiguousNameException {
        if (this.elementType instanceof StructType && !mustBeMethod) {
            String[] fieldName = ((StructType)this.elementType).getFieldNames();
            for (int i = 0; i < fieldName.length; ++i) {
                if (!name.equals(fieldName[i])) continue;
                return true;
            }
        }
        Class clazz = this.elementType.resolveClass();
        if (numArgs > 0 || mustBeMethod) {
            if (numArgs == 0) {
                try {
                    clazz.getMethod(name, null);
                    return true;
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(name) || m.getParameterTypes().length != numArgs) continue;
                return true;
            }
            return false;
        }
        return new AttributeDescriptor(name).validateReadType(clazz);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" (name=" + this.name);
        sb.append(" collection expr=" + this.cmpIteratorDefn);
        return sb.toString();
    }

    public void setInternalId(String id) {
        Support.Assert(id != null, "Internal ID can not be null");
        this.internalId = id;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setDefinition(String def) {
        Support.Assert(this.definition == null, "Definition is already set");
        Support.Assert(def != null, "Definition can not be null");
        this.definition = def;
    }

    public void setIndexInternalID(String index_id) {
        this.index_internal_id = index_id;
    }

    public String getIndexInternalID() {
        return this.index_internal_id;
    }

    public String getDefinition() {
        Support.Assert(this.definition != null, "Definition is not yet set");
        return this.definition;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException {
        int currScopeID = context.currentScope().getScopeID();
        if (currScopeID == this.scopeID) {
            clauseBuffer.insert(0, this.index_internal_id == null ? this.internalId : this.index_internal_id);
        } else {
            clauseBuffer.insert(0, this.internalId).insert(0, '_').insert(0, this.scopeID).insert(0, "scope");
        }
    }

    void setScopeID(int scopeID) {
        this.scopeID = scopeID;
    }

    int getScopeID() {
        return this.scopeID;
    }
}

