/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.Ordered;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LinkedResultSet
extends LinkedHashSet
implements Ordered,
SelectResults,
DataSerializableFixedID {
    private static final long serialVersionUID = 5184711453750319225L;
    private ObjectType elementType;

    public LinkedResultSet() {
    }

    LinkedResultSet(Collection c) {
        super(c);
    }

    LinkedResultSet(SelectResults sr) {
        super(sr);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    LinkedResultSet(ObjectType elementType) {
        this.setElementType(elementType);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LinkedResultSet)) {
            return false;
        }
        if (!this.elementType.equals(((LinkedResultSet)other).elementType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException(LocalizedStrings.SortedResultSet_THIS_COLLECTION_DOES_NOT_SUPPORT_STRUCT_ELEMENTS.toLocalizedString());
        }
        this.elementType = elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Ordered.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.elementType = (ObjectType)DataSerializer.readObject(in);
        for (int j = size; j > 0; --j) {
            this.add(DataSerializer.readObject(in));
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.size());
        DataSerializer.writeObject(this.elementType, out);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DataSerializer.writeObject(i.next(), out);
        }
    }

    @Override
    public int getDSFID() {
        return 2122;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public Comparator comparator() {
        return null;
    }

    @Override
    public boolean dataPreordered() {
        return true;
    }
}

