/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class CqQueryVsdStats {
    private static final StatisticsType _type;
    protected static final String CQ_INITIAL_RESULTS_TIME = "cqInitialResultsTime";
    protected static final String CQ_INSERTS = "numInserts";
    protected static final String CQ_UPDATES = "numUpdates";
    protected static final String CQ_DELETES = "numDeletes";
    protected static final String CQ_EVENTS = "numEvents";
    protected static final String NUM_HA_QUEUED_CQ_EVENTS = "numQueuedEvents";
    protected static final String CQ_LISTENER_INVOCATIONS = "numCqListenerInvocations";
    protected static final String QUEUED_CQ_LISTENER_EVENTS = "queuedCqListenerEvents";
    private static final int _cqInitialResultsTimeId;
    private static final int _numInsertsId;
    private static final int _numUpdatesId;
    private static final int _numDeletesId;
    private static final int _numEventsId;
    private static final int _numHAQueuedEventsId;
    private static final int _numCqListenerInvocationsId;
    private static final int _queuedCqListenerEventsId;
    private final Statistics _stats;

    public CqQueryVsdStats(StatisticsFactory factory, String name) {
        this._stats = factory.createAtomicStatistics(_type, "CqQueryStats-" + name);
    }

    public void close() {
        this._stats.close();
    }

    public long getCqInitialResultsTime() {
        return this._stats.getLong(_cqInitialResultsTimeId);
    }

    public void setCqInitialResultsTime(long time) {
        this._stats.setLong(_cqInitialResultsTimeId, time);
    }

    public long getNumInserts() {
        return this._stats.getLong(_numInsertsId);
    }

    public void incNumInserts() {
        this._stats.incLong(_numInsertsId, 1L);
    }

    public long getNumUpdates() {
        return this._stats.getLong(_numUpdatesId);
    }

    public void incNumUpdates() {
        this._stats.incLong(_numUpdatesId, 1L);
    }

    public long getNumDeletes() {
        return this._stats.getLong(_numDeletesId);
    }

    public void incNumDeletes() {
        this._stats.incLong(_numDeletesId, 1L);
    }

    public long getNumEvents() {
        return this._stats.getLong(_numEventsId);
    }

    public void incNumEvents() {
        this._stats.incLong(_numEventsId, 1L);
    }

    public long getNumHAQueuedEvents() {
        return this._stats.getLong(_numHAQueuedEventsId);
    }

    public void incNumHAQueuedEvents(long incAmount) {
        this._stats.incLong(_numHAQueuedEventsId, incAmount);
    }

    public long getNumCqListenerInvocations() {
        return this._stats.getLong(_numCqListenerInvocationsId);
    }

    public long getQueuedCqListenerEvents() {
        return this._stats.getLong(_queuedCqListenerEventsId);
    }

    public void incNumCqListenerInvocations() {
        this._stats.incLong(_numCqListenerInvocationsId, 1L);
    }

    public void incQueuedCqListenerEvents() {
        this._stats.incLong(_queuedCqListenerEventsId, 1L);
    }

    public void decQueuedCqListenerEvents() {
        this._stats.incLong(_queuedCqListenerEventsId, -1L);
    }

    public void updateStats(CqEvent cqEvent) {
        if (cqEvent.getQueryOperation() == null) {
            return;
        }
        this.incNumEvents();
        if (cqEvent.getQueryOperation().isCreate()) {
            this.incNumInserts();
        }
        if (cqEvent.getQueryOperation().isUpdate()) {
            this.incNumUpdates();
        }
        if (cqEvent.getQueryOperation().isDestroy()) {
            this.incNumDeletes();
        }
    }

    public void updateStats(Integer cqEvent) {
        if (cqEvent == null) {
            return;
        }
        this.incNumEvents();
        switch (cqEvent) {
            case 27: {
                this.incNumInserts();
                return;
            }
            case 28: {
                this.incNumUpdates();
                return;
            }
            case 16: {
                this.incNumDeletes();
                return;
            }
        }
    }

    static {
        String statName = "CqQueryStats";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(statName, statName, new StatisticDescriptor[]{f.createLongCounter(CQ_INITIAL_RESULTS_TIME, "The total amount of time, in nanoseconds, it took to do this initial query and send the results to the client.", "nanoseconds"), f.createLongCounter(CQ_INSERTS, "Total number of inserts done on this cq.", "operations"), f.createLongCounter(CQ_UPDATES, "Total number of updates done on this cq.", "operations"), f.createLongCounter(CQ_DELETES, "Total number of deletes done on this cq.", "operations"), f.createLongCounter(CQ_EVENTS, "Total number of inserts, updates, and deletes done on this cq.", "operations"), f.createLongGauge(NUM_HA_QUEUED_CQ_EVENTS, "Number of events in this cq.", "events"), f.createLongCounter(CQ_LISTENER_INVOCATIONS, "Total number of CqListener invocations.", "operations"), f.createLongGauge(QUEUED_CQ_LISTENER_EVENTS, "Number of events queued while CQ registration is in progress. This is not the main cq queue but a temporary internal one used while the cq is starting up.", "events")});
        _cqInitialResultsTimeId = _type.nameToId(CQ_INITIAL_RESULTS_TIME);
        _numInsertsId = _type.nameToId(CQ_INSERTS);
        _numUpdatesId = _type.nameToId(CQ_UPDATES);
        _numDeletesId = _type.nameToId(CQ_DELETES);
        _numEventsId = _type.nameToId(CQ_EVENTS);
        _numHAQueuedEventsId = _type.nameToId(NUM_HA_QUEUED_CQ_EVENTS);
        _numCqListenerInvocationsId = _type.nameToId(CQ_LISTENER_INVOCATIONS);
        _queuedCqListenerEventsId = _type.nameToId(QUEUED_CQ_LISTENER_EVENTS);
    }
}

