/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.ResultsSet;
import com.gemstone.gemfire.internal.Assert;
import java.util.List;
import java.util.Set;

public class CompiledConstruction
extends AbstractCompiledValue {
    private Class objectType;
    private List args;

    public CompiledConstruction(Class objectType, List args) {
        this.objectType = objectType;
        this.args = args;
    }

    @Override
    public List getChildren() {
        return this.args;
    }

    @Override
    public int getType() {
        return -6;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Assert.assertTrue(this.objectType == ResultsSet.class);
        ResultsSet newSet = new ResultsSet(this.args.size());
        for (CompiledValue cv : this.args) {
            Object eval = cv.evaluate(context);
            if (eval == QueryService.UNDEFINED) {
                return QueryService.UNDEFINED;
            }
            newSet.add(eval);
        }
        return newSet;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        for (CompiledValue cv : this.args) {
            context.addDependencies(this, cv.computeDependencies(context));
        }
        return context.getDependencySet(this, true);
    }
}

