/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.operations.internal;

import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.internal.offheap.Releasable;
import com.gemstone.gemfire.internal.offheap.StoredObject;

public class GetOperationContextImpl
extends GetOperationContext
implements Releasable {
    private boolean released;

    public GetOperationContextImpl(Object key, boolean postOperation) {
        super(key, postOperation);
    }

    public Object getRawValue() {
        return super.getValue();
    }

    @Override
    public Object getObject() {
        Object result = super.getObject();
        if (result instanceof StoredObject) {
            result = null;
        }
        return result;
    }

    @Override
    public void setObject(Object value, boolean isObject) {
        this.released = false;
        super.setObject(value, isObject);
    }

    @Override
    public void setValue(Object value, boolean isObject) {
        this.released = false;
        super.setValue(value, isObject);
    }

    private void checkForReleasedOffHeapValue(StoredObject so) {
        if (this.released && so.hasRefCount()) {
            throw new IllegalStateException("Attempt to access off-heap value after the OperationContext callback returned.");
        }
    }

    @Override
    public byte[] getSerializedValue() {
        Object v;
        byte[] result = super.getSerializedValue();
        if (result == null && (v = super.getValue()) instanceof StoredObject) {
            StoredObject so = (StoredObject)v;
            this.checkForReleasedOffHeapValue(so);
            result = so.getValueAsHeapByteArray();
        }
        return result;
    }

    @Override
    public Object getDeserializedValue() throws SerializationException {
        Object result = super.getDeserializedValue();
        if (result instanceof StoredObject) {
            StoredObject so = (StoredObject)result;
            this.checkForReleasedOffHeapValue(so);
            result = so.getValueAsDeserializedHeapObject();
        }
        return result;
    }

    @Override
    public Object getValue() {
        Object result = super.getValue();
        if (result instanceof StoredObject) {
            StoredObject so = (StoredObject)result;
            this.checkForReleasedOffHeapValue(so);
            result = so.getValueAsHeapByteArray();
        }
        return result;
    }

    @Override
    public void release() {
        if (super.getValue() instanceof StoredObject) {
            this.released = true;
        }
    }
}

