/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplogOrganizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class HoplogUtil {
    public static Collection<FileStatus> getAllRegionHoplogs(Path regionPath, FileSystem fs, String type) throws IOException {
        return HoplogUtil.getRegionHoplogs(regionPath, fs, type, 0L, 0L);
    }

    public static Collection<FileStatus> getRegionHoplogs(Path regionPath, FileSystem fs, String type, long start, long end) throws IOException {
        Collection<Collection<FileStatus>> allBuckets = HoplogUtil.getBucketHoplogs(regionPath, fs, type, start, end);
        ArrayList<FileStatus> hoplogs = new ArrayList<FileStatus>();
        for (Collection<FileStatus> bucket : allBuckets) {
            for (FileStatus file : bucket) {
                hoplogs.add(file);
            }
        }
        return hoplogs;
    }

    public static Collection<Collection<FileStatus>> getBucketHoplogs(Path regionPath, FileSystem fs, String type, long start, long end) throws IOException {
        FileStatus[] bucketDirs;
        ArrayList<Collection<FileStatus>> allBuckets = new ArrayList<Collection<FileStatus>>();
        String HOPLOG_NAME_REGEX = "(.+?)-(\\d+?)-(\\d+?)" + type;
        String EXPIRED_HOPLOG_NAME_REGEX = HOPLOG_NAME_REGEX + ".exp";
        Pattern pattern = Pattern.compile(HOPLOG_NAME_REGEX);
        Pattern expiredPattern = Pattern.compile(EXPIRED_HOPLOG_NAME_REGEX);
        Path cleanUpIntervalPath = new Path(regionPath.getParent(), "cleanUpInterval");
        long intervalDurationMillis = HoplogUtil.readCleanUpIntervalMillis(fs, cleanUpIntervalPath);
        for (FileStatus bucket : bucketDirs = fs.listStatus(regionPath)) {
            long expiredTimeStamp;
            if (!bucket.isDirectory()) continue;
            try {
                Integer.valueOf(bucket.getPath().getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            ArrayList<FileStatus> bucketHoplogs = new ArrayList<FileStatus>();
            FileStatus[] bucketFiles = fs.listStatus(bucket.getPath());
            Map<String, Long> expiredHoplogs = HoplogUtil.getExpiredHoplogs(fs, bucketFiles, expiredPattern);
            FileStatus oldestHopAfterEndTS = null;
            long oldestHopTS = Long.MAX_VALUE;
            long currentTimeStamp = System.currentTimeMillis();
            for (FileStatus file : bucketFiles) {
                Matcher match;
                if (!file.isFile() || !(match = pattern.matcher(file.getPath().getName())).matches()) continue;
                long timeStamp = AbstractHoplogOrganizer.getHoplogTimestamp(match);
                if (start > 0L && timeStamp < start) continue;
                if (end > 0L && timeStamp > end) {
                    if (oldestHopTS <= timeStamp) continue;
                    oldestHopTS = timeStamp;
                    oldestHopAfterEndTS = file;
                    continue;
                }
                long expiredTimeStamp2 = HoplogUtil.expiredTime(file, expiredHoplogs);
                if (expiredTimeStamp2 > 0L && intervalDurationMillis > 0L && (double)(currentTimeStamp - expiredTimeStamp2) > 0.8 * (double)intervalDurationMillis) continue;
                bucketHoplogs.add(file);
            }
            if (oldestHopAfterEndTS != null && ((expiredTimeStamp = HoplogUtil.expiredTime(oldestHopAfterEndTS, expiredHoplogs)) <= 0L || intervalDurationMillis <= 0L || (double)(currentTimeStamp - expiredTimeStamp) <= 0.8 * (double)intervalDurationMillis)) {
                bucketHoplogs.add(oldestHopAfterEndTS);
            }
            if (bucketHoplogs.size() <= 0) continue;
            allBuckets.add(bucketHoplogs);
        }
        return allBuckets;
    }

    private static Map<String, Long> getExpiredHoplogs(FileSystem fs, FileStatus[] bucketFiles, Pattern expiredPattern) throws IOException {
        HashMap<String, Long> expiredHoplogs = new HashMap<String, Long>();
        for (FileStatus file : bucketFiles) {
            String fileName;
            Matcher match;
            if (!file.isFile() || !(match = expiredPattern.matcher(fileName = file.getPath().getName())).matches()) continue;
            expiredHoplogs.put(fileName, file.getModificationTime());
        }
        return expiredHoplogs;
    }

    private static long expiredTime(FileStatus file, Map<String, Long> expiredHoplogs) {
        String expiredMarkerName = file.getPath().getName() + ".exp";
        long expiredTimeStamp = -1L;
        if (expiredHoplogs.containsKey(expiredMarkerName)) {
            expiredTimeStamp = expiredHoplogs.get(expiredMarkerName);
        }
        return expiredTimeStamp;
    }

    public static long readCleanUpIntervalMillis(FileSystem fs, Path cleanUpIntervalPath) throws IOException {
        if (fs.exists(cleanUpIntervalPath)) {
            FSDataInputStream input = new FSDataInputStream((InputStream)fs.open(cleanUpIntervalPath));
            long intervalDurationMillis = input.readLong();
            input.close();
            return intervalDurationMillis;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void exposeCleanupIntervalMillis(FileSystem fs, Path path, long intervalDurationMillis) {
        block22: {
            block21: {
                input = null;
                output = null;
                if (!fs.exists(path)) ** GOTO lbl22
                input = new FSDataInputStream((InputStream)fs.open(path));
                if (intervalDurationMillis != input.readLong()) break block21;
                input.close();
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException var6_5) {
                    // empty catch block
                }
                return;
            }
            input.close();
            fs.delete(path, true);
lbl22:
            // 2 sources

            output = fs.create(path);
            output.writeLong(intervalDurationMillis);
            output.close();
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                break block22;
            }
            catch (IOException var6_6) {}
            break block22;
            catch (IOException e) {
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException var7_8) {
                    // empty catch block
                }
                return;
                catch (Throwable var8_9) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException var9_10) {
                        // empty catch block
                    }
                    throw var8_9;
                }
            }
        }
    }

    public static Collection<FileStatus> getCheckpointFiles(Path regionPath, FileSystem fs) throws IOException {
        ArrayList<FileStatus> latestSnapshots = new ArrayList<FileStatus>();
        Collection<Collection<FileStatus>> allBuckets = HoplogUtil.getBucketHoplogs(regionPath, fs, ".chop", 0L, 0L);
        for (Collection<FileStatus> bucket : allBuckets) {
            FileStatus latestSnapshot = null;
            for (FileStatus file : bucket) {
                String name2;
                if (latestSnapshot == null) {
                    latestSnapshot = file;
                    continue;
                }
                String name1 = latestSnapshot.getPath().getName();
                if (AbstractHoplogOrganizer.HoplogComparator.compareByName(name1, name2 = file.getPath().getName()) <= 0) continue;
                latestSnapshot = file;
            }
            if (latestSnapshot == null) continue;
            latestSnapshots.add(latestSnapshot);
        }
        return latestSnapshots;
    }

    public static Map<FileStatus, BlockLocation[]> getBlocks(Configuration config, Collection<FileStatus> files) throws IOException {
        HashMap<FileStatus, BlockLocation[]> blocks = new HashMap<FileStatus, BlockLocation[]>();
        if (files == null || files.isEmpty()) {
            return blocks;
        }
        FileSystem fs = files.iterator().next().getPath().getFileSystem(config);
        for (FileStatus hoplog : files) {
            long length = hoplog.getLen();
            BlockLocation[] fileBlocks = fs.getFileBlockLocations(hoplog, 0L, length);
            blocks.put(hoplog, fileBlocks);
        }
        return blocks;
    }

    public static Collection<FileStatus> filterHoplogs(FileSystem fs, Path path, long start, long end, boolean snapshot) throws IOException {
        ArrayList<FileStatus> hoplogs = new ArrayList<FileStatus>();
        if (snapshot) {
            hoplogs.addAll(HoplogUtil.getCheckpointFiles(path, fs));
        } else {
            hoplogs.addAll(HoplogUtil.getRegionHoplogs(path, fs, ".hop", start, end));
        }
        if (hoplogs == null || hoplogs.isEmpty()) {
            hoplogs.addAll(HoplogUtil.getRegionHoplogs(path, fs, ".shop", start, end));
        }
        return hoplogs == null ? new ArrayList<FileStatus>() : hoplogs;
    }

    private HoplogUtil() {
    }

    public static class HoplogOptimizedSplitter
    extends CombineFileInputFormat<Long, Long> {
        private Collection<FileStatus> hoplogs;

        public HoplogOptimizedSplitter(Collection<FileStatus> hoplogs) {
            this.hoplogs = hoplogs;
        }

        protected List<FileStatus> listStatus(JobContext job) throws IOException {
            return new ArrayList<FileStatus>(this.hoplogs);
        }

        public List<InputSplit> getOptimizedSplits(Configuration conf) throws IOException {
            if (this.hoplogs == null || this.hoplogs.isEmpty()) {
                return null;
            }
            Path[] paths = new Path[this.hoplogs.size()];
            int i = 0;
            for (FileStatus file : this.hoplogs) {
                paths[i] = file.getPath();
                ++i;
            }
            FileStatus hoplog = this.hoplogs.iterator().next();
            long blockSize = hoplog.getBlockSize();
            this.setMaxSplitSize(blockSize);
            Job job = Job.getInstance((Configuration)conf);
            HoplogOptimizedSplitter.setInputPaths((Job)job, (Path[])paths);
            List splits = super.getSplits((JobContext)job);
            ArrayList<CombineFileSplit> newSplits = new ArrayList<CombineFileSplit>();
            Iterator iter = splits.iterator();
            while (iter.hasNext()) {
                FileStatus file;
                CombineFileSplit split = (CombineFileSplit)iter.next();
                if (split.getLocations() != null && split.getLocations().length > 0 || (paths = split.getPaths()).length == 0) continue;
                long[] starts = split.getStartOffsets();
                long[] ends = split.getLengths();
                FileSystem fs = paths[0].getFileSystem(conf);
                BlockLocation[] blks = fs.getFileBlockLocations(file = fs.getFileStatus(paths[0]), starts[0], ends[0]);
                if (blks == null || blks.length <= 0) continue;
                iter.remove();
                String[] hosts = blks[0].getHosts();
                split = new CombineFileSplit(paths, starts, ends, hosts);
                newSplits.add(split);
            }
            splits.addAll(newSplits);
            return splits;
        }

        public List<InputSplit> getSplits(JobContext job) throws IOException {
            throw new IllegalStateException();
        }

        public RecordReader<Long, Long> createRecordReader(InputSplit split, TaskAttemptContext arg1) throws IOException {
            throw new IllegalStateException();
        }
    }
}

