/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.RWSplitIterator;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.StreamSplitIterator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class HDFSSplitIterator {
    private CombineFileSplit split;
    private int currentHopIndex = 0;
    private AbstractHoplog hoplog;
    protected HoplogSetReader.HoplogIterator<byte[], byte[]> iterator;
    byte[] key;
    byte[] value;
    private long bytesRead;
    protected long RECORD_OVERHEAD = 8L;
    private long startTime = 0L;
    private long endTime = 0L;
    protected FileSystem fs;
    private static final Logger logger = LogService.getLogger();
    protected final String logPrefix = "<HDFSSplitIterator> ";

    public HDFSSplitIterator(FileSystem fs, Path[] paths, long[] offsets, long[] lengths, long startTime, long endTime) throws IOException {
        this.fs = fs;
        this.split = new CombineFileSplit(paths, offsets, lengths, null);
        while (this.currentHopIndex < this.split.getNumPaths() && !fs.exists(this.split.getPath(this.currentHopIndex))) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_CLEANED_UP_BY_JANITOR, this.split.getPath(this.currentHopIndex)));
            ++this.currentHopIndex;
        }
        if (this.currentHopIndex == this.split.getNumPaths()) {
            this.hoplog = null;
            this.iterator = null;
        } else {
            this.hoplog = this.getHoplog(fs, this.split.getPath(this.currentHopIndex));
            this.iterator = this.hoplog.getReader().scan(this.split.getOffset(this.currentHopIndex), this.split.getLength(this.currentHopIndex));
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static HDFSSplitIterator newInstance(FileSystem fs, Path[] path, long[] start, long[] len, long startTime, long endTime) throws IOException {
        String fileName = path[0].getName();
        if (fileName.endsWith(".shop")) {
            return new StreamSplitIterator(fs, path, start, len, startTime, endTime);
        }
        return new RWSplitIterator(fs, path, start, len, startTime, endTime);
    }

    public final boolean hasNext() throws IOException {
        while (this.currentHopIndex < this.split.getNumPaths()) {
            if (this.iterator != null) {
                if (this.iterator.hasNext()) {
                    return true;
                }
                this.iterator.close();
                this.iterator = null;
                this.hoplog.close();
                this.hoplog = null;
            }
            if (this.iterator != null) continue;
            ++this.currentHopIndex;
            while (this.currentHopIndex < this.split.getNumPaths() && !this.fs.exists(this.split.getPath(this.currentHopIndex))) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_CLEANED_UP_BY_JANITOR, this.split.getPath(this.currentHopIndex).toString()));
                ++this.currentHopIndex;
            }
            if (this.currentHopIndex >= this.split.getNumPaths()) {
                return false;
            }
            this.hoplog = this.getHoplog(this.fs, this.split.getPath(this.currentHopIndex));
            this.iterator = this.hoplog.getReader().scan(this.split.getOffset(this.currentHopIndex), this.split.getLength(this.currentHopIndex));
        }
        return false;
    }

    public final boolean next() throws IOException {
        while (this.hasNext()) {
            this.key = this.iterator.next();
            this.value = this.iterator.getValue();
            this.bytesRead += (long)(this.key.length + this.value.length);
            this.bytesRead += this.RECORD_OVERHEAD;
            if (this.startTime > 0L || this.endTime > 0L) {
                try {
                    PersistedEventImpl event = this.getDeserializedValue();
                    long timestamp = event.getTimstamp();
                    if (this.startTime > 0L && timestamp < this.startTime || this.endTime > 0L && timestamp > this.endTime) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new HDFSIOException("Error reading from HDFS", e);
                }
            }
            return true;
        }
        return false;
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }

    public final byte[] getKey() {
        return this.key;
    }

    public abstract PersistedEventImpl getDeserializedValue() throws ClassNotFoundException, IOException;

    protected abstract AbstractHoplog getHoplog(FileSystem var1, Path var2) throws IOException;

    public final byte[] getValue() {
        return this.value;
    }

    public final long getLength() {
        return this.split.getLength();
    }

    public void close() throws IOException {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        if (this.hoplog != null) {
            this.hoplog.close();
            this.hoplog.close();
        }
    }
}

