/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class GFOutputFormat
extends OutputFormat<Object, Object> {
    public static final String REGION = "mapreduce.output.gfoutputformat.outputregion";
    public static final String LOCATOR_HOST = "mapreduce.output.gfoutputformat.locatorhost";
    public static final String LOCATOR_PORT = "mapreduce.output.gfoutputformat.locatorport";
    public static final String SERVER_HOST = "mapreduce.output.gfoutputformat.serverhost";
    public static final String SERVER_PORT = "mapreduce.output.gfoutputformat.serverport";

    public RecordWriter<Object, Object> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        ClientCache cache = this.getClientCacheInstance(conf);
        return new GFRecordWriter(cache, context.getConfiguration());
    }

    public ClientCache getClientCacheInstance(Configuration conf) {
        String serverHost = conf.get(SERVER_HOST);
        ClientCache cache = serverHost == null || serverHost.isEmpty() ? this.createGFWriterUsingLocator(conf) : this.createGFWriterUsingServer(conf);
        return cache;
    }

    public ClientCache createGFWriterUsingLocator(Configuration conf) {
        String locator = conf.get(LOCATOR_HOST, "localhost");
        int port = conf.getInt(LOCATOR_PORT, 10334);
        ClientCacheFactory ccf = new ClientCacheFactory();
        ccf.addPoolLocator(locator, port);
        ClientCache cache = ccf.create();
        return cache;
    }

    public ClientCache createGFWriterUsingServer(Configuration conf) {
        String server = conf.get(SERVER_HOST);
        int port = conf.getInt(SERVER_PORT, 40404);
        ClientCacheFactory ccf = new ClientCacheFactory();
        ccf.addPoolServer(server, port);
        ClientCache cache = ccf.create();
        return cache;
    }

    public Region<Object, Object> getRegionInstance(Configuration conf, ClientCache cache) {
        Region<Object, Object> region;
        String regionName = conf.get(REGION);
        ClientRegionFactory regionFactory = cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        try {
            region = regionFactory.create(regionName);
        }
        catch (RegionExistsException e) {
            region = cache.getRegion(regionName);
        }
        return region;
    }

    public void executePut(Region<Object, Object> region, Object key, Object value) {
        region.put(key, value);
    }

    public void closeClientCache(ClientCache clientCache) {
        if (clientCache != null && !clientCache.isClosed()) {
            clientCache.close();
        }
    }

    protected void validateConfiguration(Configuration conf) throws InvalidJobConfException {
        String region = conf.get(REGION);
        if (region == null || region.trim().isEmpty()) {
            throw new InvalidJobConfException("Output Region name not provided.");
        }
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.validateConfiguration(conf);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new FileOutputCommitter(FileOutputFormat.getOutputPath((JobContext)context), context);
    }

    public class GFRecordWriter
    extends RecordWriter<Object, Object> {
        private ClientCache clientCache;
        private Region<Object, Object> region;

        public GFRecordWriter(ClientCache cache, Configuration conf) {
            this.clientCache = cache;
            this.region = GFOutputFormat.this.getRegionInstance(conf, this.clientCache);
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            GFOutputFormat.this.executePut(this.region, key, value);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            GFOutputFormat.this.closeClientCache(this.clientCache);
        }
    }
}

