/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.AbstractGFRecordReader;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFKey;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HoplogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GFInputFormat
extends InputFormat<GFKey, PersistedEventImpl>
implements Configurable {
    public static final String HOME_DIR = "mapreduce.input.gfinputformat.homedir";
    public static final String INPUT_REGION = "mapreduce.input.gfinputformat.inputregion";
    public static final String START_TIME = "mapreduce.input.gfinputformat.starttime";
    public static final String END_TIME = "mapreduce.input.gfinputformat.endtime";
    public static final String CHECKPOINT = "mapreduce.input.gfinputformat.checkpoint";
    protected Configuration conf;

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        this.conf = job.getConfiguration();
        Collection<FileStatus> hoplogs = this.getHoplogs();
        return this.createSplits(hoplogs);
    }

    protected Collection<FileStatus> getHoplogs() throws IOException {
        boolean checkpoint;
        long end;
        long start;
        String regionName = this.conf.get(INPUT_REGION);
        System.out.println("GFInputFormat: Region Name is " + regionName);
        if (regionName == null || regionName.trim().isEmpty()) {
            return new ArrayList<FileStatus>();
        }
        String home = this.conf.get(HOME_DIR, "gemfire");
        regionName = HDFSRegionDirector.HdfsRegionManager.getRegionFolder(regionName);
        Path regionPath = new Path(home + "/" + regionName);
        FileSystem fs = regionPath.getFileSystem(this.conf);
        ArrayList hoplogs = HoplogUtil.filterHoplogs(fs, regionPath, start = this.conf.getLong(START_TIME, 0L), end = this.conf.getLong(END_TIME, 0L), checkpoint = this.conf.getBoolean(CHECKPOINT, true));
        return hoplogs == null ? new ArrayList() : hoplogs;
    }

    private List<InputSplit> createSplits(Collection<FileStatus> hoplogs) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (hoplogs == null || hoplogs.isEmpty()) {
            return splits;
        }
        HoplogUtil.HoplogOptimizedSplitter splitter = new HoplogUtil.HoplogOptimizedSplitter(hoplogs);
        return splitter.getOptimizedSplits(this.conf);
    }

    public RecordReader<GFKey, PersistedEventImpl> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new AbstractGFRecordReader();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

