/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFKey;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HDFSSplitIterator;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class AbstractGFRecordReader
extends RecordReader<GFKey, PersistedEventImpl> {
    protected long RECORD_OVERHEAD = 8L;
    private long bytesRead;
    protected boolean isSequential;
    protected HDFSSplitIterator splitIterator;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        CombineFileSplit cSplit = (CombineFileSplit)split;
        Path[] path = cSplit.getPaths();
        long[] start = cSplit.getStartOffsets();
        long[] len = cSplit.getLengths();
        Configuration conf = context.getConfiguration();
        FileSystem fs = cSplit.getPath(0).getFileSystem(conf);
        this.splitIterator = HDFSSplitIterator.newInstance(fs, path, start, len, 0L, 0L);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.next();
    }

    protected boolean next() throws IOException {
        if (!this.hasNext()) {
            return false;
        }
        this.splitIterator.next();
        this.bytesRead += (long)(this.splitIterator.getKey().length + this.splitIterator.getValue().length);
        this.bytesRead += this.RECORD_OVERHEAD;
        return true;
    }

    protected boolean hasNext() throws IOException {
        return this.splitIterator.hasNext();
    }

    public GFKey getCurrentKey() throws IOException, InterruptedException {
        return this.getKey();
    }

    protected GFKey getKey() throws IOException {
        try {
            GFKey key = new GFKey();
            key.setKey(BlobHelper.deserializeBlob(this.splitIterator.getKey()));
            return key;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public PersistedEventImpl getCurrentValue() throws IOException, InterruptedException {
        return this.getValue();
    }

    protected PersistedEventImpl getValue() throws IOException {
        try {
            byte[] valueBytes = this.splitIterator.getValue();
            if (this.isSequential) {
                return UnsortedHoplogPersistedEvent.fromBytes(valueBytes);
            }
            return SortedHoplogPersistedEvent.fromBytes(valueBytes);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.getProgressRatio();
    }

    protected float getProgressRatio() throws IOException {
        if (!this.splitIterator.hasNext()) {
            return 1.0f;
        }
        if (this.bytesRead > this.splitIterator.getLength()) {
            return 0.95f;
        }
        return Math.min(1.0f, (float)this.bytesRead / (float)this.splitIterator.getLength());
    }

    public void close() throws IOException {
        this.splitIterator.close();
    }
}

