/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapred;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class GFOutputFormat
extends com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFOutputFormat
implements OutputFormat<Object, Object> {
    public RecordWriter<Object, Object> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        ClientCache cache = this.getClientCacheInstance((Configuration)job);
        return new GFRecordWriter(cache, (Configuration)job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.validateConfiguration((Configuration)job);
    }

    public class GFRecordWriter
    implements RecordWriter<Object, Object> {
        private ClientCache clientCache;
        private Region<Object, Object> region;

        public GFRecordWriter(ClientCache cache, Configuration conf) {
            this.clientCache = cache;
            this.region = GFOutputFormat.this.getRegionInstance(conf, this.clientCache);
        }

        public void write(Object key, Object value) throws IOException {
            GFOutputFormat.this.executePut(this.region, key, value);
        }

        public void close(Reporter reporter) throws IOException {
            GFOutputFormat.this.closeClientCache(this.clientCache);
        }
    }
}

