/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapred;

import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapred.AbstractGFRecordReader;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFKey;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HoplogUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class GFInputFormat
extends com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFInputFormat
implements InputFormat<GFKey, PersistedEventImpl>,
JobConfigurable {
    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.conf = job;
        Collection<FileStatus> hoplogs = this.getHoplogs();
        return this.createSplits(job, hoplogs);
    }

    private org.apache.hadoop.mapred.InputSplit[] createSplits(JobConf job, Collection<FileStatus> hoplogs) throws IOException {
        if (hoplogs == null || hoplogs.isEmpty()) {
            return new org.apache.hadoop.mapred.InputSplit[0];
        }
        HoplogUtil.HoplogOptimizedSplitter splitter = new HoplogUtil.HoplogOptimizedSplitter(hoplogs);
        List<InputSplit> mr2Splits = splitter.getOptimizedSplits(this.conf);
        org.apache.hadoop.mapred.InputSplit[] splits = new org.apache.hadoop.mapred.InputSplit[mr2Splits.size()];
        int i = 0;
        for (InputSplit inputSplit : mr2Splits) {
            CombineFileSplit mr2Spit = (CombineFileSplit)inputSplit;
            org.apache.hadoop.mapred.lib.CombineFileSplit split = new org.apache.hadoop.mapred.lib.CombineFileSplit(job, mr2Spit.getPaths(), mr2Spit.getStartOffsets(), mr2Spit.getLengths(), mr2Spit.getLocations());
            splits[i] = split;
            ++i;
        }
        return splits;
    }

    public RecordReader<GFKey, PersistedEventImpl> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        org.apache.hadoop.mapred.lib.CombineFileSplit cSplit = (org.apache.hadoop.mapred.lib.CombineFileSplit)split;
        AbstractGFRecordReader reader = new AbstractGFRecordReader();
        reader.initialize(cSplit, job);
        return reader;
    }

    public void configure(JobConf job) {
        this.conf = job;
    }
}

