/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.BloomFilter;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.cache.hdfs.internal.org.apache.hadoop.io.SequenceFile;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SequenceFileHoplog
extends AbstractHoplog {
    public SequenceFileHoplog(FileSystem inputFS, Path filePath, SortedOplogStatistics stats) throws IOException {
        super(inputFS, filePath, stats);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Hoplog.HoplogReader getReader() throws IOException {
        return new SequenceFileReader();
    }

    @Override
    public Hoplog.HoplogWriter createWriter(int keys) throws IOException {
        return new SequenceFileHoplogWriter();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close(boolean clearCache) throws IOException {
    }

    public boolean fixFileSize() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Fixing size of hoplog " + this.path, new Object[]{logPrefix});
        }
        IOException e = null;
        boolean exceptionThrown = false;
        for (int i = 0; i < 3; ++i) {
            block8: {
                try {
                    FSDataOutputStream stream = this.fsProvider.getFS().append(this.path);
                    stream.close();
                    stream = null;
                }
                catch (IOException ie) {
                    exceptionThrown = true;
                    e = ie;
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("{}Retry run " + (i + 1) + ": Hoplog " + this.path + " is still a temporary " + "hoplog because the node managing it wasn't shutdown properly last time. Failed to " + "fix the hoplog because an exception was thrown " + e, new Object[]{logPrefix});
                }
            }
            if (exceptionThrown) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } else {
                return true;
            }
            exceptionThrown = false;
        }
        logger.info(logPrefix, new Object[]{LocalizedMessage.create(LocalizedStrings.DEBUG, "Hoplog " + this.path + " is still a temporary " + "hoplog because the node managing it wasn't shutdown properly last time. Failed to " + "fix the hoplog because an exception was thrown " + e)});
        return false;
    }

    public String toString() {
        return "SequenceFileHplog[" + this.getFileName() + "]";
    }

    public static class SequenceFileIterator
    implements HoplogSetReader.HoplogIterator<byte[], byte[]> {
        SequenceFile.Reader reader = null;
        private BytesWritable prefetchedKey = null;
        private BytesWritable prefetchedValue = null;
        private byte[] currentKey;
        private byte[] currentValue;
        boolean hasNext = false;
        Logger logger;
        Path path;
        private long start;
        private long end;

        public SequenceFileIterator(FileSystem fs, Path path, long startOffset, long length, Configuration conf, Logger logger) throws IOException {
            SequenceFile.Reader.Option optPath = SequenceFile.Reader.file(path);
            String[] serializations = conf.getStrings("io.serializations", new String[]{"org.apache.hadoop.io.serializer.WritableSerialization"});
            conf.setStrings("io.serializations", new String[]{"org.apache.hadoop.io.serializer.WritableSerialization"});
            boolean emptyFile = false;
            try {
                this.reader = new SequenceFile.Reader(conf, optPath);
            }
            catch (EOFException e) {
                emptyFile = true;
            }
            conf.setStrings("io.serializations", serializations);
            this.logger = logger;
            this.path = path;
            if (emptyFile) {
                this.hasNext = false;
            } else {
                this.end = startOffset + length;
                if (startOffset > this.reader.getPosition()) {
                    this.reader.sync(startOffset);
                }
                this.start = this.reader.getPosition();
                boolean bl = this.hasNext = this.start < this.end;
                if (this.hasNext) {
                    this.readNext();
                }
            }
        }

        public Version getVersion() {
            String version = this.reader.getMetadata().get(new Text(Hoplog.Meta.GEMFIRE_VERSION.name())).toString();
            return Version.fromOrdinalOrCurrent(Short.parseShort(version));
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public byte[] next() {
            this.currentKey = this.prefetchedKey.getBytes();
            this.currentValue = this.prefetchedValue.getBytes();
            this.readNext();
            return this.currentKey;
        }

        private void readNext() {
            try {
                long pos = this.reader.getPosition();
                this.prefetchedKey = new BytesWritable();
                this.prefetchedValue = new BytesWritable();
                this.hasNext = this.reader.next((Writable)this.prefetchedKey, (Writable)this.prefetchedValue);
                if (pos >= this.end && this.reader.syncSeen()) {
                    this.hasNext = false;
                }
            }
            catch (EOFException e) {
                this.hasNext = false;
            }
            catch (IOException e) {
                this.hasNext = false;
                this.logger.error((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE, this.path), (Throwable)e);
                throw new HDFSIOException(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE.toLocalizedString(this.path), e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public void close() {
            IOUtils.closeStream((Closeable)this.reader);
        }

        @Override
        public byte[] getKey() {
            return this.currentKey;
        }

        @Override
        public byte[] getValue() {
            return this.currentValue;
        }

        public boolean syncSeen() {
            return this.reader.syncSeen();
        }

        public synchronized long getPosition() throws IOException {
            return this.reader.getPosition();
        }
    }

    public class SequenceFileReader
    implements Hoplog.HoplogReader,
    Closeable {
        @Override
        public byte[] read(byte[] key) throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan() throws IOException {
            return new SequenceFileIterator(SequenceFileHoplog.this.fsProvider.getFS(), SequenceFileHoplog.this.path, 0L, Long.MAX_VALUE, SequenceFileHoplog.this.conf, AbstractHoplog.logger);
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan(byte[] from, byte[] to) throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan(long startOffset, long length) throws IOException {
            return new SequenceFileIterator(SequenceFileHoplog.this.fsProvider.getFS(), SequenceFileHoplog.this.path, startOffset, length, SequenceFileHoplog.this.conf, AbstractHoplog.logger);
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public boolean isClosed() {
            throw new UnsupportedOperationException("Not supported for Sequence files.");
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files. Close the iterator instead.");
        }

        @Override
        public ByteBuffer get(byte[] key) throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public BloomFilter getBloomFilter() throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public long getEntryCount() {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public ICardinality getCardinalityEstimator() {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public long sizeEstimate() {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }
    }

    private class SequenceFileHoplogWriter
    implements Hoplog.HoplogWriter {
        private SequenceFile.Writer writer = null;

        public SequenceFileHoplogWriter() throws IOException {
            this.writer = AbstractHoplog.getSequenceFileWriter(SequenceFileHoplog.this.path, SequenceFileHoplog.this.conf, AbstractHoplog.logger);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            if (AbstractHoplog.logger.isDebugEnabled()) {
                AbstractHoplog.logger.debug("{}Completed creating hoplog " + SequenceFileHoplog.this.path, new Object[]{AbstractHoplog.logPrefix});
            }
        }

        @Override
        public void hsync() throws IOException {
            this.writer.hsyncWithSizeUpdate();
            if (AbstractHoplog.logger.isDebugEnabled()) {
                AbstractHoplog.logger.debug("{}hsync'ed a batch of data to hoplog " + SequenceFileHoplog.this.path, new Object[]{AbstractHoplog.logPrefix});
            }
        }

        @Override
        public void append(byte[] key, byte[] value) throws IOException {
            this.writer.append((Writable)new BytesWritable(key), (Writable)new BytesWritable(value));
        }

        @Override
        public void append(ByteBuffer key, ByteBuffer value) throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public void close(EnumMap<Hoplog.Meta, byte[]> metadata) throws IOException {
            throw new UnsupportedOperationException("Not supported for Sequence files");
        }

        @Override
        public long getCurrentSize() throws IOException {
            return this.writer.getLength();
        }
    }
}

