/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HFileSortedOplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.internal.cache.persistence.soplog.ByteComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class HoplogSetIterator
implements HoplogSetReader.HoplogIterator<ByteBuffer, ByteBuffer> {
    private final List<HFileSortedOplog.HFileReader.HFileSortedIterator> iters = new ArrayList<HFileSortedOplog.HFileReader.HFileSortedIterator>();
    private int entriesRemaining;
    private ByteBuffer currentKey;
    private ByteBuffer currentValue;

    public HoplogSetIterator(List<TrackedReference<Hoplog>> targets) throws IOException {
        for (TrackedReference<Hoplog> oplog : targets) {
            HFileSortedOplog.HFileReader.HFileSortedIterator iter = (HFileSortedOplog.HFileReader.HFileSortedIterator)oplog.get().getReader().scan();
            if (!iter.hasNext()) continue;
            iter.nextBB();
            this.iters.add(iter);
            this.entriesRemaining = (int)((long)this.entriesRemaining + oplog.get().getReader().getEntryCount());
        }
    }

    @Override
    public boolean hasNext() {
        return this.entriesRemaining > 0;
    }

    @Override
    public ByteBuffer next() throws IOException {
        return this.nextBB();
    }

    public ByteBuffer nextBB() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.seekToMinKeyIter();
        return this.currentKey;
    }

    private void seekToMinKeyIter() throws IOException {
        HFileSortedOplog.HFileReader.HFileSortedIterator currentIter = null;
        ByteBuffer minKey = null;
        Iterator<HFileSortedOplog.HFileReader.HFileSortedIterator> iterator = this.iters.iterator();
        while (iterator.hasNext()) {
            HFileSortedOplog.HFileReader.HFileSortedIterator iter = iterator.next();
            ByteBuffer tmpK = iter.getKeyBB();
            ByteBuffer tmpV = iter.getValueBB();
            if (minKey == null || ByteComparator.compareBytes(tmpK.array(), tmpK.arrayOffset(), tmpK.remaining(), minKey.array(), minKey.arrayOffset(), minKey.remaining()) < 0) {
                minKey = tmpK;
                this.currentKey = tmpK;
                this.currentValue = tmpV;
                currentIter = iter;
                continue;
            }
            if (this.seekHigherKeyInIter(minKey, iter) != null) continue;
            iter.close();
            iterator.remove();
        }
        if (currentIter != null && this.seekHigherKeyInIter(minKey, currentIter) == null) {
            currentIter.close();
            this.iters.remove(currentIter);
        }
    }

    private ByteBuffer seekHigherKeyInIter(ByteBuffer key, HFileSortedOplog.HFileReader.HFileSortedIterator iter) throws IOException {
        ByteBuffer newK = iter.getKeyBB();
        while (ByteComparator.compareBytes(newK.array(), newK.arrayOffset(), newK.remaining(), key.array(), key.arrayOffset(), key.remaining()) <= 0) {
            --this.entriesRemaining;
            if (iter.hasNext()) {
                newK = iter.nextBB();
                continue;
            }
            newK = null;
            break;
        }
        return newK;
    }

    @Override
    public ByteBuffer getKey() {
        return this.getKeyBB();
    }

    public ByteBuffer getKeyBB() {
        if (this.currentKey == null) {
            throw new IllegalStateException();
        }
        return this.currentKey;
    }

    @Override
    public ByteBuffer getValue() {
        return this.getValueBB();
    }

    public ByteBuffer getValueBB() {
        if (this.currentValue == null) {
            throw new IllegalStateException();
        }
        return this.currentValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (HoplogSetReader.HoplogIterator hoplogIterator : this.iters) {
            hoplogIterator.close();
        }
    }

    public int getRemainingEntryCount() {
        return this.entriesRemaining;
    }
}

