/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.internal.QueuedPersistentEvent;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.CompactionStatus;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSCompactionManager;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HFileSortedOplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogConfig;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetIterator;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HoplogUtil;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.hll.CardinalityMergeException;
import com.gemstone.gemfire.internal.hll.HyperLogLog;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.hll.MurmurHash;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.logging.log4j.message.Message;

public class HdfsSortedOplogOrganizer
extends AbstractHoplogOrganizer<SortedHoplogPersistedEvent> {
    public static final int AVG_NUM_KEYS_PER_INDEX_BLOCK = 200;
    public static final String SORTED_HOPLOG_REGEX = "(.+?)-(\\d+?)-(\\d+?)(.hop|.ihop|.chop)";
    public static final Pattern SORTED_HOPLOG_PATTERN = Pattern.compile("(.+?)-(\\d+?)-(\\d+?)(.hop|.ihop|.chop)");
    final long TMP_FILE_EXPIRATION_TIME_MS = Long.getLong("hoplog.tmp.file.expiration.ms", 600000L);
    static float RATIO = 1.3f;
    private HoplogOrganizer.Compactor compacter;
    private final HoplogReadersController hoplogReadersController;
    private AtomicLong previousCleanupTimestamp = new AtomicLong(Long.MIN_VALUE);
    public static double HLL_CONSTANT = 0.03;
    private volatile ICardinality bucketSize = new HyperLogLog(HLL_CONSTANT);
    private LinkedList<FileStatus> oldTmpFiles;
    private ConcurrentMap<Hoplog, Boolean> tmpFiles = new ConcurrentHashMap<Hoplog, Boolean>();
    protected volatile boolean organizerClosed = false;
    private boolean startCompactionOnStartup = false;

    public HdfsSortedOplogOrganizer(HDFSRegionDirector.HdfsRegionManager region, int bucketId) throws IOException {
        super(region, bucketId);
        String val = System.getProperty("hoplog.compaction.file.ratio");
        try {
            RATIO = Float.parseFloat(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hoplogReadersController = new HoplogReadersController();
        List<Hoplog> hoplogs = this.identifyAndLoadSortedOplogs(true);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Initializing bucket with existing hoplogs, count = " + hoplogs.size(), new Object[]{this.logPrefix});
        }
        for (Hoplog hoplog : hoplogs) {
            this.addSortedOplog(hoplog, false, true);
        }
        this.sequence = new AtomicInteger(HdfsSortedOplogOrganizer.findMaxSequenceNumber(hoplogs));
        this.initOldTmpFiles();
        FileSystem fs = this.store.getFileSystem();
        Path cleanUpIntervalPath = new Path(this.store.getHomeDir(), "cleanUpInterval");
        if (!fs.exists(cleanUpIntervalPath)) {
            long intervalDurationMillis = this.store.getPurgeInterval() * 60 * 1000;
            HoplogUtil.exposeCleanupIntervalMillis(fs, cleanUpIntervalPath, intervalDurationMillis);
        }
        if (this.startCompactionOnStartup) {
            this.forceCompactionOnVersionUpgrade();
            if (logger.isInfoEnabled()) {
                logger.info((Object)LocalizedStrings.HOPLOG_MAJOR_COMPACTION_SCHEDULED_FOR_BETTER_ESTIMATE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Iterator<? extends QueuedPersistentEvent> iterator, final int count) throws IOException, ForceReattemptException {
        assert (iterator != null);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Initializing flush operation", new Object[]{this.logPrefix});
        }
        final Hoplog so = this.getTmpSortedOplog(null, ".hop");
        Closeable writer = null;
        HyperLogLog localHLL = new HyperLogLog(HLL_CONSTANT);
        long start = this.stats.getFlush().begin();
        int byteCount = 0;
        try {
            try {
                writer = this.store.getSingletonWriter().runSerially(new Callable<Hoplog.HoplogWriter>(){

                    @Override
                    public Hoplog.HoplogWriter call() throws Exception {
                        return so.createWriter(count);
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            while (iterator.hasNext() && !this.organizerClosed) {
                HeapDataOutputStream out = new HeapDataOutputStream(1024, null);
                QueuedPersistentEvent item = iterator.next();
                item.toHoplogEventBytes(out);
                byte[] valueBytes = out.toByteArray();
                writer.append(item.getRawKey(), valueBytes);
                byteCount += item.getRawKey().length + valueBytes.length;
                if (this.isDeletedEntry(valueBytes, 0)) continue;
                int hash = MurmurHash.hash(item.getRawKey());
                localHLL.offerHashed(hash);
            }
            if (this.organizerClosed) {
                throw new BucketMovedException("The current bucket is moved BucketID: " + this.bucketId + " Region name: " + this.regionManager.getRegion().getName());
            }
            writer.close(this.buildMetaData(localHLL));
            writer = null;
        }
        catch (IOException e) {
            this.stats.getFlush().error(start);
            try {
                e = this.handleWriteHdfsIOError((Hoplog.HoplogWriter)writer, so, e);
            }
            finally {
                writer = null;
            }
            throw e;
        }
        catch (BucketMovedException e) {
            this.stats.getFlush().error(start);
            this.deleteTmpFile((Hoplog.HoplogWriter)writer, so);
            writer = null;
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            this.pingSecondaries();
            Object e = this.changePrimarylockObject;
            synchronized (e) {
                if (this.organizerClosed) {
                    throw new BucketMovedException("The current bucket is moved BucketID: " + this.bucketId + " Region name: " + this.regionManager.getRegion().getName());
                }
                HdfsSortedOplogOrganizer.makeLegitimate(so);
            }
            try {
                so.getSize();
            }
            catch (IllegalStateException e2) {
                throw new IOException("Failed to rename hoplog file:" + so.getFileName());
            }
            this.addSortedOplog(so, false, true);
            this.stats.getFlush().end(byteCount, start);
            this.incrementDiskUsage(so.getSize());
        }
        catch (BucketMovedException e) {
            this.stats.getFlush().error(start);
            this.deleteTmpFile((Hoplog.HoplogWriter)writer, so);
            writer = null;
            throw e;
        }
        catch (IOException e) {
            this.stats.getFlush().error(start);
            logger.warn((Object)LocalizedStrings.HOPLOG_FLUSH_OPERATION_FAILED, (Throwable)e);
            throw e;
        }
        this.submitCompactionRequests();
    }

    private EnumMap<Hoplog.Meta, byte[]> buildMetaData(ICardinality localHLL) throws IOException {
        EnumMap<Hoplog.Meta, byte[]> map = new EnumMap<Hoplog.Meta, byte[]>(Hoplog.Meta.class);
        map.put(Hoplog.Meta.LOCAL_CARDINALITY_ESTIMATE_V2, localHLL.getBytes());
        return map;
    }

    private void submitCompactionRequests() throws IOException {
        HDFSCompactionManager.CompactionRequest req;
        if (this.store.getMajorCompaction() && this.isMajorCompactionNeeded()) {
            req = new HDFSCompactionManager.CompactionRequest(this.regionFolder, this.bucketId, this.getCompactor(), true);
            HDFSCompactionManager.getInstance(this.store).submitRequest(req);
        }
        if (this.store.getMinorCompaction()) {
            req = new HDFSCompactionManager.CompactionRequest(this.regionFolder, this.bucketId, this.getCompactor(), false);
            HDFSCompactionManager.getInstance(this.store).submitRequest(req);
        }
    }

    private boolean isMajorCompactionNeeded() throws IOException {
        long majorCInterval = (long)this.store.getMajorCompactionInterval() * 60L * 1000L;
        Hoplog oplog = this.hoplogReadersController.getOldestHoplog();
        if (oplog == null) {
            return false;
        }
        long oldestFileTime = oplog.getModificationTimeStamp();
        long now = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("{}Checking oldest hop " + oplog.getFileName() + " for majorCompactionInterval=" + majorCInterval + " + now=" + now, new Object[]{this.logPrefix});
        }
        return oldestFileTime > 0L && oldestFileTime < now - majorCInterval;
    }

    @Override
    public SortedHoplogPersistedEvent read(byte[] key) throws IOException {
        long startTime = this.stats.getRead().begin();
        String user = logger.isDebugEnabled() ? "Read" : null;
        List hoplogs = null;
        hoplogs = this.hoplogReadersController.getTrackedSortedOplogList(user);
        try {
            for (TrackedReference hoplog : hoplogs) {
                Hoplog.HoplogReader reader = ((Hoplog)hoplog.get()).getReader();
                byte[] val = (byte[])reader.read(key);
                if (val == null) continue;
                SortedHoplogPersistedEvent eventObj = this.deserializeValue(val);
                this.stats.getRead().end(val.length, startTime);
                SortedHoplogPersistedEvent sortedHoplogPersistedEvent = eventObj;
                return sortedHoplogPersistedEvent;
            }
        }
        catch (IllegalArgumentException e) {
            if (IOException.class.isAssignableFrom(e.getCause().getClass())) {
                throw this.handleIOError((IOException)e.getCause());
            }
            throw e;
        }
        catch (IOException e) {
            throw this.handleIOError(e);
        }
        catch (HDFSIOException e) {
            throw this.handleIOError(e);
        }
        finally {
            this.hoplogReadersController.releaseHoplogs(hoplogs, user);
        }
        this.stats.getRead().end(0L, startTime);
        return null;
    }

    protected IOException handleIOError(IOException e) {
        if (e instanceof RemoteException) {
            return ((RemoteException)e).unwrapRemoteException();
        }
        this.checkForSafeError(e);
        return e;
    }

    protected HDFSIOException handleIOError(HDFSIOException e) {
        this.checkForSafeError(e);
        return e;
    }

    protected void checkForSafeError(Exception e) {
        boolean safeError = ShutdownHookManager.get().isShutdownInProgress();
        if (safeError) {
            if (logger.isDebugEnabled()) {
                logger.debug("IO error caused by filesystem shutdown", (Throwable)e);
            }
            throw new CacheClosedException("IO error caused by filesystem shutdown", e);
        }
        if (this.isClosed()) {
            throw new PrimaryBucketException(e);
        }
    }

    protected IOException handleWriteHdfsIOError(Hoplog.HoplogWriter writer, Hoplog so, IOException e) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Handle write error:" + so, new Object[]{this.logPrefix});
        }
        this.closeWriter(writer);
        this.tmpFiles.put(so, Boolean.TRUE);
        return this.handleIOError(e);
    }

    private void deleteTmpFile(Hoplog.HoplogWriter writer, Hoplog so) {
        this.closeWriter(writer);
        try {
            if (so != null) {
                so.delete();
            }
        }
        catch (IOException e1) {
            logger.info((Object)e1);
        }
    }

    private void closeWriter(Hoplog.HoplogWriter writer) {
        block3: {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable e1) {
                    if (this.isClosed()) break block3;
                    logger.info((Object)e1);
                }
            }
        }
    }

    private void closeReaderAndSuppressError(Hoplog hoplog, boolean clearCache) {
        try {
            hoplog.close();
        }
        catch (IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)e).unwrapRemoteException();
            }
            logger.info((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketIterator scan() throws IOException {
        String user = logger.isDebugEnabled() ? "Scan" : null;
        List hoplogs = null;
        BucketIterator iter = null;
        try {
            hoplogs = this.hoplogReadersController.getTrackedSortedOplogList(user);
            BucketIterator bucketIterator = iter = new BucketIterator(hoplogs);
            return bucketIterator;
        }
        finally {
            if (iter == null) {
                this.hoplogReadersController.releaseHoplogs(hoplogs, user);
            }
        }
    }

    public BucketIterator scan(byte[] from, byte[] to) throws IOException {
        throw new NotImplementedException();
    }

    public BucketIterator scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public HoplogSetReader.HoplogIterator<byte[], SortedHoplogPersistedEvent> scan(long startOffset, long length) throws IOException {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        Object object = this.changePrimarylockObject;
        synchronized (object) {
            this.organizerClosed = true;
        }
        this.getCompactor().suspend();
        this.hoplogReadersController.close();
        this.previousCleanupTimestamp.set(Long.MIN_VALUE);
    }

    @Override
    public void hoplogCreated(String region, int bucketId, Hoplog ... oplogs) throws IOException {
        for (Hoplog oplog : oplogs) {
            this.addSortedOplog(oplog, false, true);
        }
    }

    @Override
    public long sizeEstimate() {
        return this.bucketSize.cardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSortedOplog(Hoplog so, boolean notify, boolean addsToBucketSize) throws IOException {
        String user;
        if (!this.hoplogReadersController.addSortedOplog(so)) {
            so.close();
            throw new InternalGemFireException("Failed to add " + so);
        }
        String string = user = logger.isDebugEnabled() ? "Add" : null;
        if (addsToBucketSize) {
            TrackedReference ref = null;
            try {
                ref = this.hoplogReadersController.trackHoplog(so, user);
                ICardinality iCardinality = this.bucketSize;
                synchronized (iCardinality) {
                    ICardinality localHLL = ((Hoplog)ref.get()).getEntryCountEstimate();
                    if (localHLL != null) {
                        this.bucketSize = this.mergeHLL(this.bucketSize, localHLL);
                    }
                }
            }
            finally {
                if (ref != null) {
                    this.hoplogReadersController.releaseHoplog(ref, user);
                }
            }
        }
        if (notify && this.listener != null) {
            this.listener.hoplogCreated(this.regionFolder, this.bucketId, so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEstimateBucketSize() throws IOException {
        ICardinality global = null;
        String user = logger.isDebugEnabled() ? "HLL" : null;
        List hoplogs = null;
        try {
            hoplogs = this.hoplogReadersController.getTrackedSortedOplogList(user);
            global = new HyperLogLog(HLL_CONSTANT);
            for (TrackedReference hop : hoplogs) {
                global = this.mergeHLL(global, ((Hoplog)hop.get()).getEntryCountEstimate());
            }
        }
        finally {
            this.hoplogReadersController.releaseHoplogs(hoplogs, user);
        }
        this.bucketSize = global;
    }

    protected ICardinality mergeHLL(ICardinality global, ICardinality local) {
        try {
            return global.merge(local);
        }
        catch (CardinalityMergeException e) {
            this.startCompactionOnStartup = true;
            return global;
        }
    }

    private void removeSortedOplog(TrackedReference<Hoplog> so, boolean notify) throws IOException {
        this.hoplogReadersController.removeSortedOplog(so);
        if (notify && this.listener != null) {
            this.listener.hoplogDeleted(this.regionFolder, this.bucketId, so.get());
        }
    }

    private void notifyCompactionListeners(boolean isMajor) {
        this.listener.compactionCompleted(this.regionFolder, this.bucketId, isMajor);
    }

    @Override
    public void hoplogDeleted(String region, int bucketId, Hoplog ... oplogs) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized HoplogOrganizer.Compactor getCompactor() {
        if (this.compacter == null) {
            this.compacter = new HoplogCompactor();
        }
        return this.compacter;
    }

    @Override
    protected Hoplog getHoplog(Path hoplogPath) throws IOException {
        HFileSortedOplog so = new HFileSortedOplog(this.store, hoplogPath, this.store.getBlockCache(), this.stats, this.store.getStats());
        return so;
    }

    void markSortedOplogForDeletion(List<TrackedReference<Hoplog>> targets, boolean notify) throws IOException {
        for (int i = targets.size(); i > 0; --i) {
            TrackedReference<Hoplog> so = targets.get(i - 1);
            this.removeSortedOplog(so, true);
            if (!this.store.getFileSystem().exists(new Path(this.bucketPath, so.get().getFileName()))) continue;
            this.addExpiryMarkerForAFile(so.get());
        }
    }

    synchronized int initiateCleanup() throws IOException {
        int conf = this.store.getPurgeInterval();
        long intervalDurationMillis = conf * 60 * 1000;
        long targetTS = System.currentTimeMillis() - intervalDurationMillis;
        if (logger.isDebugEnabled()) {
            logger.debug("Target timestamp for expired hoplog deletion " + targetTS, new Object[]{this.logPrefix});
        }
        if (this.previousCleanupTimestamp.get() > targetTS && this.previousCleanupTimestamp.get() - targetTS < intervalDurationMillis / 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skip cleanup, previous " + this.previousCleanupTimestamp.get(), new Object[]{this.logPrefix});
            }
            return 0;
        }
        List<FileStatus> targets = this.getOptimizationTargets(targetTS);
        return this.deleteExpiredFiles(targets);
    }

    protected int deleteExpiredFiles(List<FileStatus> targets) throws IOException {
        if (targets == null) {
            return 0;
        }
        for (FileStatus file : targets) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Deleting file: " + file.getPath(), new Object[]{this.logPrefix});
            }
            this.store.getFileSystem().delete(file.getPath(), false);
            if (this.isClosed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Expiry file cleanup interupted by bucket close", new Object[]{this.logPrefix});
                }
                return 0;
            }
            this.incrementDiskUsage(-1L * file.getLen());
        }
        this.previousCleanupTimestamp.set(System.currentTimeMillis());
        return targets.size();
    }

    protected List<FileStatus> getOptimizationTargets(long ts) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Identifying optimization targets " + ts, new Object[]{this.logPrefix});
        }
        ArrayList<FileStatus> deleteTargets = new ArrayList<FileStatus>();
        FileStatus[] markers = this.getExpiryMarkers();
        if (markers != null) {
            for (FileStatus marker : markers) {
                String name = this.truncateExpiryExtension(marker.getPath().getName());
                long timestamp = marker.getModificationTime();
                boolean isTarget = false;
                if (name.endsWith(".ihop")) {
                    isTarget = true;
                } else if (timestamp < ts && name.endsWith(".hop")) {
                    isTarget = true;
                } else if (timestamp < ts && name.endsWith(".chop")) {
                    long majorCInterval = (long)this.store.getMajorCompactionInterval() * 60L * 1000L;
                    if (timestamp < System.currentTimeMillis() - majorCInterval) {
                        isTarget = true;
                    }
                }
                if (!isTarget) continue;
                TrackedReference<Hoplog> used = this.hoplogReadersController.getInactiveHoplog(name);
                if (used != null) {
                    if (used.inUse() && logger.isDebugEnabled()) {
                        logger.debug("{}Optimizer: found active expired hoplog:" + name, new Object[]{this.logPrefix});
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{}Optimizer: found open expired hoplog:" + name, new Object[]{this.logPrefix});
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Delete target identified " + marker.getPath(), new Object[]{this.logPrefix});
                }
                deleteTargets.add(marker);
                Path hoplogPath = new Path(this.bucketPath, name);
                if (!this.store.getFileSystem().exists(hoplogPath)) continue;
                FileStatus hoplog = this.store.getFileSystem().getFileStatus(hoplogPath);
                deleteTargets.add(hoplog);
            }
        }
        return deleteTargets;
    }

    List<Hoplog> identifyAndLoadSortedOplogs(boolean countSize) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        if (!fs.exists(this.bucketPath)) {
            return new ArrayList<Hoplog>();
        }
        FileStatus[] allFiles = fs.listStatus(this.bucketPath);
        ArrayList<FileStatus> validFiles = new ArrayList<FileStatus>();
        for (FileStatus file : allFiles) {
            Matcher matcher = HOPLOG_NAME_PATTERN.matcher(file.getPath().getName());
            if (!matcher.matches()) continue;
            if (countSize) {
                this.incrementDiskUsage(file.getLen());
            }
            if (!(matcher = SORTED_HOPLOG_PATTERN.matcher(file.getPath().getName())).matches()) continue;
            validFiles.add(file);
        }
        FileStatus[] markers = this.getExpiryMarkers();
        FileStatus[] validHoplogs = HdfsSortedOplogOrganizer.filterValidHoplogs(validFiles.toArray(new FileStatus[validFiles.size()]), markers);
        ArrayList<Hoplog> results = new ArrayList<Hoplog>();
        if (validHoplogs == null || validHoplogs.length == 0) {
            return results;
        }
        for (int i = 0; i < validHoplogs.length; ++i) {
            Path p;
            if (validHoplogs[i].isDirectory() || fs.getFileStatus(p = validHoplogs[i].getPath()).getLen() <= 0L) continue;
            HFileSortedOplog hoplog = new HFileSortedOplog(this.store, p, this.store.getBlockCache(), this.stats, this.store.getStats());
            results.add(hoplog);
        }
        return results;
    }

    private static int findMaxSequenceNumber(List<Hoplog> hoplogs) throws IOException {
        int maxSeq = 0;
        for (Hoplog hoplog : hoplogs) {
            maxSeq = Math.max(maxSeq, HdfsSortedOplogOrganizer.getSequenceNumber(hoplog));
        }
        return maxSeq;
    }

    static int getSequenceNumber(Hoplog hoplog) {
        Matcher matcher = SORTED_HOPLOG_PATTERN.matcher(hoplog.getFileName());
        boolean matched = matcher.find();
        assert (matched);
        return Integer.valueOf(matcher.group(3));
    }

    protected FileStatus[] getExpiryMarkers() throws IOException {
        FileSystem fs = this.store.getFileSystem();
        if (!(this.hoplogReadersController.hoplogs != null && this.hoplogReadersController.hoplogs.size() != 0 || fs.exists(this.bucketPath))) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}This bucket is unused, skipping expired hoplog check", new Object[]{this.logPrefix});
            }
            return null;
        }
        FileStatus[] files = FSUtils.listStatus((FileSystem)fs, (Path)this.bucketPath, (PathFilter)new PathFilter(){

            public boolean accept(Path file) {
                String fileName = file.getName();
                if (!fileName.endsWith(".exp")) {
                    return false;
                }
                fileName = HdfsSortedOplogOrganizer.this.truncateExpiryExtension(fileName);
                Matcher matcher = SORTED_HOPLOG_PATTERN.matcher(fileName);
                return matcher.find();
            }
        });
        return files;
    }

    @Override
    public void clear() throws IOException {
        this.getCompactor().suspend();
        String user = logger.isDebugEnabled() ? "clear" : null;
        List oplogs = null;
        try {
            oplogs = this.hoplogReadersController.getTrackedSortedOplogList(user);
            this.markSortedOplogForDeletion(oplogs, true);
        }
        finally {
            if (oplogs != null) {
                this.hoplogReadersController.releaseHoplogs(oplogs, user);
            }
            this.getCompactor().resume();
        }
    }

    @Override
    public void performMaintenance() throws IOException {
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("{}Executing bucket maintenance", new Object[]{this.logPrefix});
        }
        this.submitCompactionRequests();
        this.hoplogReadersController.closeInactiveHoplogs();
        this.initiateCleanup();
        this.cleanupTmpFiles();
        if (logger.isDebugEnabled()) {
            logger.debug("{}Time spent in bucket maintenance (in ms): " + (System.currentTimeMillis() - startTime), new Object[]{this.logPrefix});
        }
    }

    @Override
    public Future<CompactionStatus> forceCompaction(boolean isMajor) {
        HDFSCompactionManager.CompactionRequest request = new HDFSCompactionManager.CompactionRequest(this.regionFolder, this.bucketId, this.getCompactor(), isMajor, true);
        return HDFSCompactionManager.getInstance(this.store).submitRequest(request);
    }

    private Future<CompactionStatus> forceCompactionOnVersionUpgrade() {
        HDFSCompactionManager.CompactionRequest request = new HDFSCompactionManager.CompactionRequest(this.regionFolder, this.bucketId, this.getCompactor(), true, true, true);
        return HDFSCompactionManager.getInstance(this.store).submitRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastMajorCompactionTimestamp() {
        long ts = 0L;
        String user = logger.isDebugEnabled() ? "StoredProc" : null;
        List hoplogs = this.hoplogReadersController.getTrackedSortedOplogList(user);
        try {
            for (TrackedReference hoplog : hoplogs) {
                String fileName = ((Hoplog)hoplog.get()).getFileName();
                Matcher file = HOPLOG_NAME_PATTERN.matcher(fileName);
                if (!file.matches() || !fileName.endsWith(".chop")) continue;
                ts = HdfsSortedOplogOrganizer.getHoplogTimestamp(file);
                break;
            }
        }
        finally {
            this.hoplogReadersController.releaseHoplogs(hoplogs, user);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}HDFS: for bucket:" + this.getRegionBucketStr() + " returning last major compaction timestamp " + ts, new Object[]{this.logPrefix});
        }
        return ts;
    }

    private void initOldTmpFiles() throws IOException {
        FileSystem fs = this.store.getFileSystem();
        if (!fs.exists(this.bucketPath)) {
            return;
        }
        this.oldTmpFiles = new LinkedList<FileStatus>(Arrays.asList(fs.listStatus(this.bucketPath, (PathFilter)new TmpFilePathFilter())));
    }

    private void cleanupTmpFiles() throws IOException {
        if (this.oldTmpFiles == null && this.tmpFiles == null) {
            return;
        }
        if (this.oldTmpFiles != null) {
            FileSystem fs = this.store.getFileSystem();
            long now = System.currentTimeMillis();
            Iterator itr = this.oldTmpFiles.iterator();
            while (itr.hasNext()) {
                FileStatus file = (FileStatus)itr.next();
                if (file.getModificationTime() + this.TMP_FILE_EXPIRATION_TIME_MS <= now) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Deleting temporary file:" + file.getPath(), new Object[]{this.logPrefix});
                }
                fs.delete(file.getPath(), false);
                itr.remove();
            }
        }
        if (this.tmpFiles != null) {
            for (Hoplog so : this.tmpFiles.keySet()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Deleting temporary file:" + so.getFileName(), new Object[]{this.logPrefix});
                }
                this.deleteTmpFile(null, so);
            }
        }
    }

    Float computeGain(int from, int to, List<TrackedReference<Hoplog>> targets) {
        double SIZE_64K = 65536.0;
        double LOG_BASE = Math.log(200.0);
        long totalSize = 0L;
        double costBefore = 0.0;
        for (int i = from; i <= to; ++i) {
            long size = targets.get(i).get().getSize();
            if (size == 0L) continue;
            totalSize += size;
            costBefore += Math.ceil(Math.max(1.0, Math.log((double)size / SIZE_64K) / LOG_BASE)) + 1.0;
        }
        long firstFileSize = targets.get(from).get().getSize();
        if ((float)firstFileSize > (float)(totalSize - firstFileSize) * RATIO) {
            if (logger.isDebugEnabled()) {
                this.fineLog("First file too big:", firstFileSize, " totalSize:", totalSize);
            }
            return null;
        }
        long totalSizeInMb = totalSize / 1024L / 1024L;
        if (totalSizeInMb == 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Total size too small:" + totalSize, new Object[]{this.logPrefix});
            }
            return Float.valueOf((float)costBefore);
        }
        double costAfter = Math.ceil(Math.log((double)totalSize / SIZE_64K) / LOG_BASE) + 1.0;
        return Float.valueOf((float)((costBefore - costAfter) / (double)totalSizeInMb));
    }

    public List<TrackedReference<Hoplog>> getSortedOplogs() throws IOException {
        ArrayList<TrackedReference<Hoplog>> oplogs = new ArrayList<TrackedReference<Hoplog>>();
        for (TrackedReference oplog : this.hoplogReadersController.hoplogs) {
            oplogs.add(oplog);
        }
        return oplogs;
    }

    private void fineLog(Object ... strings) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = this.concatString(strings);
            logger.debug(this.logPrefix + sb.toString());
        }
    }

    private StringBuffer concatString(Object ... strings) {
        StringBuffer sb = new StringBuffer();
        for (Object str : strings) {
            sb.append(str.toString());
        }
        return sb;
    }

    @Override
    public void compactionCompleted(String region, int bucket, boolean isMajor) {
    }

    private static class TmpFilePathFilter
    implements PathFilter {
        private TmpFilePathFilter() {
        }

        public boolean accept(Path path) {
            Matcher matcher = AbstractHoplogOrganizer.HOPLOG_NAME_PATTERN.matcher(path.getName());
            return matcher.matches() && path.getName().endsWith(".tmp");
        }
    }

    public class BucketIterator
    implements HoplogSetReader.HoplogIterator<byte[], SortedHoplogPersistedEvent> {
        final List<TrackedReference<Hoplog>> hoplogList;
        HoplogSetIterator mergedIter;

        public BucketIterator(List<TrackedReference<Hoplog>> hoplogs) throws IOException {
            this.hoplogList = hoplogs;
            try {
                this.mergedIter = new HoplogSetIterator(this.hoplogList);
                if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                    for (TrackedReference<Hoplog> hoplog : hoplogs) {
                        AbstractHoplogOrganizer.logger.debug("{}BucketIter target hop:" + hoplog.get().getFileName(), new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (IOException.class.isAssignableFrom(e.getCause().getClass())) {
                    throw HdfsSortedOplogOrganizer.this.handleIOError((IOException)e.getCause());
                }
                throw e;
            }
            catch (IOException e) {
                throw HdfsSortedOplogOrganizer.this.handleIOError(e);
            }
            catch (HDFSIOException e) {
                throw HdfsSortedOplogOrganizer.this.handleIOError(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.mergedIter.hasNext();
        }

        @Override
        public byte[] next() throws IOException {
            try {
                return HFileSortedOplog.byteBufferToArray(this.mergedIter.next());
            }
            catch (IllegalArgumentException e) {
                if (IOException.class.isAssignableFrom(e.getCause().getClass())) {
                    throw HdfsSortedOplogOrganizer.this.handleIOError((IOException)e.getCause());
                }
                throw e;
            }
            catch (IOException e) {
                throw HdfsSortedOplogOrganizer.this.handleIOError(e);
            }
        }

        @Override
        public byte[] getKey() {
            return HFileSortedOplog.byteBufferToArray(this.mergedIter.getKey());
        }

        @Override
        public SortedHoplogPersistedEvent getValue() {
            try {
                return HdfsSortedOplogOrganizer.this.deserializeValue(HFileSortedOplog.byteBufferToArray(this.mergedIter.getValue()));
            }
            catch (IOException e) {
                throw new HDFSIOException("Failed to deserialize byte while iterating on partition", e);
            }
        }

        @Override
        public void remove() {
            this.mergedIter.remove();
        }

        @Override
        public void close() {
            String user = AbstractHoplogOrganizer.logger.isDebugEnabled() ? "Scan" : null;
            HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(this.hoplogList, user);
        }
    }

    private class HoplogReadersController
    implements Hoplog.HoplogReaderActivityListener {
        private Integer maxOpenFilesLimit;
        private final ConcurrentSkipListSet<TrackedReference<Hoplog>> hoplogs;
        private final ConcurrentHashSet<TrackedReference<Hoplog>> inactiveHoplogs;
        private final ReadWriteLock hoplogRWLock = new ReentrantReadWriteLock(true);
        private AtomicInteger activeReaderCount = new AtomicInteger(0);

        public HoplogReadersController() {
            AbstractHoplogOrganizer.HoplogComparator comp = new AbstractHoplogOrganizer.HoplogComparator();
            this.hoplogs = new ConcurrentSkipListSet<TrackedReference<Hoplog>>((Comparator)comp){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean add(TrackedReference<Hoplog> e) {
                    boolean result = super.add(e);
                    if (result) {
                        HdfsSortedOplogOrganizer.this.stats.incActiveFiles(1);
                    }
                    return result;
                }

                @Override
                public boolean remove(Object o) {
                    boolean result = super.remove(o);
                    if (result) {
                        HdfsSortedOplogOrganizer.this.stats.incActiveFiles(-1);
                    }
                    return result;
                }
            };
            this.inactiveHoplogs = new ConcurrentHashSet<TrackedReference<Hoplog>>(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean add(TrackedReference<Hoplog> e) {
                    boolean result = super.add(e);
                    if (result) {
                        HdfsSortedOplogOrganizer.this.stats.incInactiveFiles(1);
                    }
                    return result;
                }

                @Override
                public boolean remove(Object o) {
                    boolean result = super.remove(o);
                    if (result) {
                        HdfsSortedOplogOrganizer.this.stats.incInactiveFiles(-1);
                    }
                    return result;
                }
            };
            this.maxOpenFilesLimit = Integer.getInteger("hoplog.bucket.max.open.files", HoplogConfig.BUCKET_MAX_OPEN_HFILES_DEFAULT);
        }

        Hoplog getOldestHoplog() {
            if (this.hoplogs.isEmpty()) {
                return null;
            }
            return this.hoplogs.last().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addSortedOplog(Hoplog so) throws IOException {
            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                AbstractHoplogOrganizer.logger.debug("{}Try add " + so, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
            }
            this.hoplogRWLock.writeLock().lock();
            try {
                int size = this.hoplogs.size();
                boolean result = this.hoplogs.add(new TrackedReference<Hoplog>(so));
                so.setReaderActivityListener(this);
                if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                    HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Added: ", so, " Before:", size, " After:", this.hoplogs.size()});
                }
                boolean bl = result;
                return bl;
            }
            finally {
                this.hoplogRWLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeSortedOplog(TrackedReference<Hoplog> so) throws IOException {
            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                AbstractHoplogOrganizer.logger.debug("Try remove " + so, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
            }
            this.hoplogRWLock.writeLock().lock();
            try {
                int size = this.hoplogs.size();
                boolean result = this.hoplogs.remove(so);
                if (result) {
                    this.inactiveHoplogs.add(so);
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Removed: ", so, " Before:", size, " After:", this.hoplogs.size()});
                    }
                } else if (this.inactiveHoplogs.contains(so)) {
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("{}Found a missing active hoplog in inactive list." + so, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                } else {
                    so.get().close();
                    AbstractHoplogOrganizer.logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_MISSING_IN_BUCKET_FORCED_CLOSED, so.get()));
                }
            }
            finally {
                this.hoplogRWLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeInactiveHoplogs() throws IOException {
            this.hoplogRWLock.writeLock().lock();
            try {
                for (TrackedReference<Hoplog> hoplog : this.inactiveHoplogs) {
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("{}Try close inactive " + hoplog, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                    if (hoplog.inUse()) continue;
                    int size = this.inactiveHoplogs.size();
                    this.inactiveHoplogs.remove(hoplog);
                    HdfsSortedOplogOrganizer.this.closeReaderAndSuppressError(hoplog.get(), true);
                    if (!AbstractHoplogOrganizer.logger.isDebugEnabled()) continue;
                    HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Closed inactive: ", hoplog.get(), " Before:", size, " After:", this.inactiveHoplogs.size()});
                }
            }
            finally {
                this.hoplogRWLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TrackedReference<Hoplog> getInactiveHoplog(String target) throws IOException {
            this.hoplogRWLock.writeLock().lock();
            try {
                for (TrackedReference<Hoplog> hoplog : this.inactiveHoplogs) {
                    if (!hoplog.get().getFileName().equals(target)) continue;
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("{}Target found in inactive hoplogs list: " + hoplog, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                    TrackedReference<Hoplog> trackedReference = hoplog;
                    return trackedReference;
                }
                if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                    AbstractHoplogOrganizer.logger.debug("{}Target not found in inactive hoplogs list: " + target, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                }
                Iterator<TrackedReference<Hoplog>> iterator = null;
                return iterator;
            }
            finally {
                this.hoplogRWLock.writeLock().unlock();
            }
        }

        public void close() throws IOException {
            this.hoplogRWLock.writeLock().lock();
            try {
                for (TrackedReference<Hoplog> hoplog : this.hoplogs) {
                    HdfsSortedOplogOrganizer.this.closeReaderAndSuppressError(hoplog.get(), true);
                }
                for (TrackedReference<Hoplog> hoplog : this.inactiveHoplogs) {
                    HdfsSortedOplogOrganizer.this.closeReaderAndSuppressError(hoplog.get(), true);
                }
            }
            finally {
                this.hoplogs.clear();
                this.inactiveHoplogs.clear();
                this.hoplogRWLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<TrackedReference<Hoplog>> getTrackedSortedOplogList(String user) {
            ArrayList<TrackedReference<Hoplog>> oplogs = new ArrayList<TrackedReference<Hoplog>>();
            this.hoplogRWLock.readLock().lock();
            try {
                for (TrackedReference<Hoplog> oplog : this.hoplogs) {
                    oplog.increment(user);
                    oplogs.add(oplog);
                    if (!AbstractHoplogOrganizer.logger.isDebugEnabled()) continue;
                    AbstractHoplogOrganizer.logger.debug("{}Track ref " + oplog, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                }
            }
            finally {
                this.hoplogRWLock.readLock().unlock();
            }
            return oplogs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TrackedReference<Hoplog> trackHoplog(Hoplog hoplog, String user) {
            this.hoplogRWLock.readLock().lock();
            try {
                for (TrackedReference<Hoplog> oplog : this.hoplogs) {
                    if (!oplog.get().getFileName().equals(hoplog.getFileName())) continue;
                    oplog.increment(user);
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("{}Track " + oplog, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                    TrackedReference<Hoplog> trackedReference = oplog;
                    return trackedReference;
                }
            }
            finally {
                this.hoplogRWLock.readLock().unlock();
            }
            throw new NoSuchElementException(hoplog.getFileName());
        }

        public void releaseHoplogs(List<TrackedReference<Hoplog>> targets, String user) {
            if (targets == null) {
                return;
            }
            for (int i = targets.size() - 1; i >= 0; --i) {
                TrackedReference<Hoplog> hoplog = targets.get(i);
                this.releaseHoplog(hoplog, user);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseHoplog(TrackedReference<Hoplog> target, String user) {
            if (target == null) {
                return;
            }
            target.decrement(user);
            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                AbstractHoplogOrganizer.logger.debug("{}Try release " + target, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
            }
            if (target.inUse()) {
                return;
            }
            this.hoplogRWLock.writeLock().lock();
            try {
                if (!target.inUse()) {
                    if (this.inactiveHoplogs.contains(target)) {
                        int sizeBefore = this.inactiveHoplogs.size();
                        this.inactiveHoplogs.remove(target);
                        HdfsSortedOplogOrganizer.this.closeReaderAndSuppressError(target.get(), true);
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Closed inactive: ", target, " totalBefore:", sizeBefore, " totalAfter:", this.inactiveHoplogs.size()});
                        }
                    } else if (this.hoplogs.contains(target)) {
                        this.closeExcessReaders();
                    }
                }
            }
            catch (IOException e) {
                AbstractHoplogOrganizer.logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_IO_ERROR, "Close reader: " + target.get().getFileName()), (Throwable)e);
            }
            finally {
                this.hoplogRWLock.writeLock().unlock();
            }
        }

        private void closeExcessReaders() throws IOException {
            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                AbstractHoplogOrganizer.logger.debug("{}Close excess readers. Size:" + this.hoplogs.size() + " activeReaders:" + this.activeReaderCount.get() + " limit:" + this.maxOpenFilesLimit, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
            }
            if (this.hoplogs.size() <= this.maxOpenFilesLimit) {
                return;
            }
            if (this.activeReaderCount.get() <= this.maxOpenFilesLimit) {
                return;
            }
            for (TrackedReference<Hoplog> hoplog : this.hoplogs.descendingSet()) {
                if (!hoplog.inUse() && !hoplog.get().isClosed()) {
                    hoplog.get().close(false);
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("{}Excess reader closed " + hoplog, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                }
                if (this.activeReaderCount.get() > this.maxOpenFilesLimit) continue;
                return;
            }
        }

        @Override
        public void readerCreated() {
            this.activeReaderCount.incrementAndGet();
            HdfsSortedOplogOrganizer.this.stats.incActiveReaders(1);
            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                AbstractHoplogOrganizer.logger.debug("{}ActiveReader++", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
            }
        }

        @Override
        public void readerClosed() {
            this.activeReaderCount.decrementAndGet();
            HdfsSortedOplogOrganizer.this.stats.incActiveReaders(-1);
            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                AbstractHoplogOrganizer.logger.debug("{}ActiveReader--", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
            }
        }
    }

    protected class HoplogCompactor
    implements HoplogOrganizer.Compactor {
        private volatile boolean suspend = false;
        private AtomicBoolean isMinorCompactionActive = new AtomicBoolean(false);
        private AtomicBoolean isMajorCompactionActive = new AtomicBoolean(false);
        final AtomicInteger maxMajorCSeqNum = new AtomicInteger(-1);

        protected HoplogCompactor() {
        }

        @Override
        public void suspend() {
            long wait = Long.getLong("hoplog.suspend.max.wait.ms", 1000L);
            this.suspend = true;
            while (this.isMajorCompactionActive.get() || this.isMinorCompactionActive.get()) {
                if (wait < 0L) {
                    wait = Long.getLong("hoplog.suspend.max.wait.ms", 1000L);
                    String act = this.isMajorCompactionActive.get() ? "MajorC" : "MinorC";
                    AbstractHoplogOrganizer.logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_SUSPEND_OF_0_FAILED_IN_1, new Object[]{act, wait}));
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(50L);
                    wait -= 50L;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        @Override
        public void resume() {
            this.suspend = false;
        }

        @Override
        public boolean isBusy(boolean isMajor) {
            if (isMajor) {
                return this.isMajorCompactionActive.get();
            }
            return this.isMinorCompactionActive.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Loose catch block
         */
        @Override
        public boolean compact(boolean isMajor, boolean isForced) throws IOException {
            Hoplog compactedHoplog;
            block45: {
                AtomicBoolean lock;
                String user;
                if (this.suspend) {
                    return false;
                }
                String extension = null;
                SortedOplogStatistics.IOOperation compactionStats = null;
                long startTime = 0L;
                compactedHoplog = null;
                List<TrackedReference<Hoplog>> targets = null;
                String string = AbstractHoplogOrganizer.logger.isDebugEnabled() ? (isMajor ? "MajorC" : "MinorC") : (user = null);
                if (isMajor) {
                    lock = this.isMajorCompactionActive;
                    extension = ".chop";
                    compactionStats = HdfsSortedOplogOrganizer.this.stats.getMajorCompaction();
                } else {
                    lock = this.isMinorCompactionActive;
                    extension = ".ihop";
                    compactionStats = HdfsSortedOplogOrganizer.this.stats.getMinorCompaction();
                }
                if (!lock.compareAndSet(false, true)) {
                    if (isMajor) {
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            AbstractHoplogOrganizer.logger.debug("{}Major compaction already active. Ignoring new request", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                        }
                    } else if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("Minor compaction already active. Ignoring new request", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                    return false;
                }
                try {
                    Object hoplogName;
                    int lastKnownMajorCSeqNum;
                    if (this.suspend) {
                        boolean bl = false;
                        return bl;
                    }
                    startTime = compactionStats.begin();
                    int seqNum = -1;
                    AtomicInteger atomicInteger = this.maxMajorCSeqNum;
                    synchronized (atomicInteger) {
                        lastKnownMajorCSeqNum = this.maxMajorCSeqNum.get();
                        targets = HdfsSortedOplogOrganizer.this.hoplogReadersController.getTrackedSortedOplogList(user);
                        this.getCompactionTargets(isMajor, targets, lastKnownMajorCSeqNum);
                        if (targets != null && targets.size() > 0) {
                            targets = Collections.unmodifiableList(targets);
                            seqNum = HdfsSortedOplogOrganizer.getSequenceNumber((Hoplog)((TrackedReference)targets.get(0)).get());
                            if (isMajor) {
                                this.maxMajorCSeqNum.set(seqNum);
                            }
                        }
                    }
                    if (targets == null || targets.isEmpty() || !isMajor && targets.size() == 1 && !isForced) {
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            AbstractHoplogOrganizer.logger.debug("{}Skipping compaction, too few hoplops to compact. Major?" + isMajor, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                        }
                        compactionStats.end(0L, startTime);
                        boolean bl = true;
                        return bl;
                    }
                    if (targets.size() == 1 && !isForced && ((String)(hoplogName = ((Hoplog)((TrackedReference)targets.get(0)).get()).getFileName())).endsWith(".chop")) {
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            AbstractHoplogOrganizer.logger.debug("{}Skipping compaction, no need to compact a major compacted file. Major?" + isMajor, new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                        }
                        compactionStats.end(0L, startTime);
                        boolean bl = true;
                        return bl;
                    }
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        for (TrackedReference target : targets) {
                            if (!AbstractHoplogOrganizer.logger.isDebugEnabled()) continue;
                            HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Target:", target, " size:", ((Hoplog)target.get()).getSize()});
                        }
                    }
                    compactedHoplog = HdfsSortedOplogOrganizer.this.getTmpSortedOplog(seqNum, extension);
                    try {
                        long byteCount = this.fillCompactionHoplog(isMajor, targets, compactedHoplog, lastKnownMajorCSeqNum);
                        compactionStats.end(byteCount, startTime);
                    }
                    catch (InterruptedException e) {
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            AbstractHoplogOrganizer.logger.debug("{}Compaction execution suspended", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                        }
                        compactionStats.error(startTime);
                        boolean bl = false;
                        if (isMajor) {
                            this.maxMajorCSeqNum.set(-1);
                        }
                        lock.set(false);
                        HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(targets, user);
                        return bl;
                    }
                    catch (ForceReattemptException e) {
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            AbstractHoplogOrganizer.logger.debug("{}Compaction execution suspended", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                        }
                        compactionStats.error(startTime);
                        boolean bl = false;
                        if (isMajor) {
                            this.maxMajorCSeqNum.set(-1);
                        }
                        lock.set(false);
                        HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(targets, user);
                        return bl;
                    }
                    AtomicInteger atomicInteger2 = this.maxMajorCSeqNum;
                    synchronized (atomicInteger2) {
                        block44: {
                            if (isMajor || !this.isMinorMajorOverlap(targets, this.maxMajorCSeqNum.get())) break block44;
                            if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                                AbstractHoplogOrganizer.logger.debug("{}Interrupting MinorC for a concurrent MajorC", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                            }
                            compactionStats.error(startTime);
                            boolean bl = false;
                            return bl;
                        }
                        HdfsSortedOplogOrganizer.this.addSortedOplog(compactedHoplog, true, false);
                        HdfsSortedOplogOrganizer.this.markSortedOplogForDeletion(targets, true);
                        break block45;
                    }
                    {
                        catch (IOException e) {
                            compactionStats.error(startTime);
                            throw e;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (isMajor) {
                        this.maxMajorCSeqNum.set(-1);
                    }
                    lock.set(false);
                    HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(targets, user);
                }
            }
            HdfsSortedOplogOrganizer.this.incrementDiskUsage(compactedHoplog.getSize());
            HdfsSortedOplogOrganizer.this.reEstimateBucketSize();
            HdfsSortedOplogOrganizer.this.notifyCompactionListeners(isMajor);
            return true;
        }

        boolean isMinorMajorOverlap(List<TrackedReference<Hoplog>> targets, int num) {
            if (num < 0 || targets == null || targets.isEmpty()) {
                return false;
            }
            for (TrackedReference<Hoplog> hop : targets) {
                if (HdfsSortedOplogOrganizer.getSequenceNumber(hop.get()) > num) continue;
                return true;
            }
            return false;
        }

        public long fillCompactionHoplog(boolean isMajor, List<TrackedReference<Hoplog>> targets, Hoplog output, int majorCSeqNum) throws IOException, InterruptedException, ForceReattemptException {
            Closeable writer = null;
            HyperLogLog localHLL = new HyperLogLog(HLL_CONSTANT);
            HoplogSetIterator mergedIter = null;
            int byteCount = 0;
            try {
                mergedIter = new HoplogSetIterator(targets);
                writer = output.createWriter(mergedIter.getRemainingEntryCount());
                boolean interrupted = false;
                while (mergedIter.hasNext()) {
                    if (this.suspend) {
                        interrupted = true;
                        break;
                    }
                    if (!isMajor && this.maxMajorCSeqNum.get() > majorCSeqNum) {
                        if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                            AbstractHoplogOrganizer.logger.debug("{}Preempting MinorC, new MajorC cycle detected ", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                        }
                        interrupted = true;
                        break;
                    }
                    mergedIter.nextBB();
                    ByteBuffer k = mergedIter.getKeyBB();
                    ByteBuffer v = mergedIter.getValueBB();
                    boolean isDeletedEntry = HdfsSortedOplogOrganizer.this.isDeletedEntry(v.array(), v.arrayOffset());
                    if (isMajor && isDeletedEntry) continue;
                    if (!isDeletedEntry) {
                        int hash = MurmurHash.hash(k.array(), k.arrayOffset(), k.remaining(), -1);
                        localHLL.offerHashed(hash);
                    }
                    writer.append(k, v);
                    byteCount += k.remaining() + v.remaining();
                }
                mergedIter.close();
                mergedIter = null;
                writer.close(HdfsSortedOplogOrganizer.this.buildMetaData(localHLL));
                writer = null;
                if (interrupted) {
                    output.delete();
                    throw new InterruptedException();
                }
                HdfsSortedOplogOrganizer.this.pingSecondaries();
                AbstractHoplogOrganizer.makeLegitimate(output);
                long l = byteCount;
                return l;
            }
            catch (IOException e) {
                e = HdfsSortedOplogOrganizer.this.handleWriteHdfsIOError((Hoplog.HoplogWriter)writer, output, e);
                writer = null;
                throw e;
            }
            catch (ForceReattemptException e) {
                output.delete();
                throw e;
            }
            finally {
                if (mergedIter != null) {
                    mergedIter.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }

        protected void getCompactionTargets(boolean major, List<TrackedReference<Hoplog>> targets, int majorCSeqNum) {
            if (!major) {
                this.getMinorCompactionTargets(targets, majorCSeqNum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getMinorCompactionTargets(List<TrackedReference<Hoplog>> targets, int majorCSeqNum) {
            int bestTo;
            int bestFrom;
            ArrayList<TrackedReference<Hoplog>> omittedHoplogs;
            block14: {
                int MIN_FILE_COUNT_COMPACTION;
                int MAX_FILE_COUNT_COMPACTION;
                block13: {
                    omittedHoplogs = new ArrayList<TrackedReference<Hoplog>>();
                    Collections.reverse(targets);
                    long MAX_COMPACTION_FILE_SIZE = (long)HdfsSortedOplogOrganizer.this.store.getInputFileSizeMax() * 1024L * 1024L;
                    MAX_FILE_COUNT_COMPACTION = HdfsSortedOplogOrganizer.this.store.getInputFileCountMax();
                    MIN_FILE_COUNT_COMPACTION = HdfsSortedOplogOrganizer.this.store.getInputFileCountMin();
                    Iterator<TrackedReference<Hoplog>> iterator = targets.iterator();
                    while (iterator.hasNext()) {
                        TrackedReference<Hoplog> oplog = iterator.next();
                        if (majorCSeqNum >= HdfsSortedOplogOrganizer.getSequenceNumber(oplog.get())) {
                            iterator.remove();
                            omittedHoplogs.add(oplog);
                            if (!AbstractHoplogOrganizer.logger.isDebugEnabled()) continue;
                            HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Overlap with MajorC, excluding hoplog " + oplog.get()});
                            continue;
                        }
                        if (oplog.get().getSize() <= MAX_COMPACTION_FILE_SIZE && !oplog.get().getFileName().endsWith(".chop")) break;
                        iterator.remove();
                        omittedHoplogs.add(oplog);
                        if (!AbstractHoplogOrganizer.logger.isDebugEnabled()) continue;
                        HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"Excluding big hoplog from minor cycle:", oplog.get(), " size:", oplog.get().getSize(), " limit:", MAX_COMPACTION_FILE_SIZE});
                    }
                    if (targets.size() >= MIN_FILE_COUNT_COMPACTION) break block13;
                    if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                        AbstractHoplogOrganizer.logger.debug("{}Too few hoplogs for minor cycle:" + targets.size(), new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                    }
                    omittedHoplogs.addAll(targets);
                    targets.clear();
                    String user = AbstractHoplogOrganizer.logger.isDebugEnabled() ? "MinorC" : null;
                    HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(omittedHoplogs, user);
                    return;
                }
                float maxGain = Float.MIN_VALUE;
                bestFrom = -1;
                bestTo = -1;
                int maxIndexForFrom = targets.size() - MIN_FILE_COUNT_COMPACTION;
                for (int from = 0; from <= maxIndexForFrom; ++from) {
                    int minIndexForTo = from + MIN_FILE_COUNT_COMPACTION - 1;
                    int maxIndexForTo = Math.min(from + MAX_FILE_COUNT_COMPACTION, targets.size());
                    for (int i = minIndexForTo; i < maxIndexForTo; ++i) {
                        Float gain = HdfsSortedOplogOrganizer.this.computeGain(from, i, targets);
                        if (gain == null || !(gain.floatValue() > maxGain)) continue;
                        maxGain = gain.floatValue();
                        bestFrom = from;
                        bestTo = i;
                    }
                }
                if (bestFrom != -1) break block14;
                if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                    AbstractHoplogOrganizer.logger.debug("{}Failed to find optimal target set for MinorC", new Object[]{HdfsSortedOplogOrganizer.this.logPrefix});
                }
                omittedHoplogs.addAll(targets);
                targets.clear();
                String user = AbstractHoplogOrganizer.logger.isDebugEnabled() ? "MinorC" : null;
                HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(omittedHoplogs, user);
                return;
            }
            try {
                if (AbstractHoplogOrganizer.logger.isDebugEnabled()) {
                    HdfsSortedOplogOrganizer.this.fineLog(new Object[]{"MinorCTarget optimal result from:", bestFrom, " to:", bestTo});
                }
                int i = 0;
                Iterator<TrackedReference<Hoplog>> iter = targets.iterator();
                while (iter.hasNext()) {
                    TrackedReference<Hoplog> hop = iter.next();
                    if (i < bestFrom || i > bestTo) {
                        iter.remove();
                        omittedHoplogs.add(hop);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                String user = AbstractHoplogOrganizer.logger.isDebugEnabled() ? "MinorC" : null;
                HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(omittedHoplogs, user);
                throw throwable;
            }
            String user = AbstractHoplogOrganizer.logger.isDebugEnabled() ? "MinorC" : null;
            HdfsSortedOplogOrganizer.this.hoplogReadersController.releaseHoplogs(omittedHoplogs, user);
            Collections.reverse(targets);
        }

        @Override
        public HDFSStore getHdfsStore() {
            return HdfsSortedOplogOrganizer.this.store;
        }
    }
}

