/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.BloomFilter;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HdfsSortedOplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.persistence.soplog.DelegatingSerializedComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.HFileStoreStatistics;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.hll.HyperLogLog;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.Hex;
import com.gemstone.gemfire.internal.util.SingletonValue;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.ShutdownHookManager;

public final class HFileSortedOplog
extends AbstractHoplog {
    private final CacheConfig cacheConf;
    private ICardinality entryCountEstimate;
    private final SingletonValue<HFileReader> reader;

    public HFileSortedOplog(HDFSStoreImpl store, Path hfilePath, BlockCache blockCache, SortedOplogStatistics stats, HFileStoreStatistics storeStats) throws IOException {
        super(store, hfilePath, stats);
        this.cacheConf = this.getCacheConfInstance(blockCache, stats, storeStats);
        this.reader = this.getReaderContainer();
    }

    public static HFileSortedOplog getHoplogForLoner(FileSystem inputFS, Path hfilePath) throws IOException {
        return new HFileSortedOplog(inputFS, hfilePath, null, null, null);
    }

    private HFileSortedOplog(FileSystem inputFS, Path hfilePath, BlockCache blockCache, SortedOplogStatistics stats, HFileStoreStatistics storeStats) throws IOException {
        super(inputFS, hfilePath, stats);
        this.cacheConf = this.getCacheConfInstance(blockCache, stats, storeStats);
        this.reader = this.getReaderContainer();
    }

    protected CacheConfig getCacheConfInstance(BlockCache blockCache, SortedOplogStatistics stats, HFileStoreStatistics storeStats) {
        CacheConfig tmpConfig = null;
        tmpConfig = new CacheConfig(this.conf);
        tmpConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.ALL_CATEGORIES);
        return tmpConfig;
    }

    private SingletonValue<HFileReader> getReaderContainer() {
        return new SingletonValue<HFileReader>(new SingletonValue.SingletonBuilder<HFileReader>(){

            @Override
            public HFileReader create() throws IOException {
                if (AbstractHoplog.logger.isDebugEnabled()) {
                    AbstractHoplog.logger.debug("{}Creating hoplog reader", new Object[]{AbstractHoplog.logPrefix});
                }
                return new HFileReader();
            }

            @Override
            public void postCreate() {
                if (HFileSortedOplog.this.readerListener != null) {
                    HFileSortedOplog.this.readerListener.readerCreated();
                }
            }

            @Override
            public void createInProgress() {
            }
        });
    }

    @Override
    public Hoplog.HoplogReader getReader() throws IOException {
        return this.reader.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICardinality getEntryCountEstimate() throws IOException {
        ICardinality result = this.entryCountEstimate;
        if (result == null) {
            Hoplog.HoplogReader rdr = this.getReader();
            HFileSortedOplog hFileSortedOplog = this;
            synchronized (hFileSortedOplog) {
                result = this.entryCountEstimate;
                if (result == null) {
                    this.entryCountEstimate = result = rdr.getCardinalityEstimator();
                }
            }
        }
        return result;
    }

    @Override
    public Hoplog.HoplogWriter createWriter(int keys) throws IOException {
        return new HFileSortedOplogWriter(keys);
    }

    @Override
    public boolean isClosed() {
        HFileReader rdr = this.reader.getCachedValue();
        return rdr == null || rdr.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean clearCache) throws IOException {
        this.compareAndClose(null, clearCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareAndClose(HFileReader hfileReader, boolean clearCache) throws IOException {
        HFileReader rdr;
        if (hfileReader == null) {
            rdr = this.reader.clear(true);
        } else {
            boolean result = this.reader.clear(hfileReader, true);
            if (!result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}skipping close, provided hfileReader mismatched", new Object[]{logPrefix});
                }
                return;
            }
            rdr = hfileReader;
        }
        if (rdr != null) {
            try {
                rdr.close(clearCache);
            }
            finally {
                if (this.readerListener != null) {
                    this.readerListener.readerClosed();
                }
            }
        }
    }

    public String toString() {
        return "HFileSortedOplog[" + this.getFileName() + "]";
    }

    private void handleReadIOError(HFileReader hfileReader, IOException e, boolean skipFailIfSafe) {
        boolean safeError;
        if (logger.isDebugEnabled()) {
            logger.debug("Read IO error", (Throwable)e);
        }
        if (safeError = ShutdownHookManager.get().isShutdownInProgress()) {
            if (logger.isDebugEnabled()) {
                logger.debug("IO error caused by filesystem shutdown", (Throwable)e);
            }
            throw new CacheClosedException("IO error caused by filesystem shutdown", e);
        }
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
            throw new HDFSIOException(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE.toLocalizedString(this.path), e);
        }
        FileSystem currentFs = this.fsProvider.checkFileSystem();
        if (hfileReader != null && hfileReader.previousFS != currentFs) {
            block12: {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Detected new FS client, closing old reader", new Object[]{logPrefix});
                    if (currentFs != null && logger.isDebugEnabled()) {
                        logger.debug("CurrentFs:" + currentFs.getUri() + "-" + currentFs.hashCode(), new Object[]{logPrefix});
                    }
                    if (hfileReader.previousFS != null && logger.isDebugEnabled()) {
                        logger.debug("OldFs:" + hfileReader.previousFS.getUri() + "-" + hfileReader.previousFS.hashCode() + ", closing old reader", new Object[]{logPrefix});
                    }
                }
                try {
                    this.compareAndClose(hfileReader, false);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug("Failed to close reader", (Throwable)ex);
                }
            }
            if (skipFailIfSafe) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not faling after io error since FS client changed");
                }
                return;
            }
        }
        throw new HDFSIOException(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE.toLocalizedString(this.path), e);
    }

    public static byte[] byteBufferToArray(ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        byte[] tmp = new byte[bb.remaining()];
        bb.duplicate().get(tmp);
        return tmp;
    }

    class HFileReader
    implements Hoplog.HoplogReader,
    Closeable {
        private final HFile.Reader reader;
        private volatile BloomFilter hoplogBloom;
        private final AtomicBoolean closed;
        private final Map<byte[], byte[]> fileInfo;
        private final HyperLogLog estimator;
        private final FileSystem previousFS;

        public HFileReader() throws IOException {
            try {
                byte[] hll;
                FileSystem fs = HFileSortedOplog.this.fsProvider.getFS();
                this.reader = HFile.createReader((FileSystem)fs, (Path)HFileSortedOplog.this.path, (CacheConfig)HFileSortedOplog.this.cacheConf);
                this.fileInfo = this.reader.loadFileInfo();
                this.closed = new AtomicBoolean(false);
                this.validate();
                if (this.reader.getComparator() instanceof DelegatingSerializedComparator) {
                    this.loadComparators((DelegatingSerializedComparator)this.reader.getComparator());
                }
                if ((hll = this.fileInfo.get(Hoplog.Meta.LOCAL_CARDINALITY_ESTIMATE.toBytes())) != null) {
                    this.estimator = HyperLogLog.Builder.build(hll);
                    HFileSortedOplog.this.entryCountEstimate = this.estimator;
                } else {
                    hll = this.fileInfo.get(Hoplog.Meta.LOCAL_CARDINALITY_ESTIMATE_V2.toBytes());
                    if (hll != null) {
                        this.estimator = HyperLogLog.Builder.build(hll);
                        HFileSortedOplog.this.entryCountEstimate = this.estimator;
                    } else {
                        this.estimator = new HyperLogLog(HdfsSortedOplogOrganizer.HLL_CONSTANT);
                    }
                }
                this.previousFS = fs;
            }
            catch (IOException e) {
                if (AbstractHoplog.logger.isDebugEnabled()) {
                    AbstractHoplog.logger.debug("IO Error while creating reader", (Throwable)e);
                }
                throw e;
            }
        }

        @Override
        public byte[] read(byte[] key) throws IOException {
            IOException err = null;
            HFileReader delegateReader = this;
            for (int retry = 1; retry >= 0; --retry) {
                try {
                    return delegateReader.readDelegate(key);
                }
                catch (IOException e) {
                    err = e;
                    HFileSortedOplog.this.handleReadIOError(delegateReader, e, retry > 0);
                    try {
                        delegateReader = (HFileReader)HFileSortedOplog.this.getReader();
                    }
                    catch (IOException ex) {
                        HFileSortedOplog.this.handleReadIOError(null, e, false);
                    }
                    continue;
                }
            }
            if (AbstractHoplog.logger.isDebugEnabled()) {
                AbstractHoplog.logger.debug("Throwing err from read delegate ", (Throwable)err);
            }
            throw err;
        }

        private byte[] readDelegate(byte[] key) throws IOException {
            try {
                if (!this.getBloomFilter().mightContain(key)) {
                    return null;
                }
            }
            catch (IllegalArgumentException e) {
                if (IOException.class.isAssignableFrom(e.getCause().getClass())) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            byte[] valueBytes = null;
            ByteBuffer bb = this.get(key);
            if (bb != null) {
                valueBytes = new byte[bb.remaining()];
                bb.get(valueBytes);
            } else {
                HFileSortedOplog.this.stats.getBloom().falsePositive();
            }
            return valueBytes;
        }

        @Override
        public ByteBuffer get(byte[] key) throws IOException {
            assert (key != null);
            HFileScanner seek = this.reader.getScanner(false, true);
            if (seek.seekTo(key) == 0) {
                return seek.getValue();
            }
            return null;
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
            IOException err = null;
            HFileReader delegateReader = this;
            for (int retry = 1; retry >= 0; --retry) {
                try {
                    return delegateReader.scanDelegate(from, fromInclusive, to, toInclusive);
                }
                catch (IOException e) {
                    err = e;
                    HFileSortedOplog.this.handleReadIOError(delegateReader, e, retry > 0);
                    try {
                        delegateReader = (HFileReader)HFileSortedOplog.this.getReader();
                    }
                    catch (IOException ex) {
                        HFileSortedOplog.this.handleReadIOError(null, e, false);
                    }
                    continue;
                }
            }
            if (AbstractHoplog.logger.isDebugEnabled()) {
                AbstractHoplog.logger.debug("Throwing err from scan delegate ", (Throwable)err);
            }
            throw err;
        }

        private HoplogSetReader.HoplogIterator<byte[], byte[]> scanDelegate(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
            return new HFileSortedIterator(this.reader.getScanner(true, false), from, fromInclusive, to, toInclusive);
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan(long offset, long length) throws IOException {
            int i;
            HFileBlockIndex.BlockIndexReader bir = this.reader.getDataBlockIndexReader();
            int blockCount = bir.getRootBlockCount();
            byte[] fromKey = null;
            byte[] toKey = null;
            for (i = 0; i < blockCount; ++i) {
                if (bir.getRootBlockOffset(i) < offset) continue;
                fromKey = bir.getRootBlockKey(i);
                break;
            }
            if (fromKey == null) {
                return new HFileSortedIterator(null, null, false, null, false);
            }
            while (i < blockCount) {
                if (bir.getRootBlockOffset(i) >= offset + length) {
                    toKey = bir.getRootBlockKey(i);
                    break;
                }
                ++i;
            }
            HFileScanner scanner = this.reader.getScanner(true, false);
            return new HFileSortedIterator(scanner, fromKey, true, toKey, false);
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan() throws IOException {
            return this.scan(null, null);
        }

        @Override
        public HoplogSetReader.HoplogIterator<byte[], byte[]> scan(byte[] from, byte[] to) throws IOException {
            return this.scan(from, true, to, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BloomFilter getBloomFilter() throws IOException {
            BloomFilter result = this.hoplogBloom;
            if (result == null) {
                HFileReader hFileReader = this;
                synchronized (hFileReader) {
                    result = this.hoplogBloom;
                    if (result == null) {
                        this.hoplogBloom = result = new BloomFilterImpl();
                    }
                }
            }
            return result;
        }

        @Override
        public boolean isClosed() {
            return this.closed.get();
        }

        @Override
        public void close() throws IOException {
            this.close(true);
        }

        public void close(boolean clearCache) throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (AbstractHoplog.logger.isDebugEnabled()) {
                    AbstractHoplog.logger.debug("{}Closing reader", new Object[]{AbstractHoplog.logPrefix});
                }
                this.reader.close(clearCache);
            }
        }

        @Override
        public long getEntryCount() {
            return this.reader.getEntries();
        }

        @Override
        public ICardinality getCardinalityEstimator() {
            return this.estimator;
        }

        @Override
        public long sizeEstimate() {
            return this.getCardinalityEstimator().cardinality();
        }

        private void validate() throws IOException {
            byte[] magic = this.fileInfo.get(Hoplog.Meta.GEMFIRE_MAGIC.toBytes());
            if (!Arrays.equals(magic, Hoplog.MAGIC)) {
                throw new IOException(LocalizedStrings.Soplog_INVALID_MAGIC.toLocalizedString(Hex.toHex(magic)));
            }
            byte[] ver = this.fileInfo.get(Hoplog.Meta.SORTED_OPLOG_VERSION.toBytes());
            if (AbstractHoplog.logger.isDebugEnabled()) {
                AbstractHoplog.logger.debug("{}Hoplog version is " + Hex.toHex(ver), new Object[]{AbstractHoplog.logPrefix});
            }
            if (!Arrays.equals(ver, Hoplog.HoplogVersion.V1.toBytes())) {
                throw new IOException(LocalizedStrings.Soplog_UNRECOGNIZED_VERSION.toLocalizedString(Hex.toHex(ver)));
            }
        }

        private void loadComparators(DelegatingSerializedComparator comparator) throws IOException {
            byte[] raw = this.fileInfo.get(Hoplog.Meta.COMPARATORS.toBytes());
            assert (raw != null);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(raw));
            comparator.setComparators(this.readComparators(in));
        }

        private SortedReader.SerializedComparator[] readComparators(DataInput in) throws IOException {
            try {
                SortedReader.SerializedComparator[] comps = new SortedReader.SerializedComparator[in.readInt()];
                assert (comps.length > 0);
                for (int i = 0; i < comps.length; ++i) {
                    comps[i] = (SortedReader.SerializedComparator)Class.forName(in.readUTF()).newInstance();
                    if (!(comps[i] instanceof DelegatingSerializedComparator)) continue;
                    ((DelegatingSerializedComparator)comps[i]).setComparators(this.readComparators(in));
                }
                return comps;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public final class HFileSortedIterator
        implements HoplogSetReader.HoplogIterator<byte[], byte[]> {
            private final HFileScanner scan;
            private final byte[] from;
            private final boolean fromInclusive;
            private final byte[] to;
            private final boolean toInclusive;
            private ByteBuffer prefetchedKey;
            private ByteBuffer prefetchedValue;
            private ByteBuffer currentKey;
            private ByteBuffer currentValue;
            SortedOplogStatistics.ScanOperation scanStat;
            private long scanStart;

            public HFileSortedIterator(HFileScanner scan, byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
                SortedOplogStatistics.ScanOperation scanOperation;
                this.scan = scan;
                this.from = from;
                this.fromInclusive = fromInclusive;
                this.to = to;
                this.toInclusive = toInclusive;
                if (HFileSortedOplog.this.stats == null) {
                    SortedOplogStatistics sortedOplogStatistics = new SortedOplogStatistics("", "");
                    sortedOplogStatistics.getClass();
                    scanOperation = sortedOplogStatistics.new SortedOplogStatistics.ScanOperation(0, 0, 0, 0, 0, 0, 0);
                } else {
                    scanOperation = HFileSortedOplog.this.stats.getScan();
                }
                this.scanStat = scanOperation;
                this.scanStart = this.scanStat.begin();
                if (scan == null) {
                    return;
                }
                assert (from == null || to == null || scan.getReader().getComparator().compare((Object)from, (Object)to) <= 0);
                this.initIterator();
            }

            private void initIterator() throws IOException {
                long startNext = this.scanStat.beginIteration();
                boolean scanSuccessful = true;
                if (this.from == null) {
                    scanSuccessful = this.scan.seekTo();
                } else {
                    int compare = this.scan.seekTo(this.from);
                    if (compare == 0 && !this.fromInclusive || compare > 0) {
                        scanSuccessful = this.scan.next();
                    }
                }
                this.populateKV(startNext, scanSuccessful);
            }

            @Override
            public boolean hasNext() {
                return this.prefetchedKey != null;
            }

            @Override
            public byte[] next() throws IOException {
                return HFileSortedOplog.byteBufferToArray(this.nextBB());
            }

            public ByteBuffer nextBB() throws IOException {
                long startNext = this.scanStat.beginIteration();
                if (this.prefetchedKey == null) {
                    throw new NoSuchElementException();
                }
                this.currentKey = this.prefetchedKey;
                this.currentValue = this.prefetchedValue;
                this.prefetchedKey = null;
                this.prefetchedValue = null;
                if (this.scan.next()) {
                    this.populateKV(startNext, true);
                }
                return this.currentKey;
            }

            private void populateKV(long nextStartTime, boolean scanSuccessful) {
                if (!scanSuccessful) {
                    this.scanStat.endIteration(0L, nextStartTime);
                    return;
                }
                this.prefetchedKey = this.scan.getKey();
                this.prefetchedValue = this.scan.getValue();
                if (this.to != null) {
                    int compare = -1;
                    compare = this.scan.getReader().getComparator().compare(this.prefetchedKey.array(), this.prefetchedKey.arrayOffset(), this.prefetchedKey.remaining(), this.to, 0, this.to.length);
                    if (compare > 0 || compare == 0 && !this.toInclusive) {
                        this.prefetchedKey = null;
                        this.prefetchedValue = null;
                        return;
                    }
                }
                int byteCount = this.prefetchedKey.remaining() + this.prefetchedValue.remaining();
                this.scanStat.endIteration(byteCount, nextStartTime);
            }

            @Override
            public byte[] getKey() {
                return HFileSortedOplog.byteBufferToArray(this.getKeyBB());
            }

            public ByteBuffer getKeyBB() {
                return this.currentKey;
            }

            @Override
            public byte[] getValue() {
                return HFileSortedOplog.byteBufferToArray(this.getValueBB());
            }

            public ByteBuffer getValueBB() {
                return this.currentValue;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot delete a key-value from a hfile sorted oplog");
            }

            @Override
            public void close() {
                this.scanStat.end(this.scanStart);
            }
        }

        class BloomFilterImpl
        implements BloomFilter {
            private final org.apache.hadoop.hbase.util.BloomFilter hfileBloom;

            public BloomFilterImpl() throws IOException {
                DataInput bin = HFileReader.this.reader.getGeneralBloomFilterMetadata();
                if (bin != null) {
                    this.hfileBloom = BloomFilterFactory.createFromMeta((DataInput)bin, (HFile.Reader)HFileReader.this.reader);
                    if (HFileReader.this.reader.getComparator() instanceof DelegatingSerializedComparator) {
                        HFileReader.this.loadComparators((DelegatingSerializedComparator)this.hfileBloom.getComparator());
                    }
                } else {
                    this.hfileBloom = null;
                }
            }

            @Override
            public boolean mightContain(byte[] key) {
                assert (key != null);
                return this.mightContain(key, 0, key.length);
            }

            @Override
            public boolean mightContain(byte[] key, int keyOffset, int keyLength) {
                assert (key != null);
                long start = HFileSortedOplog.this.stats.getBloom().begin();
                boolean found = this.hfileBloom == null ? true : this.hfileBloom.contains(key, keyOffset, keyLength, null);
                HFileSortedOplog.this.stats.getBloom().end(start);
                return found;
            }

            @Override
            public long getBloomSize() {
                return this.hfileBloom == null ? 0L : this.hfileBloom.getByteSize();
            }
        }
    }

    private class HFileSortedOplogWriter
    implements Hoplog.HoplogWriter {
        private final HFile.Writer writer;
        private final BloomFilterWriter bfw;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public HFileSortedOplogWriter(int keys) throws IOException {
            try {
                int hfileBlockSize = Integer.getInteger("hoplog.hfile.block.size", 65536);
                Compression.Algorithm compress = Compression.Algorithm.valueOf((String)System.getProperty("hoplog.compression.algorithm", "NONE"));
                this.writer = HFile.getWriterFactory((Configuration)HFileSortedOplog.this.conf, (CacheConfig)HFileSortedOplog.this.cacheConf).withPath(HFileSortedOplog.this.fsProvider.getFS(), HFileSortedOplog.this.path).withBlockSize(hfileBlockSize).withCompression(compress).create();
                this.bfw = BloomFilterFactory.createGeneralBloomAtWrite((Configuration)HFileSortedOplog.this.conf, (CacheConfig)HFileSortedOplog.this.cacheConf, (StoreFile.BloomType)StoreFile.BloomType.ROW, (int)keys, (HFile.Writer)this.writer);
                if (AbstractHoplog.logger.isDebugEnabled()) {
                    AbstractHoplog.logger.debug("{}Created hoplog writer with compression " + compress, new Object[]{AbstractHoplog.logPrefix});
                }
            }
            catch (IOException e) {
                if (AbstractHoplog.logger.isDebugEnabled()) {
                    AbstractHoplog.logger.debug("{}IO Error while creating writer", new Object[]{AbstractHoplog.logPrefix});
                }
                throw e;
            }
        }

        @Override
        public void append(byte[] key, byte[] value) throws IOException {
            this.writer.append(key, value);
            this.bfw.add(key, 0, key.length);
        }

        @Override
        public void append(ByteBuffer key, ByteBuffer value) throws IOException {
            byte[] keyBytes = HFileSortedOplog.byteBufferToArray(key);
            byte[] valueBytes = HFileSortedOplog.byteBufferToArray(value);
            this.writer.append(keyBytes, valueBytes);
            this.bfw.add(keyBytes, 0, keyBytes.length);
        }

        @Override
        public void close() throws IOException {
            this.close(null);
        }

        @Override
        public void close(EnumMap<Hoplog.Meta, byte[]> metadata) throws IOException {
            if (this.closed.get()) {
                if (AbstractHoplog.logger.isDebugEnabled()) {
                    AbstractHoplog.logger.debug("{}Writer already closed", new Object[]{AbstractHoplog.logPrefix});
                }
                return;
            }
            this.bfw.compactBloom();
            this.writer.addGeneralBloomFilter(this.bfw);
            this.writer.appendFileInfo(Hoplog.Meta.GEMFIRE_MAGIC.toBytes(), Hoplog.MAGIC);
            this.writer.appendFileInfo(Hoplog.Meta.SORTED_OPLOG_VERSION.toBytes(), Hoplog.HoplogVersion.V1.toBytes());
            this.writer.appendFileInfo(Hoplog.Meta.GEMFIRE_VERSION.toBytes(), Version.CURRENT.toBytes());
            HyperLogLog cachedEntryCountEstimate = null;
            if (metadata != null) {
                for (Map.Entry<Hoplog.Meta, byte[]> entry : metadata.entrySet()) {
                    this.writer.appendFileInfo(entry.getKey().toBytes(), entry.getValue());
                    if (!Hoplog.Meta.LOCAL_CARDINALITY_ESTIMATE_V2.equals((Object)entry.getKey())) continue;
                    cachedEntryCountEstimate = HyperLogLog.Builder.build(entry.getValue());
                }
            }
            this.writer.close();
            if (AbstractHoplog.logger.isDebugEnabled()) {
                AbstractHoplog.logger.debug("{}Completed closing writer", new Object[]{AbstractHoplog.logPrefix});
            }
            this.closed.set(true);
            HFileSortedOplog.this.entryCountEstimate = cachedEntryCountEstimate;
        }

        @Override
        public void hsync() throws IOException {
            throw new UnsupportedOperationException("hsync is not supported for HFiles");
        }

        @Override
        public long getCurrentSize() throws IOException {
            throw new UnsupportedOperationException("getCurrentSize is not supported for HFiles");
        }
    }
}

