/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class HDFSForceCompactionArgs
implements VersionedDataSerializable {
    private static Version[] serializationVersions = new Version[]{Version.GFE_81};
    private HashSet<Integer> buckets;
    private boolean isMajor;
    private int maxWaitTime;

    public HDFSForceCompactionArgs() {
    }

    public HDFSForceCompactionArgs(Set<Integer> buckets, boolean isMajor, Integer maxWaitTime) {
        this.buckets = new HashSet<Integer>(buckets);
        this.isMajor = isMajor;
        this.maxWaitTime = maxWaitTime;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeHashSet(this.buckets, out);
        out.writeBoolean(this.isMajor);
        out.writeInt(this.maxWaitTime);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.buckets = DataSerializer.readHashSet(in);
        this.isMajor = in.readBoolean();
        this.maxWaitTime = in.readInt();
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    public Set<Integer> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Set<Integer> buckets) {
        this.buckets = new HashSet<Integer>(buckets);
    }

    public boolean isMajor() {
        return this.isMajor;
    }

    public void setMajor(boolean isMajor) {
        this.isMajor = isMajor;
    }

    public boolean isSynchronous() {
        return this.maxWaitTime == 0;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getCanonicalName()).append("@").append(System.identityHashCode(this)).append(" buckets:").append(this.buckets).append(" isMajor:").append(this.isMajor).append(" maxWaitTime:").append(this.maxWaitTime);
        return sb.toString();
    }
}

