/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.hdfs.internal.FlushObserver;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.FlushStatus;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSFlushQueueArgs;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class HDFSFlushQueueFunction
implements Function,
InternalEntity {
    private static final int MAX_RETRIES = Integer.getInteger("gemfireXD.maxFlushQueueRetries", 3);
    private static final boolean VERBOSE = Boolean.getBoolean("hdfsFlushQueueFunction.VERBOSE");
    private static final Logger logger = LogService.getLogger();
    private static final String ID = HDFSFlushQueueFunction.class.getName();

    public static void flushQueue(PartitionedRegion pr, int maxWaitTime) {
        HashSet<Integer> buckets = new HashSet<Integer>(pr.getRegionAdvisor().getBucketSet());
        maxWaitTime *= 1000;
        long start = System.currentTimeMillis();
        int retries = 0;
        long remaining = 0L;
        while (retries++ < MAX_RETRIES && (remaining = HDFSFlushQueueFunction.waitTime(start, maxWaitTime)) > 0L) {
            HDFSFlushQueueResultCollector rc;
            block8: {
                if (logger.isDebugEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Flushing buckets " + buckets + ", attempt = " + retries + ", remaining = " + remaining));
                }
                HDFSFlushQueueArgs args = new HDFSFlushQueueArgs(buckets, remaining);
                rc = new HDFSFlushQueueResultCollector(buckets);
                AbstractExecution exec = (AbstractExecution)FunctionService.onRegion(pr).withArgs(args).withCollector(rc);
                exec.setWaitOnExceptionFlag(true);
                try {
                    exec.execute(ID);
                    if (rc.getResult().booleanValue()) {
                        if (logger.isDebugEnabled() || VERBOSE) {
                            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Flushed all buckets successfully"));
                        }
                        return;
                    }
                }
                catch (FunctionException e) {
                    if (!logger.isDebugEnabled() && !VERBOSE) break block8;
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Encountered error flushing queue"), (Throwable)e);
                }
            }
            buckets.removeAll(rc.getSuccessfulBuckets());
            Iterator iterator = buckets.iterator();
            while (iterator.hasNext()) {
                int bucketId = (Integer)iterator.next();
                remaining = HDFSFlushQueueFunction.waitTime(start, maxWaitTime);
                if (logger.isDebugEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Waiting for bucket " + bucketId));
                }
                pr.getNodeForBucketWrite(bucketId, new PartitionedRegion.RetryTimeKeeper((int)remaining));
            }
        }
        pr.checkReadiness();
        throw new FunctionException("Unable to flush the following buckets: " + buckets);
    }

    private static long waitTime(long start, long max) {
        if (max == 0L) {
            return Integer.MAX_VALUE;
        }
        return start + max - System.currentTimeMillis();
    }

    @Override
    public void execute(FunctionContext context) {
        RegionFunctionContext rfc = (RegionFunctionContext)context;
        PartitionedRegion pr = (PartitionedRegion)rfc.getDataSet();
        HDFSFlushQueueArgs args = (HDFSFlushQueueArgs)rfc.getArguments();
        HashSet<Integer> buckets = new HashSet<Integer>(args.getBuckets());
        buckets.retainAll(pr.getDataStore().getAllLocalPrimaryBucketIds());
        HashMap<Integer, FlushObserver.AsyncFlushResult> flushes = new HashMap<Integer, FlushObserver.AsyncFlushResult>();
        Iterator iterator = buckets.iterator();
        while (iterator.hasNext()) {
            int bucketId = (Integer)iterator.next();
            try {
                HDFSBucketRegionQueue brq = this.getQueue(pr, bucketId);
                if (brq == null) continue;
                if (logger.isDebugEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Flushing bucket " + bucketId));
                }
                flushes.put(bucketId, brq.flush());
            }
            catch (ForceReattemptException e) {
                if (!logger.isDebugEnabled() && !VERBOSE) continue;
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Encountered error flushing bucket " + bucketId), (Throwable)e);
            }
        }
        try {
            long start = System.currentTimeMillis();
            for (Map.Entry flush : flushes.entrySet()) {
                long remaining = HDFSFlushQueueFunction.waitTime(start, args.getMaxWaitTime());
                if (logger.isDebugEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Waiting for bucket " + flush.getKey() + " to complete flushing, remaining = " + remaining));
                }
                if (!((FlushObserver.AsyncFlushResult)flush.getValue()).waitForFlush(remaining, TimeUnit.MILLISECONDS)) continue;
                if (logger.isDebugEnabled() || VERBOSE) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Bucket " + flush.getKey() + " flushed successfully"));
                }
                rfc.getResultSender().sendResult(new FlushStatus((Integer)flush.getKey()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (logger.isDebugEnabled() || VERBOSE) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Sending final flush result"));
        }
        rfc.getResultSender().lastResult(FlushStatus.last());
    }

    private HDFSBucketRegionQueue getQueue(PartitionedRegion pr, int bucketId) throws ForceReattemptException {
        AsyncEventQueueImpl aeq = pr.getHDFSEventQueue();
        AbstractGatewaySender gw = (AbstractGatewaySender)aeq.getSender();
        AbstractGatewaySenderEventProcessor ep = gw.getEventProcessor();
        if (ep == null) {
            return null;
        }
        ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
        return queue.getBucketRegionQueue(pr, bucketId);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return true;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    public static class HDFSFlushQueueResultCollector
    implements LocalResultCollector<Object, Boolean> {
        private final CountDownLatch complete;
        private final Set<Integer> expectedBuckets;
        private final Set<Integer> successfulBuckets;
        private volatile ReplyProcessor21 processor;

        public HDFSFlushQueueResultCollector(Set<Integer> expectedBuckets) {
            this.expectedBuckets = expectedBuckets;
            this.complete = new CountDownLatch(1);
            this.successfulBuckets = new HashSet<Integer>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Integer> getSuccessfulBuckets() {
            Set<Integer> set = this.successfulBuckets;
            synchronized (set) {
                return new HashSet<Integer>(this.successfulBuckets);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean getResult() throws FunctionException {
            try {
                this.complete.await();
                Set<Integer> set = this.successfulBuckets;
                synchronized (set) {
                    LogWriterI18n logger = InternalDistributedSystem.getLoggerI18n();
                    if (logger.fineEnabled() || VERBOSE) {
                        logger.info(LocalizedStrings.DEBUG, "Expected buckets: " + this.expectedBuckets);
                        logger.info(LocalizedStrings.DEBUG, "Successful buckets: " + this.successfulBuckets);
                    }
                    return this.expectedBuckets.equals(this.successfulBuckets);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                GemFireCacheImpl.getExisting().getCancelCriterion().checkCancelInProgress(e);
                throw new FunctionException(e);
            }
        }

        @Override
        public Boolean getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addResult(DistributedMember memberID, Object result) {
            FlushStatus status;
            if (result instanceof FlushStatus && !(status = (FlushStatus)result).isLast()) {
                Set<Integer> set = this.successfulBuckets;
                synchronized (set) {
                    this.successfulBuckets.add(status.getBucketId());
                }
            }
        }

        @Override
        public void endResults() {
            this.complete.countDown();
        }

        @Override
        public void clearResults() {
        }

        @Override
        public void setProcessor(ReplyProcessor21 processor) {
            this.processor = processor;
        }

        @Override
        public ReplyProcessor21 getProcessor() {
            return this.processor;
        }

        @Override
        public void setException(Throwable exception) {
        }
    }
}

