/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSUnsortedHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collection;
import org.apache.hadoop.fs.FileSystem;
import org.apache.logging.log4j.Logger;

class CloseTmpHoplogsTimerTask
extends SystemTimer.SystemTimerTask {
    private HDFSRegionDirector.HdfsRegionManager hdfsRegionManager;
    private static final Logger logger = LogService.getLogger();
    private FileSystem filesystem;

    public CloseTmpHoplogsTimerTask(HDFSRegionDirector.HdfsRegionManager hdfsRegionManager) {
        this.hdfsRegionManager = hdfsRegionManager;
        this.filesystem = this.hdfsRegionManager.getStore().createFileSystem();
        if (logger.isDebugEnabled()) {
            logger.debug("created a new file system specifically for timer task");
        }
    }

    @Override
    public void run2() {
        Collection<HoplogOrganizer> organizers = this.hdfsRegionManager.getBucketOrganizers();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting the close temp logs run.");
        }
        for (HoplogOrganizer organizer : organizers) {
            HDFSUnsortedHoplogOrganizer unsortedOrganizer = (HDFSUnsortedHoplogOrganizer)organizer;
            long timeSinceLastFlush = (System.currentTimeMillis() - unsortedOrganizer.getLastFlushTime()) / 1000L;
            try {
                this.hdfsRegionManager.getRegion().checkReadiness();
            }
            catch (Exception e) {
                break;
            }
            try {
                if (timeSinceLastFlush >= unsortedOrganizer.getfileRolloverInterval()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Closing writer for bucket: " + unsortedOrganizer.bucketId);
                    }
                    unsortedOrganizer.synchronizedCloseWriter(false, timeSinceLastFlush, 0);
                }
                unsortedOrganizer.identifyAndFixTmpHoplogs(this.filesystem);
            }
            catch (Exception e) {
                logger.warn((Object)LocalizedStrings.HOPLOG_CLOSE_FAILED, (Throwable)e);
            }
        }
    }
}

