/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.AbstractHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.org.apache.hadoop.io.SequenceFile;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractHoplog
implements Hoplog {
    protected final FSProvider fsProvider;
    protected volatile Path path;
    private volatile HoplogDescriptor hfd;
    protected Configuration conf;
    protected SortedOplogStatistics stats;
    protected Long hoplogModificationTime;
    protected Long hoplogSize;
    protected Hoplog.HoplogReaderActivityListener readerListener;
    protected static final Logger logger = LogService.getLogger();
    protected static String logPrefix;

    AbstractHoplog(FileSystem inputFS, Path filePath, SortedOplogStatistics stats) throws IOException {
        logPrefix = "<" + filePath.getName() + "> ";
        this.fsProvider = new FSProvider(inputFS);
        this.initialize(filePath, stats, inputFS);
    }

    public AbstractHoplog(HDFSStoreImpl store, Path filePath, SortedOplogStatistics stats) throws IOException {
        logPrefix = "<" + filePath.getName() + "> ";
        this.fsProvider = new FSProvider(store);
        this.initialize(filePath, stats, store.getFileSystem());
    }

    private void initialize(Path path, SortedOplogStatistics stats, FileSystem fs) {
        this.conf = fs.getConf();
        this.stats = stats;
        this.path = fs.makeQualified(path);
        this.hfd = new HoplogDescriptor(this.path.getName());
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract Hoplog.HoplogReader getReader() throws IOException;

    @Override
    public abstract Hoplog.HoplogWriter createWriter(int var1) throws IOException;

    @Override
    public abstract void close(boolean var1) throws IOException;

    @Override
    public void setReaderActivityListener(Hoplog.HoplogReaderActivityListener listener) {
        this.readerListener = listener;
    }

    @Override
    public String getFileName() {
        return this.hfd.getFileName();
    }

    @Override
    public final int compareTo(Hoplog o) {
        return this.hfd.compareTo(((AbstractHoplog)o).hfd);
    }

    @Override
    public ICardinality getEntryCountEstimate() throws IOException {
        return null;
    }

    @Override
    public synchronized void rename(String name) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Renaming hoplog to " + name, new Object[]{logPrefix});
        }
        Path parent = this.path.getParent();
        Path newPath = new Path(parent, name);
        this.fsProvider.getFS().rename(this.path, new Path(parent, newPath));
        this.close();
        this.path = newPath;
        this.hfd = new HoplogDescriptor(this.path.getName());
        logPrefix = "<" + this.path.getName() + "> ";
    }

    @Override
    public synchronized void delete() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Deleting hoplog", new Object[]{logPrefix});
        }
        this.close();
        this.hoplogModificationTime = null;
        this.hoplogSize = null;
        this.fsProvider.getFS().delete(this.path, false);
    }

    @Override
    public long getModificationTimeStamp() {
        this.initHoplogSizeTimeInfo();
        if (this.hoplogModificationTime == null) {
            throw new IllegalStateException();
        }
        return this.hoplogModificationTime;
    }

    @Override
    public long getSize() {
        this.initHoplogSizeTimeInfo();
        if (this.hoplogSize == null) {
            throw new IllegalStateException();
        }
        return this.hoplogSize;
    }

    private synchronized void initHoplogSizeTimeInfo() {
        if (this.hoplogSize != null && this.hoplogModificationTime != null) {
            return;
        }
        try {
            FileStatus[] filesInfo = FSUtils.listStatus((FileSystem)this.fsProvider.getFS(), (Path)this.path, null);
            if (filesInfo != null && filesInfo.length == 1) {
                this.hoplogModificationTime = filesInfo[0].getModificationTime();
                this.hoplogSize = filesInfo[0].getLen();
            }
        }
        catch (IOException e) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE, this.path), (Throwable)e);
            throw new HDFSIOException(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE.toLocalizedString(this.path), e);
        }
    }

    public static SequenceFile.Writer getSequenceFileWriter(Path path, Configuration conf, Logger logger) throws IOException {
        return AbstractHoplog.getSequenceFileWriter(path, conf, logger, null);
    }

    public static SequenceFile.Writer getSequenceFileWriter(Path path, Configuration conf, Logger logger, Version version) throws IOException {
        SequenceFile.Writer.Option optPath = SequenceFile.Writer.file(path);
        SequenceFile.Writer.Option optKey = SequenceFile.Writer.keyClass(BytesWritable.class);
        SequenceFile.Writer.Option optVal = SequenceFile.Writer.valueClass(BytesWritable.class);
        SequenceFile.Writer.Option optCom = AbstractHoplog.withCompression(logger);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Started creating hoplog " + path, new Object[]{logPrefix});
        }
        if (version == null) {
            version = Version.CURRENT;
        }
        SequenceFile.Metadata metadata = new SequenceFile.Metadata();
        metadata.set(new Text(Hoplog.Meta.GEMFIRE_VERSION.name()), new Text(String.valueOf(version.ordinal())));
        SequenceFile.Writer.Option optMeta = SequenceFile.Writer.metadata(metadata);
        SequenceFile.Writer writer = SequenceFile.createWriter(conf, optPath, optKey, optVal, optCom, optMeta);
        return writer;
    }

    private static SequenceFile.Writer.Option withCompression(Logger logger) {
        String prop = System.getProperty("hoplog.compression.algorithm");
        if (prop != null) {
            SnappyCodec codec;
            if (prop.equalsIgnoreCase("SNAPPY")) {
                codec = new SnappyCodec();
            } else if (prop.equalsIgnoreCase("LZ4")) {
                codec = new Lz4Codec();
            } else if (prop.equals("GZ")) {
                codec = new GzipCodec();
            } else {
                throw new IllegalStateException("Unsupported codec: " + prop);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}Using compression codec " + codec, new Object[]{logPrefix});
            }
            return SequenceFile.Writer.compression(SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec);
        }
        return SequenceFile.Writer.compression(SequenceFile.CompressionType.NONE, null);
    }

    protected static final class FSProvider {
        final FileSystem fs;
        final HDFSStoreImpl store;

        FSProvider(FileSystem fs) {
            this.fs = fs;
            this.store = null;
        }

        FSProvider(HDFSStoreImpl store) {
            this.store = store;
            this.fs = null;
        }

        public FileSystem getFS() throws IOException {
            if (this.store != null) {
                return this.store.getFileSystem();
            }
            return this.fs;
        }

        public FileSystem checkFileSystem() {
            this.store.checkAndClearFileSystem();
            return this.store.getCachedFileSystem();
        }
    }

    public static final class HoplogDescriptor
    implements Comparable<HoplogDescriptor> {
        private final String fileName;
        private final String bucket;
        private final int sequence;
        private final long timestamp;
        private final String extension;

        HoplogDescriptor(String fileName) {
            this.fileName = fileName;
            Matcher matcher = AbstractHoplogOrganizer.HOPLOG_NAME_PATTERN.matcher(fileName);
            boolean matched = matcher.find();
            assert (matched);
            this.bucket = matcher.group(1);
            this.sequence = Integer.valueOf(matcher.group(3));
            this.timestamp = Long.valueOf(matcher.group(2));
            this.extension = matcher.group(4);
        }

        public final String getFileName() {
            return this.fileName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HoplogDescriptor)) {
                return false;
            }
            HoplogDescriptor other = (HoplogDescriptor)o;
            assert (this.bucket.equals(other.bucket));
            if (this.sequence != other.sequence) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return this.extension.equals(other.extension);
        }

        @Override
        public int compareTo(HoplogDescriptor o) {
            if (this == o) {
                return 0;
            }
            assert (this.bucket.equals(o.bucket));
            if (this.sequence > o.sequence) {
                return -1;
            }
            if (this.sequence < o.sequence) {
                return 1;
            }
            if (this.timestamp > o.timestamp) {
                return -1;
            }
            if (this.timestamp < o.timestamp) {
                return 1;
            }
            return this.extension.compareTo(o.extension);
        }
    }
}

