/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UnsortedHoplogPersistedEvent
extends PersistedEventImpl {
    long timestamp;

    public UnsortedHoplogPersistedEvent() {
    }

    public UnsortedHoplogPersistedEvent(Object value, Operation op, byte valueIsObject, boolean isPossibleDuplicate, long timestamp) throws IOException, ClassNotFoundException {
        super(value, op, valueIsObject, isPossibleDuplicate, false);
        this.timestamp = timestamp;
    }

    @Override
    public long getTimstamp() {
        return this.timestamp;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeLong(this.timestamp, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.timestamp = DataSerializer.readLong(in);
    }

    public static UnsortedHoplogPersistedEvent fromBytes(byte[] val) throws IOException, ClassNotFoundException {
        ByteArrayDataInput in = new ByteArrayDataInput();
        in.initialize(val, null);
        UnsortedHoplogPersistedEvent event = new UnsortedHoplogPersistedEvent();
        event.fromData(in);
        return event;
    }

    @Override
    public void copy(PersistedEventImpl usersValue) {
        super.copy(usersValue);
        this.timestamp = ((UnsortedHoplogPersistedEvent)usersValue).timestamp;
    }

    public static int getSizeInBytes(int keySize, int valueSize, VersionTag versionTag) {
        int size = PersistedEventImpl.getSizeInBytes(keySize, valueSize, versionTag);
        return size += 8;
    }
}

