/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.QueuedPersistentEvent;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SortedHDFSQueuePersistedEvent
extends SortedHoplogPersistedEvent
implements QueuedPersistentEvent {
    protected byte[] keyBytes = null;

    public SortedHDFSQueuePersistedEvent(HDFSGatewayEventImpl in) throws IOException, ClassNotFoundException {
        this(in.getSerializedValue(), in.getOperation(), in.getValueIsObject(), in.getPossibleDuplicate(), in.getVersionTag(), in.getSerializedKey(), in.getCreationTime());
    }

    public SortedHDFSQueuePersistedEvent(Object valueObject, Operation operation, byte valueIsObject, boolean possibleDuplicate, VersionTag versionTag, byte[] serializedKey, long timestamp) throws ClassNotFoundException, IOException {
        super(valueObject, operation, valueIsObject, possibleDuplicate, versionTag, timestamp);
        this.keyBytes = serializedKey;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeByteArray(this.keyBytes, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.keyBytes = DataSerializer.readByteArray(in);
    }

    @Override
    public void toHoplogEventBytes(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public byte[] getRawKey() {
        return this.keyBytes;
    }

    public static int getSizeInBytes(int keySize, int valueSize, VersionTag versionTag) {
        int size = SortedHoplogPersistedEvent.getSizeInBytes(keySize, valueSize, versionTag);
        return size += keySize;
    }
}

