/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.hdfs.internal.FlushObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SignalledFlushObserver
implements FlushObserver {
    private final List<FlushLatch> signals = new ArrayList<FlushLatch>();
    private final AtomicLong eventsReceived = new AtomicLong(0L);
    private final AtomicLong eventsDelivered = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldDrainImmediately() {
        List<FlushLatch> list = this.signals;
        synchronized (list) {
            return !this.signals.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlushObserver.AsyncFlushResult flush() {
        long seqnum = this.eventsReceived.get();
        List<FlushLatch> list = this.signals;
        synchronized (list) {
            FlushLatch flush;
            if (seqnum <= this.eventsDelivered.get()) {
                flush = null;
            } else {
                flush = new FlushLatch(seqnum);
                this.signals.add(flush);
            }
            return new FlushObserver.AsyncFlushResult(){

                @Override
                public boolean waitForFlush(long timeout, TimeUnit unit) throws InterruptedException {
                    return flush == null ? true : flush.await(timeout, unit);
                }
            };
        }
    }

    public void push() {
        this.eventsReceived.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pop(int count) {
        long highmark = this.eventsDelivered.addAndGet(count);
        List<FlushLatch> list = this.signals;
        synchronized (list) {
            ListIterator<FlushLatch> iter = this.signals.listIterator();
            while (iter.hasNext()) {
                FlushLatch flush = iter.next();
                if (flush.getSequence() > highmark) continue;
                flush.countDown();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<FlushLatch> list = this.signals;
        synchronized (list) {
            for (FlushLatch flush : this.signals) {
                flush.countDown();
            }
            this.signals.clear();
            this.eventsReceived.set(0L);
            this.eventsDelivered.set(0L);
        }
    }

    private static class FlushLatch
    extends CountDownLatch {
        private final long seqnum;

        public FlushLatch(long seqnum) {
            super(1);
            this.seqnum = seqnum;
        }

        public long getSequence() {
            return this.seqnum;
        }
    }
}

