/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class HoplogListenerForRegion
implements HoplogListener {
    private List<HoplogListener> otherListeners = new CopyOnWriteArrayList<HoplogListener>();

    @Override
    public void hoplogCreated(String regionFolder, int bucketId, Hoplog ... oplogs) throws IOException {
        for (HoplogListener listener : this.otherListeners) {
            listener.hoplogCreated(regionFolder, bucketId, oplogs);
        }
    }

    @Override
    public void hoplogDeleted(String regionFolder, int bucketId, Hoplog ... oplogs) {
        for (HoplogListener listener : this.otherListeners) {
            try {
                listener.hoplogDeleted(regionFolder, bucketId, oplogs);
            }
            catch (IOException e) {
                throw new HDFSIOException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void addListener(HoplogListener listener) {
        this.otherListeners.add(listener);
    }

    @Override
    public void compactionCompleted(String region, int bucket, boolean isMajor) {
        for (HoplogListener listener : this.otherListeners) {
            listener.compactionCompleted(region, bucket, isMajor);
        }
    }
}

