/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreConfigHolder;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreMutatorImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSCompactionManager;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSStoreDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HoplogUtil;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.HFileStoreStatistics;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.util.SingletonCallable;
import com.gemstone.gemfire.internal.util.SingletonValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class HDFSStoreImpl
implements HDFSStore {
    private volatile HDFSStoreConfigHolder configHolder;
    private final SingletonValue<FileSystem> fs;
    private final SingletonCallable<Hoplog.HoplogWriter> singletonWriter = new SingletonCallable();
    private final HFileStoreStatistics stats;
    private final BlockCache blockCache;
    private static HashSet<String> secureNameNodes = new HashSet();
    private final boolean PERFORM_SECURE_HDFS_CHECK = Boolean.getBoolean("gemfire.PERFORM_SECURE_HDFS_CHECK");
    private static final Logger logger = LogService.getLogger();
    protected final String logPrefix;
    private final SingletonCallable<Boolean> fsExists = new SingletonCallable();

    public HDFSStoreImpl(String name, HDFSStore config) {
        this.configHolder = new HDFSStoreConfigHolder(config);
        this.configHolder.setName(name);
        this.logPrefix = "<HdfsStore:" + name + "> ";
        this.stats = new HFileStoreStatistics(InternalDistributedSystem.getAnyInstance(), "HDFSStoreStatistics", name);
        final Configuration hconf = new Configuration();
        if (this.getBlockCacheSize() != 0.0f) {
            long cacheSize = (long)((float)HeapMemoryMonitor.getTenuredPoolMaxMemory() * this.getBlockCacheSize() / 100.0f);
            this.blockCache = new LruBlockCache(cacheSize, 8192L, hconf);
        } else {
            this.blockCache = null;
        }
        final String clientFile = config.getHDFSClientConfigFile();
        this.fs = new SingletonValue<FileSystem>(new SingletonValue.SingletonBuilder<FileSystem>(){

            @Override
            public FileSystem create() throws IOException {
                return HDFSStoreImpl.this.createFileSystem(hconf, clientFile, false);
            }

            @Override
            public void postCreate() {
            }

            @Override
            public void createInProgress() {
            }
        });
        FileSystem fileSystem = null;
        try {
            fileSystem = this.fs.get();
        }
        catch (Throwable ex) {
            throw new HDFSIOException(ex.getMessage(), ex);
        }
        long cleanUpIntervalMillis = this.getPurgeInterval() * 60 * 1000;
        Path cleanUpIntervalPath = new Path(this.getHomeDir(), "cleanUpInterval");
        HoplogUtil.exposeCleanupIntervalMillis(fileSystem, cleanUpIntervalPath, cleanUpIntervalMillis);
    }

    public FileSystem createFileSystem() {
        Configuration hconf = new Configuration();
        try {
            return this.createFileSystem(hconf, this.getHDFSClientConfigFile(), true);
        }
        catch (Throwable ex) {
            throw new HDFSIOException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem createFileSystem(Configuration hconf, String configFile, boolean forceNew) throws IOException {
        FileSystem filesystem = null;
        if (configFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Adding resource config file to hdfs configuration:" + configFile, new Object[]{this.logPrefix});
            }
            hconf.addResource(new Path(configFile));
            if (!new File(configFile).exists()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_HDFS_CLIENT_CONFIG_FILE_ABSENT, configFile));
            }
        }
        hconf.setBoolean("fs.automatic.close", false);
        hconf.setStrings("io.serializations", new String[]{"org.apache.hadoop.io.serializer.WritableSerialization"});
        SchemaMetrics.configureGlobally((Configuration)hconf);
        String nameNodeURL = null;
        nameNodeURL = this.getNameNodeURL();
        if (nameNodeURL == null) {
            nameNodeURL = hconf.get("fs.default.name");
        }
        URI namenodeURI = URI.create(nameNodeURL);
        String authType = hconf.get("hadoop.security.authentication");
        UserGroupInformation.setConfiguration((Configuration)hconf);
        if (authType.equalsIgnoreCase("kerberos")) {
            String nameNodePrincipal;
            String principal = hconf.get("gemfirexd.kerberos.principal");
            String keyTab = hconf.get("gemfirexd.kerberos.keytab.file");
            if (!this.PERFORM_SECURE_HDFS_CHECK) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Ignore secure hdfs check", new Object[]{this.logPrefix});
                }
            } else if (!secureNameNodes.contains(nameNodeURL)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Executing secure hdfs check", new Object[]{this.logPrefix});
                }
                try {
                    try {
                        filesystem = FileSystem.newInstance((URI)namenodeURI, (Configuration)hconf);
                        filesystem.listFiles(new Path("/"), false);
                        throw new HDFSIOException("Gemfire XD HDFS client and HDFS cluster security levels do not match. The configured HDFS Namenode is not secured.");
                    }
                    catch (IOException ex) {
                        secureNameNodes.add(nameNodeURL);
                        if (filesystem != null) {
                            this.closeFileSystemIgnoreError(filesystem);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (filesystem != null) {
                        this.closeFileSystemIgnoreError(filesystem);
                    }
                    throw throwable;
                }
            }
            if ((nameNodePrincipal = hconf.get("dfs.namenode.kerberos.principal")) == null) {
                throw new IOException(LocalizedStrings.GF_KERBEROS_NAMENODE_PRINCIPAL_UNDEF.toLocalizedString());
            }
            if (principal != null) {
                String GFXDUser;
                String HDFSUser;
                String regex = "[/@]";
                if (nameNodePrincipal != null && (HDFSUser = nameNodePrincipal.split(regex)[0]).equals(GFXDUser = principal.split(regex)[0])) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HDFS_USER_IS_SAME_AS_GF_USER, GFXDUser));
                }
                if (keyTab == null) {
                    throw new IOException(LocalizedStrings.GF_KERBEROS_KEYTAB_UNDEF.toLocalizedString());
                }
                File f = new File(keyTab);
                if (!f.exists()) {
                    throw new FileNotFoundException(LocalizedStrings.GF_KERBEROS_KEYTAB_FILE_ABSENT.toLocalizedString(f.getAbsolutePath()));
                }
                String principalWithValidHost = SecurityUtil.getServerPrincipal((String)principal, (String)"");
                UserGroupInformation.loginUserFromKeytab((String)principalWithValidHost, (String)keyTab);
            } else {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GF_KERBEROS_PRINCIPAL_UNDEF));
            }
        }
        filesystem = this.getFileSystemFactory().create(namenodeURI, hconf, forceNew);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Initialized FileSystem linked to " + filesystem.getUri() + " " + filesystem.hashCode(), new Object[]{this.logPrefix});
        }
        return filesystem;
    }

    public FileSystem getFileSystem() throws IOException {
        return this.fs.get();
    }

    public FileSystem getCachedFileSystem() {
        return this.fs.getCachedValue();
    }

    public SingletonCallable<Hoplog.HoplogWriter> getSingletonWriter() {
        return this.singletonWriter;
    }

    public boolean checkFileSystemExists() throws IOException {
        try {
            return this.fsExists.runSerially(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    FileSystem fileSystem = HDFSStoreImpl.this.getCachedFileSystem();
                    if (fileSystem == null) {
                        return false;
                    }
                    return fileSystem.exists(new Path("/"));
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void checkAndClearFileSystem() {
        FileSystem fileSystem = this.getCachedFileSystem();
        if (fileSystem != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Checking file system at " + fileSystem.getUri(), new Object[]{this.logPrefix});
            }
            try {
                this.checkFileSystemExists();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}FS client is ok: " + fileSystem.getUri() + " " + fileSystem.hashCode(), new Object[]{this.logPrefix});
                }
                return;
            }
            catch (ConnectTimeoutException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Hdfs unreachable, FS client is ok: " + fileSystem.getUri() + " " + fileSystem.hashCode(), new Object[]{this.logPrefix});
                }
                return;
            }
            catch (IOException e) {
                logger.debug("IOError in filesystem checkAndClear ", (Throwable)e);
                if (e instanceof RemoteException) {
                    e = ((RemoteException)e).unwrapRemoteException();
                }
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_HDFS_UNREACHABLE, fileSystem.getUri()), (Throwable)e);
                boolean result = this.fs.clear(fileSystem, true);
                if (!result) {
                    logger.debug("{}Failed to clear FS ! I am inconsistent so retrying ..", new Object[]{this.logPrefix});
                    this.checkAndClearFileSystem();
                }
                this.closeFileSystemIgnoreError(fileSystem);
            }
        }
    }

    private void closeFileSystemIgnoreError(FileSystem fileSystem) {
        block4: {
            if (fileSystem == null) {
                logger.debug("{}Trying to close null file system", new Object[]{this.logPrefix});
                return;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Closing file system at " + fileSystem.getUri() + " " + fileSystem.hashCode(), new Object[]{this.logPrefix});
                }
                fileSystem.close();
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Failed to close file system at " + fileSystem.getUri() + " " + fileSystem.hashCode(), (Throwable)e);
            }
        }
    }

    public HFileStoreStatistics getStats() {
        return this.stats;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void close() {
        logger.debug("{}Closing file system: " + this.getName(), new Object[]{this.logPrefix});
        this.stats.close();
        this.blockCache.shutdown();
        try {
            HDFSCompactionManager manager = HDFSCompactionManager.getInstance(this);
            if (manager != null) {
                manager.reset();
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        FileSystem fileSystem = this.fs.clear(false);
        if (fileSystem != null) {
            this.closeFileSystemIgnoreError(fileSystem);
        }
    }

    public void clearFolder() throws IOException {
        this.getFileSystem().delete(new Path(this.getHomeDir()), true);
    }

    @Override
    public void destroy() {
        Collection<String> regions = HDFSRegionDirector.getInstance().getRegionsInStore(this);
        if (!regions.isEmpty()) {
            throw new IllegalStateException("Cannot destroy a HDFS store that still contains regions: " + regions);
        }
        this.close();
        HDFSStoreDirector.getInstance().removeHDFSStore(this.getName());
    }

    @Override
    public synchronized HDFSStore alter(HDFSStoreMutator mutator) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Altering hdfsStore " + this, new Object[]{this.logPrefix});
            logger.debug("{}Mutator " + mutator, new Object[]{this.logPrefix});
        }
        HDFSStoreConfigHolder newHolder = new HDFSStoreConfigHolder(this.configHolder);
        newHolder.copyFrom(mutator);
        newHolder.validate();
        HDFSStoreConfigHolder oldStore = this.configHolder;
        this.configHolder = newHolder;
        if (logger.isDebugEnabled()) {
            logger.debug("{}Resuult of Alter " + this, new Object[]{this.logPrefix});
        }
        return oldStore;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HDFSStoreImpl [");
        if (this.configHolder != null) {
            builder.append("configHolder=");
            builder.append(this.configHolder);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.configHolder.getName();
    }

    @Override
    public String getNameNodeURL() {
        return this.configHolder.getNameNodeURL();
    }

    @Override
    public String getHomeDir() {
        return this.configHolder.getHomeDir();
    }

    @Override
    public String getHDFSClientConfigFile() {
        return this.configHolder.getHDFSClientConfigFile();
    }

    @Override
    public float getBlockCacheSize() {
        return this.configHolder.getBlockCacheSize();
    }

    @Override
    public int getWriteOnlyFileRolloverSize() {
        return this.configHolder.getWriteOnlyFileRolloverSize();
    }

    @Override
    public int getWriteOnlyFileRolloverInterval() {
        return this.configHolder.getWriteOnlyFileRolloverInterval();
    }

    @Override
    public boolean getMinorCompaction() {
        return this.configHolder.getMinorCompaction();
    }

    @Override
    public int getMinorCompactionThreads() {
        return this.configHolder.getMinorCompactionThreads();
    }

    @Override
    public boolean getMajorCompaction() {
        return this.configHolder.getMajorCompaction();
    }

    @Override
    public int getMajorCompactionInterval() {
        return this.configHolder.getMajorCompactionInterval();
    }

    @Override
    public int getMajorCompactionThreads() {
        return this.configHolder.getMajorCompactionThreads();
    }

    @Override
    public int getInputFileSizeMax() {
        return this.configHolder.getInputFileSizeMax();
    }

    @Override
    public int getInputFileCountMin() {
        return this.configHolder.getInputFileCountMin();
    }

    @Override
    public int getInputFileCountMax() {
        return this.configHolder.getInputFileCountMax();
    }

    @Override
    public int getPurgeInterval() {
        return this.configHolder.getPurgeInterval();
    }

    @Override
    public String getDiskStoreName() {
        return this.configHolder.getDiskStoreName();
    }

    @Override
    public int getMaxMemory() {
        return this.configHolder.getMaxMemory();
    }

    @Override
    public int getBatchSize() {
        return this.configHolder.getBatchSize();
    }

    @Override
    public int getBatchInterval() {
        return this.configHolder.getBatchInterval();
    }

    @Override
    public boolean getBufferPersistent() {
        return this.configHolder.getBufferPersistent();
    }

    @Override
    public boolean getSynchronousDiskWrite() {
        return this.configHolder.getSynchronousDiskWrite();
    }

    @Override
    public int getDispatcherThreads() {
        return this.configHolder.getDispatcherThreads();
    }

    @Override
    public HDFSStoreMutator createHdfsStoreMutator() {
        return new HDFSStoreMutatorImpl();
    }

    public FileSystemFactory getFileSystemFactory() {
        return new DistributedFileSystemFactory();
    }

    static {
        HdfsConfiguration.init();
    }

    public class DistributedFileSystemFactory
    implements FileSystemFactory {
        private final boolean ALLOW_TEST_FILE_SYSTEM = Boolean.getBoolean("hoplog.ALLOW_LOCAL_HDFS");
        private final boolean USE_FS_CACHE = Boolean.getBoolean("hoplog.use.fs.cache");

        @Override
        public FileSystem create(URI nn, Configuration conf, boolean create) throws IOException {
            FileSystem filesystem = this.USE_FS_CACHE && !create ? FileSystem.get((URI)nn, (Configuration)conf) : FileSystem.newInstance((URI)nn, (Configuration)conf);
            if (filesystem instanceof LocalFileSystem && !this.ALLOW_TEST_FILE_SYSTEM) {
                HDFSStoreImpl.this.closeFileSystemIgnoreError(filesystem);
                throw new IllegalStateException(LocalizedStrings.HOPLOG_TRYING_TO_CREATE_STANDALONE_SYSTEM.toLocalizedString(HDFSStoreImpl.this.getNameNodeURL()));
            }
            return filesystem;
        }
    }

    public static interface FileSystemFactory {
        public FileSystem create(URI var1, Configuration var2, boolean var3) throws IOException;
    }
}

