/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.StoreExistsException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreCreation;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;

public class HDFSStoreFactoryImpl
extends HDFSStoreCreation {
    public static final String DEFAULT_ASYNC_QUEUE_ID_FOR_HDFS = "HDFS_QUEUE";
    private Cache cache;

    public HDFSStoreFactoryImpl(Cache cache) {
        this(cache, null);
    }

    public HDFSStoreFactoryImpl(Cache cache, HDFSStoreCreation config) {
        super(config);
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HDFSStore create(String name) {
        if (name == null) {
            throw new GemFireConfigException("HDFS store name not provided");
        }
        this.configHolder.validate();
        HDFSStoreImpl result = null;
        HDFSStoreFactoryImpl hDFSStoreFactoryImpl = this;
        synchronized (hDFSStoreFactoryImpl) {
            if (this.cache instanceof GemFireCacheImpl) {
                GemFireCacheImpl gfc = (GemFireCacheImpl)this.cache;
                if (gfc.findHDFSStore(name) != null) {
                    throw new StoreExistsException(name);
                }
                HDFSStoreImpl hsi = new HDFSStoreImpl(name, this.configHolder);
                gfc.addHDFSStore(hsi);
                result = hsi;
            }
        }
        return result;
    }

    public static final String getEventQueueName(String regionPath) {
        return "HDFS_QUEUE_" + regionPath.replace('/', '_');
    }

    public HDFSStore getConfigView() {
        return this.configHolder;
    }
}

