/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSEventListener;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSEventQueueFilter;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSWriteOnlyStoreEventListener;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class HDFSIntegrationUtil {
    public static <K, V> AsyncEventQueue createDefaultAsyncQueueForHDFS(Cache cache, boolean writeOnly, String regionPath) {
        return HDFSIntegrationUtil.createAsyncQueueForHDFS(cache, regionPath, writeOnly, null);
    }

    private static AsyncEventQueue createAsyncQueueForHDFS(Cache cache, String regionPath, boolean writeOnly, HDFSStore configView) {
        LogWriterI18n logger = cache.getLoggerI18n();
        String defaultAsyncQueueName = HDFSStoreFactoryImpl.getEventQueueName(regionPath);
        if (configView == null) {
            configView = new HDFSStoreFactoryImpl(cache).getConfigView();
        }
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(configView.getBatchSize());
        factory.setPersistent(configView.getBufferPersistent());
        factory.setDiskStoreName(configView.getDiskStoreName());
        factory.setMaximumQueueMemory(configView.getMaxMemory());
        factory.setBatchTimeInterval(configView.getBatchInterval());
        factory.setDiskSynchronous(configView.getSynchronousDiskWrite());
        factory.setDispatcherThreads(configView.getDispatcherThreads());
        factory.setParallel(true);
        factory.addGatewayEventFilter(new HDFSEventQueueFilter(logger));
        ((AsyncEventQueueFactoryImpl)factory).setBucketSorted(!writeOnly);
        ((AsyncEventQueueFactoryImpl)factory).setIsHDFSQueue(true);
        AsyncEventQueue asyncQ = null;
        asyncQ = !writeOnly ? factory.create(defaultAsyncQueueName, new HDFSEventListener(cache.getLoggerI18n())) : factory.create(defaultAsyncQueueName, new HDFSWriteOnlyStoreEventListener(cache.getLoggerI18n()));
        logger.fine("HDFS: async queue created for HDFS. Id: " + asyncQ.getId() + ". Disk store: " + asyncQ.getDiskStoreName() + ". Batch size: " + asyncQ.getBatchSize() + ". bucket sorted:  " + !writeOnly);
        return asyncQ;
    }

    public static void createAndAddAsyncQueue(String regionPath, RegionAttributes regionAttributes, Cache cache) {
        if (!regionAttributes.getDataPolicy().withHDFS()) {
            return;
        }
        String leaderRegionPath = HDFSIntegrationUtil.getLeaderRegionPath(regionPath, regionAttributes, cache);
        String defaultAsyncQueueName = HDFSStoreFactoryImpl.getEventQueueName(leaderRegionPath);
        if (cache.getAsyncEventQueue(defaultAsyncQueueName) == null && regionAttributes.getHDFSStoreName() != null && regionAttributes.getPartitionAttributes() != null && regionAttributes.getPartitionAttributes().getLocalMaxMemory() != 0) {
            HDFSStoreImpl store = ((GemFireCacheImpl)cache).findHDFSStore(regionAttributes.getHDFSStoreName());
            if (store == null) {
                throw new IllegalStateException(LocalizedStrings.HOPLOG_HDFS_STORE_NOT_FOUND.toLocalizedString(regionAttributes.getHDFSStoreName()));
            }
            HDFSIntegrationUtil.createAsyncQueueForHDFS(cache, leaderRegionPath, regionAttributes.getHDFSWriteOnly(), store);
        }
    }

    private static String getLeaderRegionPath(String regionPath, RegionAttributes regionAttributes, Cache cache) {
        String colocated;
        while (regionAttributes.getPartitionAttributes() != null && (colocated = regionAttributes.getPartitionAttributes().getColocatedWith()) != null) {
            GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
            Region colocatedRegion = gfc.getPartitionedRegion(colocated, false);
            if (colocatedRegion == null) {
                Assert.fail("Could not find parent region " + colocated + " for " + regionPath);
            }
            regionAttributes = colocatedRegion.getAttributes();
            regionPath = colocatedRegion.getFullPath();
        }
        return regionPath;
    }
}

