/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHDFSQueuePersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHDFSQueuePersistedEvent;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class HDFSGatewayEventImpl
extends GatewaySenderEventImpl {
    private static final long serialVersionUID = 4642852957292192406L;
    protected transient boolean keyIsSerialized = false;
    protected byte[] serializedKey = null;
    protected VersionTag versionTag;

    public HDFSGatewayEventImpl() {
    }

    public HDFSGatewayEventImpl(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException {
        super(operation, event, substituteValue);
        this.initializeHDFSGatewayEventObject(event);
    }

    public HDFSGatewayEventImpl(EnumListenerEvent operation, EntryEvent event, Object substituteValue, boolean initialize, int bucketId) throws IOException {
        super(operation, event, substituteValue, initialize, bucketId);
        this.initializeHDFSGatewayEventObject(event);
    }

    public HDFSGatewayEventImpl(EnumListenerEvent operation, EntryEvent event, Object substituteValue, boolean initialize) throws IOException {
        super(operation, event, substituteValue, initialize);
        this.initializeHDFSGatewayEventObject(event);
    }

    protected HDFSGatewayEventImpl(HDFSGatewayEventImpl offHeapEvent) {
        super(offHeapEvent);
        this.keyIsSerialized = offHeapEvent.keyIsSerialized;
        this.serializedKey = offHeapEvent.serializedKey;
        this.versionTag = offHeapEvent.versionTag;
    }

    @Override
    protected GatewaySenderEventImpl makeCopy() {
        return new HDFSGatewayEventImpl(this);
    }

    private void initializeHDFSGatewayEventObject(EntryEvent event) throws IOException {
        this.serializeKey();
        this.versionTag = ((EntryEventImpl)event).getVersionTag();
        if (this.versionTag != null && this.versionTag.getMemberID() == null) {
            this.versionTag.setMemberID(((LocalRegion)this.getRegion()).getVersionMember());
        }
    }

    private void serializeKey() throws IOException {
        if (!this.keyIsSerialized && this.isInitialized()) {
            this.serializedKey = CacheServerHelper.serialize(this.key);
            this.keyIsSerialized = true;
        }
    }

    @Override
    protected boolean shouldApplyDelta() {
        return true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected void serializeKey(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.serializedKey, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    protected void deserializeKey(DataInput in) throws IOException, ClassNotFoundException {
        this.serializedKey = DataSerializer.readByteArray(in);
        this.key = BlobHelper.deserializeBlob(this.serializedKey, InternalDataSerializer.getVersionForDataStreamOrNull(in), null);
        this.keyIsSerialized = true;
    }

    @Override
    public int getDSFID() {
        return -141;
    }

    public byte[] getSerializedKey() {
        return this.serializedKey;
    }

    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public int getSizeOnHDFSInBytes(boolean writeOnly) {
        if (writeOnly) {
            return UnsortedHDFSQueuePersistedEvent.getSizeInBytes(this.serializedKey.length, this.getSerializedValueSize(), this.versionTag);
        }
        return SortedHDFSQueuePersistedEvent.getSizeInBytes(this.serializedKey.length, this.getSerializedValueSize(), this.versionTag);
    }
}

