/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.HDFSRegionMap;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.util.Bytes;

public class HDFSEntriesSet
extends AbstractSet {
    private final LocalRegion.IteratorType type;
    private final HoplogOrganizer hoplogs;
    private final HDFSBucketRegionQueue brq;
    private final BucketRegion region;
    private final ReferenceQueue<HDFSIterator> refs;

    public HDFSEntriesSet(BucketRegion region, HDFSBucketRegionQueue brq, HoplogOrganizer hoplogs, LocalRegion.IteratorType type, ReferenceQueue<HDFSIterator> refs) {
        this.region = region;
        this.brq = brq;
        this.hoplogs = hoplogs;
        this.type = type;
        this.refs = refs;
    }

    public HDFSIterator iterator() {
        HDFSIterator iter = new HDFSIterator(this.type, this.region.getPartitionedRegion(), true);
        if (this.refs != null) {
            new WeakReference<HDFSIterator>(iter, this.refs);
        }
        return iter;
    }

    @Override
    public int size() {
        int size = 0;
        try (HDFSIterator iter = new HDFSIterator(null, this.region.getPartitionedRegion(), false);){
            while (iter.hasNext()) {
                if (!this.includeEntry(iter.next())) continue;
                ++size;
            }
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        try (HDFSIterator iter = new HDFSIterator(null, this.region.getPartitionedRegion(), false);){
            while (iter.hasNext()) {
                if (!this.includeEntry(iter.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean includeEntry(Object val) {
        HDFSGatewayEventImpl evt;
        return !(val instanceof HDFSGatewayEventImpl ? (evt = (HDFSGatewayEventImpl)val).getOperation().isDestroy() : val instanceof PersistedEventImpl && (evt = (PersistedEventImpl)val).getOperation().isDestroy());
    }

    public class HDFSIterator
    implements Iterator {
        private final LocalRegion.IteratorType type;
        private final boolean deserialize;
        private final HDFSBucketRegionQueue.SortedEventQueueIterator queue;
        private final HoplogSetReader.HoplogIterator<byte[], SortedHoplogPersistedEvent> hdfs;
        private Iterator txCreatedEntryIterator;
        private boolean queueNext;
        private boolean hdfsNext;
        private boolean forUpdate;
        private boolean hasTxEntry;
        private byte[] currentHdfsKey;

        public HDFSIterator(LocalRegion.IteratorType type, Region region, boolean deserialize) {
            this.type = type;
            this.deserialize = deserialize;
            if (!HDFSEntriesSet.this.brq.getBucketAdvisor().isPrimaryWithWait()) {
                InternalDistributedMember primaryHolder = HDFSEntriesSet.this.brq.getBucketAdvisor().basicGetPrimaryMember();
                throw new PrimaryBucketException("Bucket " + HDFSEntriesSet.this.brq.getName() + " is not primary. Current primary holder is " + primaryHolder);
            }
            this.queue = HDFSEntriesSet.this.brq.iterator(region);
            this.advanceQueue();
            HoplogSetReader.HoplogIterator tmp = null;
            try {
                tmp = HDFSEntriesSet.this.hoplogs.scan();
            }
            catch (IOException e) {
                HDFSEntriesSet.this.region.checkForPrimary();
                throw new HDFSIOException(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE.toLocalizedString(e.getMessage()), e);
            }
            this.hdfs = tmp;
            if (this.hdfs != null) {
                this.advanceHdfs();
            }
        }

        @Override
        public boolean hasNext() {
            boolean nonTxHasNext;
            boolean bl = nonTxHasNext = this.hdfsNext || this.queueNext;
            if (!nonTxHasNext && this.txCreatedEntryIterator != null) {
                this.hasTxEntry = this.txCreatedEntryIterator.hasNext();
                return this.hasTxEntry;
            }
            return nonTxHasNext;
        }

        public Object next() {
            Object val;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.hasTxEntry) {
                this.hasTxEntry = false;
                return this.txCreatedEntryIterator.next();
            }
            if (!this.queueNext) {
                val = this.getFromHdfs();
                this.advanceHdfs();
            } else if (!this.hdfsNext) {
                val = this.getFromQueue();
                this.advanceQueue();
            } else {
                byte[] hKey;
                byte[] qKey = this.queue.current().getSerializedKey();
                int diff = Bytes.compareTo((byte[])qKey, (byte[])(hKey = this.currentHdfsKey));
                if (diff < 0) {
                    val = this.getFromQueue();
                    this.advanceQueue();
                } else if (diff == 0) {
                    val = this.getFromQueue();
                    this.advanceQueue();
                    this.advanceHdfs();
                } else {
                    val = this.getFromHdfs();
                    this.advanceHdfs();
                }
            }
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.queueNext) {
                this.queue.close();
            }
            if (this.hdfsNext) {
                this.hdfs.close();
            }
        }

        private Object getFromQueue() {
            HDFSGatewayEventImpl evt = this.queue.current();
            if (this.type == null) {
                return evt;
            }
            switch (this.type) {
                case KEYS: {
                    byte[] key = evt.getSerializedKey();
                    return this.deserialize ? (Object)EntryEventImpl.deserialize(key) : key;
                }
                case VALUES: {
                    return evt.getValue();
                }
            }
            Object keyObj = EntryEventImpl.deserialize(evt.getSerializedKey());
            if (keyObj instanceof KeyWithRegionContext) {
                ((KeyWithRegionContext)keyObj).setRegionContext(HDFSEntriesSet.this.region.getPartitionedRegion());
            }
            return ((HDFSRegionMap)((Object)HDFSEntriesSet.this.region.getRegionMap())).getDelegate().getEntryFromEvent(keyObj, evt, true, this.forUpdate);
        }

        private Object getFromHdfs() {
            if (this.type == null) {
                return this.hdfs.getValue();
            }
            switch (this.type) {
                case KEYS: {
                    byte[] key = this.currentHdfsKey;
                    return this.deserialize ? (Object)EntryEventImpl.deserialize(key) : key;
                }
                case VALUES: {
                    PersistedEventImpl evt = this.hdfs.getValue();
                    return evt.getValue();
                }
            }
            Object keyObj = EntryEventImpl.deserialize(this.currentHdfsKey);
            if (keyObj instanceof KeyWithRegionContext) {
                ((KeyWithRegionContext)keyObj).setRegionContext(HDFSEntriesSet.this.region.getPartitionedRegion());
            }
            return ((HDFSRegionMap)((Object)HDFSEntriesSet.this.region.getRegionMap())).getDelegate().getEntryFromEvent(keyObj, this.hdfs.getValue(), true, this.forUpdate);
        }

        private void advanceHdfs() {
            this.hdfsNext = this.hdfs.hasNext();
            if (this.hdfsNext) {
                try {
                    this.currentHdfsKey = this.hdfs.next();
                }
                catch (IOException e) {
                    HDFSEntriesSet.this.region.checkForPrimary();
                    throw new HDFSIOException(LocalizedStrings.HOPLOG_FAILED_TO_READ_HDFS_FILE.toLocalizedString(e.getMessage()), e);
                }
            } else {
                this.currentHdfsKey = null;
                this.hdfs.close();
            }
        }

        private void advanceQueue() {
            this.queueNext = this.queue.hasNext();
            if (this.queueNext) {
                this.queue.next();
            } else {
                HDFSEntriesSet.this.brq.checkForPrimary();
                this.queue.close();
            }
        }

        public void setForUpdate() {
            this.forUpdate = true;
        }
    }
}

