/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableLong;

public class FailureTracker
extends ThreadLocal<MutableInt> {
    private final long minTime;
    private final long maxTime;
    private final float rate;
    private final FailureCount waitTime = new FailureCount();

    public FailureTracker(long minTime, long maxTime, float rate) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.rate = rate;
    }

    public void sleepIfRetry() throws InterruptedException {
        Thread.sleep(this.waitTime());
    }

    public long waitTime() {
        return ((MutableLong)this.waitTime.get()).longValue();
    }

    public void record(boolean success) {
        if (success) {
            this.success();
        } else {
            this.failure();
        }
    }

    public void success() {
        ((MutableLong)this.waitTime.get()).setValue(0L);
    }

    public void failure() {
        long current = ((MutableLong)this.waitTime.get()).intValue();
        if (current == 0L) {
            current = this.minTime;
        } else if (current < this.maxTime) {
            current = (long)((float)current * this.rate);
        }
        ((MutableLong)this.waitTime.get()).setValue(Math.min(current, this.maxTime));
    }

    private static class FailureCount
    extends ThreadLocal<MutableLong> {
        private FailureCount() {
        }

        @Override
        protected MutableLong initialValue() {
            return new MutableLong();
        }
    }
}

