/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.internal.FunctionServiceManager;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Map;
import java.util.Set;

public final class FunctionService {
    private static final FunctionServiceManager functionSvcMgr = new FunctionServiceManager();

    private FunctionService() {
    }

    public static Execution onRegion(Region region) {
        return functionSvcMgr.onRegion(region);
    }

    public static Execution onServer(Pool pool) {
        return functionSvcMgr.onServer(pool, new String[0]);
    }

    public static Execution onServers(Pool pool) {
        return functionSvcMgr.onServers(pool, new String[0]);
    }

    public static Execution onServer(RegionService regionService) {
        return functionSvcMgr.onServer(regionService, new String[0]);
    }

    public static Execution onServers(RegionService regionService) {
        return functionSvcMgr.onServers(regionService, new String[0]);
    }

    public static Execution onMember(DistributedSystem system, DistributedMember distributedMember) {
        return functionSvcMgr.onMember(system, distributedMember);
    }

    public static Execution onMembers(DistributedSystem system) {
        return functionSvcMgr.onMembers(system, new String[0]);
    }

    public static Execution onMembers(DistributedSystem system, Set<DistributedMember> distributedMembers) {
        return functionSvcMgr.onMembers(system, distributedMembers);
    }

    public static Execution onMember(DistributedMember distributedMember) {
        return functionSvcMgr.onMember(FunctionService.getDistributedSystem(), distributedMember);
    }

    public static Execution onMembers(String ... groups) {
        return functionSvcMgr.onMembers(FunctionService.getDistributedSystem(), groups);
    }

    public static Execution onMembers(Set<DistributedMember> distributedMembers) {
        return functionSvcMgr.onMembers(FunctionService.getDistributedSystem(), distributedMembers);
    }

    public static Execution onMember(String ... groups) {
        return functionSvcMgr.onMember(FunctionService.getDistributedSystem(), groups);
    }

    public static Function getFunction(String functionId) {
        return functionSvcMgr.getFunction(functionId);
    }

    public static void registerFunction(Function function) {
        functionSvcMgr.registerFunction(function);
    }

    public static void unregisterFunction(String functionId) {
        functionSvcMgr.unregisterFunction(functionId);
    }

    public static boolean isRegistered(String functionId) {
        return functionSvcMgr.isRegistered(functionId);
    }

    public static Map<String, Function> getRegisteredFunctions() {
        return functionSvcMgr.getRegisteredFunctions();
    }

    private static DistributedSystem getDistributedSystem() {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system == null) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.InternalDistributedSystem_THIS_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_HAS_BEEN_DISCONNECTED.toLocalizedString());
        }
        return system;
    }
}

