/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.client.internal.locator.SerializationHelper;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class QueueConnectionResponse
extends ServerLocationResponse {
    private boolean durableQueueFound;
    private List servers;
    private boolean serversFound = false;

    public QueueConnectionResponse() {
    }

    public QueueConnectionResponse(boolean durableQueueFound, List servers) {
        this.durableQueueFound = durableQueueFound;
        this.servers = servers;
        if (servers != null && !servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.durableQueueFound = DataSerializer.readPrimitiveBoolean(in);
        this.servers = SerializationHelper.readServerLocationList(in);
        if (this.servers != null && !this.servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writePrimitiveBoolean(this.durableQueueFound, out);
        SerializationHelper.writeServerLocationList(this.servers, out);
    }

    public boolean isDurableQueueFound() {
        return this.durableQueueFound;
    }

    public List getServers() {
        return this.servers;
    }

    public String toString() {
        return "QueueConnectionResponse{durableQueueFound=" + this.durableQueueFound + ", servers=" + this.servers + "}";
    }

    @Override
    public int getDSFID() {
        return -49;
    }

    @Override
    public boolean hasResult() {
        return this.serversFound;
    }
}

