/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator;

import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionRequest;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public class ClientReplacementRequest
extends ClientConnectionRequest {
    private ServerLocation currentServer;

    public ClientReplacementRequest() {
    }

    public ClientReplacementRequest(ServerLocation currentServer, Set excludedServers, String serverGroup) {
        super(excludedServers, serverGroup);
        this.currentServer = currentServer;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.currentServer = new ServerLocation();
        InternalDataSerializer.invokeFromData(this.currentServer, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.currentServer, out);
    }

    public ServerLocation getCurrentServer() {
        return this.currentServer;
    }

    @Override
    public String toString() {
        return "ClientReplacementRequest{group=" + this.getServerGroup() + ", excluded=" + this.getExcludedServers() + ", currentServer=" + this.getCurrentServer() + "}";
    }

    @Override
    public int getDSFID() {
        return -48;
    }
}

