/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.AllConnectionsInUseException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ExecuteRegionFunctionOp;
import com.gemstone.gemfire.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import java.util.concurrent.Callable;

public class SingleHopOperationCallable
implements Callable {
    private final ServerLocation server;
    private final PoolImpl pool;
    private final AbstractOp op;
    private final UserAttributes securityAttributes;

    public SingleHopOperationCallable(ServerLocation server, PoolImpl pool, AbstractOp op, UserAttributes securityAttributes) {
        this.server = server;
        this.pool = pool;
        this.op = op;
        this.securityAttributes = securityAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        this.op.initMessagePart();
        Object result = null;
        boolean onlyUseExistingCnx = this.pool.getMaxConnections() != -1 && this.pool.getConnectionCount() >= this.pool.getMaxConnections();
        try {
            UserAttributes.userAttributes.set(this.securityAttributes);
            result = this.pool.executeOn(this.server, this.op, true, onlyUseExistingCnx);
        }
        catch (AllConnectionsInUseException ex) {
            if (this.op instanceof ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl) {
                ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl newop = (ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl)this.op;
                result = this.pool.execute(new ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl(newop));
            } else {
                result = this.pool.execute(this.op);
            }
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
        return result;
    }

    public ServerLocation getServer() {
        return this.server;
    }

    public AbstractOp getOperation() {
        return this.op;
    }
}

