/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class ServerBlackList {
    private static final Logger logger = LogService.getLogger();
    private final Map failureTrackerMap = new HashMap();
    protected final Set blacklist = new CopyOnWriteArraySet();
    private final Set unmodifiableBlacklist = Collections.unmodifiableSet(this.blacklist);
    protected ScheduledExecutorService background;
    protected final ListenerBroadcaster broadcaster = new ListenerBroadcaster();
    static int THRESHOLD = Integer.getInteger("gemfire.ServerBlackList.THRESHOLD", 3);
    protected final long pingInterval;

    public ServerBlackList(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void start(ScheduledExecutorService background) {
        this.background = background;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FailureTracker getFailureTracker(ServerLocation location) {
        FailureTracker failureTracker;
        Map map = this.failureTrackerMap;
        synchronized (map) {
            failureTracker = (FailureTracker)this.failureTrackerMap.get(location);
            if (failureTracker == null) {
                failureTracker = new FailureTracker(location);
                this.failureTrackerMap.put(location, failureTracker);
            }
        }
        return failureTracker;
    }

    public Set getBadServers() {
        return this.unmodifiableBlacklist;
    }

    public void addListener(BlackListListener blackListListener) {
        this.broadcaster.listeners.add(blackListListener);
    }

    public void removeListener(BlackListListener blackListListener) {
        this.broadcaster.listeners.remove(blackListListener);
    }

    protected static class ListenerBroadcaster
    implements BlackListListener {
        protected Set listeners = new CopyOnWriteArraySet();

        protected ListenerBroadcaster() {
        }

        @Override
        public void serverAdded(ServerLocation location) {
            for (BlackListListener listener : this.listeners) {
                listener.serverAdded(location);
            }
        }

        @Override
        public void serverRemoved(ServerLocation location) {
            for (BlackListListener listener : this.listeners) {
                listener.serverRemoved(location);
            }
        }
    }

    public static class BlackListListenerAdapter
    implements BlackListListener {
        @Override
        public void serverAdded(ServerLocation location) {
        }

        @Override
        public void serverRemoved(ServerLocation location) {
        }
    }

    public static interface BlackListListener {
        public void serverAdded(ServerLocation var1);

        public void serverRemoved(ServerLocation var1);
    }

    private class ExpireBlackListTask
    extends PoolImpl.PoolTask {
        private ServerLocation location;

        public ExpireBlackListTask(ServerLocation location) {
            this.location = location;
        }

        @Override
        public void run2() {
            if (logger.isDebugEnabled()) {
                logger.debug("{} is no longer blacklisted", new Object[]{this.location});
            }
            ServerBlackList.this.blacklist.remove(this.location);
            ServerBlackList.this.broadcaster.serverRemoved(this.location);
        }
    }

    public class FailureTracker {
        private final AtomicInteger consecutiveFailures = new AtomicInteger();
        private final ServerLocation location;

        public FailureTracker(ServerLocation location) {
            this.location = location;
        }

        public void reset() {
            this.consecutiveFailures.set(0);
        }

        public void addFailure() {
            if (ServerBlackList.this.blacklist.contains(this.location)) {
                return;
            }
            long failures = this.consecutiveFailures.incrementAndGet();
            if (failures >= (long)THRESHOLD) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Blacklisting server {} for {}ms because it had {} consecutive failures", new Object[]{this.location, ServerBlackList.this.pingInterval, failures});
                }
                ServerBlackList.this.blacklist.add(this.location);
                ServerBlackList.this.broadcaster.serverAdded(this.location);
                try {
                    ServerBlackList.this.background.schedule(new ExpireBlackListTask(this.location), ServerBlackList.this.pingInterval, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }
}

