/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;

public class GetEventValueOp {
    public static Object executeOnPrimary(ExecutablePool pool, EventID event, Object callbackArg) {
        GetEventValueOpImpl op = new GetEventValueOpImpl(event, callbackArg);
        return pool.executeOnPrimary(op);
    }

    private GetEventValueOp() {
    }

    static class GetEventValueOpImpl
    extends AbstractOp {
        public GetEventValueOpImpl(EventID event, Object callbackArg) {
            super(68, callbackArg != null ? 2 : 1);
            this.getMessage().addObjPart(event);
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 1) {
                return part;
            }
            if (msgType == 69) {
                return null;
            }
            if (msgType == 2) {
                String s = "While performing a remote getFullValue";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

