/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class DestroyRegionOp {
    public static void execute(ExecutablePool pool, String region, EventID eventId, Object callbackArg) {
        DestroyRegionOpImpl op = new DestroyRegionOpImpl(region, eventId, callbackArg);
        pool.execute(op);
    }

    public static void execute(Connection con, ExecutablePool pool, String region, EventID eventId, Object callbackArg) {
        DestroyRegionOpImpl op = new DestroyRegionOpImpl(region, eventId, callbackArg);
        pool.executeOn(con, (Op)op);
    }

    private DestroyRegionOp() {
    }

    private static class DestroyRegionOpImpl
    extends AbstractOp {
        public DestroyRegionOpImpl(String region, EventID eventId, Object callbackArg) {
            super(11, callbackArg != null ? 3 : 2);
            this.getMessage().addStringPart(region);
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "destroyRegion");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 12;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startDestroyRegion();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endDestroyRegionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endDestroyRegion(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

