/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.RegisterDataSerializersOp;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DataSerializerRecoveryListener
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private final AtomicInteger endpointCount = new AtomicInteger();
    protected final InternalPool pool;
    protected final ScheduledExecutorService background;
    protected final long pingInterval;
    protected final Object recoveryScheduledLock = new Object();
    protected boolean recoveryScheduled;

    public DataSerializerRecoveryListener(ScheduledExecutorService background, InternalPool pool) {
        this.pool = pool;
        this.pingInterval = pool.getPingInterval();
        this.background = background;
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("DataSerializerRecoveryTask - EndpointCrashed. Now have {} endpoints", new Object[]{count});
        }
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("DataSerializerRecoveryTask - EndpointNoLongerInUse. Now have {} endpoints", new Object[]{count});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        int count = this.endpointCount.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("DataSerializerRecoveryTask - EndpointNowInUse. Now have {} endpoints", new Object[]{count});
        }
        if (count == 1) {
            Object object = this.recoveryScheduledLock;
            synchronized (object) {
                if (!this.recoveryScheduled) {
                    try {
                        this.recoveryScheduled = true;
                        this.background.execute(new RecoveryTask());
                        logger.debug("DataSerializerRecoveryTask - Scheduled Recovery Task");
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class RecoveryTask
    extends PoolImpl.PoolTask {
        protected RecoveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() {
            if (DataSerializerRecoveryListener.this.pool.getCancelCriterion().cancelInProgress() != null) {
                return;
            }
            Object object = DataSerializerRecoveryListener.this.recoveryScheduledLock;
            synchronized (object) {
                DataSerializerRecoveryListener.this.recoveryScheduled = false;
            }
            logger.debug("DataSerializerRecoveryTask - Attempting to recover dataSerializers");
            InternalDataSerializer.SerializerAttributesHolder[] holders = InternalDataSerializer.getSerializersForDistribution();
            if (holders.length == 0) {
                return;
            }
            EventID eventId = InternalDataSerializer.generateEventId();
            if (eventId == null) {
                try {
                    DataSerializerRecoveryListener.this.background.schedule(new RecoveryTask(), DataSerializerRecoveryListener.this.pingInterval, TimeUnit.MILLISECONDS);
                    DataSerializerRecoveryListener.this.recoveryScheduled = true;
                }
                catch (RejectedExecutionException e) {
                    DataSerializerRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                    throw e;
                }
            }
            try {
                RegisterDataSerializersOp.execute((ExecutablePool)DataSerializerRecoveryListener.this.pool, holders, eventId);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (RejectedExecutionException e) {
                DataSerializerRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                throw e;
            }
            catch (Exception e) {
                DataSerializerRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                Throwable cause = e.getCause();
                boolean cnfException = false;
                if (cause instanceof ClassNotFoundException) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DataSerializerRecoveryListener_ERROR_CLASSNOTFOUNDEXCEPTION, cause.getMessage()));
                    cnfException = true;
                }
                if (!DataSerializerRecoveryListener.this.recoveryScheduled && !cnfException) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DataSerializerRecoveryListener_ERROR_RECOVERING_DATASERIALIZERS), (Throwable)e);
                    DataSerializerRecoveryListener.this.background.schedule(new RecoveryTask(), DataSerializerRecoveryListener.this.pingInterval, TimeUnit.MILLISECONDS);
                    DataSerializerRecoveryListener.this.recoveryScheduled = true;
                }
            }
            finally {
                DataSerializerRecoveryListener.this.pool.releaseThreadLocalConnection();
            }
        }
    }
}

