/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.asyncqueue.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.asyncqueue.internal.ParallelAsyncEventQueueImpl;
import com.gemstone.gemfire.cache.asyncqueue.internal.SerialAsyncEventQueueImpl;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AsyncEventQueueConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.xmlcache.AsyncEventQueueCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ParallelAsyncEventQueueCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.SerialAsyncEventQueueCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AsyncEventQueueFactoryImpl
implements AsyncEventQueueFactory {
    private static final Logger logger = LogService.getLogger();
    private GatewaySenderAttributes attrs = new GatewaySenderAttributes();
    private Cache cache;
    public static final int DEFAULT_BATCH_TIME_INTERVAL = 5;

    public AsyncEventQueueFactoryImpl(Cache cache) {
        this.cache = cache;
        this.attrs = new GatewaySenderAttributes();
        this.attrs.batchTimeInterval = 5;
    }

    @Override
    public AsyncEventQueueFactory setBatchSize(int size) {
        this.attrs.batchSize = size;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setPersistent(boolean isPersistent) {
        this.attrs.isPersistenceEnabled = isPersistent;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskStoreName(String name) {
        this.attrs.diskStoreName = name;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setMaximumQueueMemory(int memory) {
        this.attrs.maximumQueueMemory = memory;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskSynchronous(boolean isSynchronous) {
        this.attrs.isDiskSynchronous = isSynchronous;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchTimeInterval(int batchTimeInterval) {
        this.attrs.batchTimeInterval = batchTimeInterval;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchConflationEnabled(boolean isConflation) {
        this.attrs.isBatchConflationEnabled = isConflation;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDispatcherThreads(int numThreads) {
        this.attrs.dispatcherThreads = numThreads;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setOrderPolicy(GatewaySender.OrderPolicy policy) {
        this.attrs.policy = policy;
        return this;
    }

    @Override
    public AsyncEventQueueFactory addGatewayEventFilter(GatewayEventFilter filter) {
        this.attrs.addGatewayEventFilter(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory removeGatewayEventFilter(GatewayEventFilter filter) {
        this.attrs.eventFilters.remove(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setGatewayEventSubstitutionListener(GatewayEventSubstitutionFilter filter) {
        this.attrs.eventSubstitutionFilter = filter;
        return this;
    }

    public AsyncEventQueueFactory removeGatewayEventAlternateValueProvider(GatewayEventSubstitutionFilter provider) {
        return this;
    }

    public AsyncEventQueueFactory addAsyncEventListener(AsyncEventListener listener) {
        this.attrs.addAsyncEventListener(listener);
        return this;
    }

    @Override
    public AsyncEventQueue create(String asyncQueueId, AsyncEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(LocalizedStrings.AsyncEventQueue_ASYNC_EVENT_LISTENER_CANNOT_BE_NULL.toLocalizedString());
        }
        AsyncEventQueue asyncEventQueue = null;
        if (this.cache instanceof GemFireCacheImpl) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating GatewaySender that underlies the AsyncEventQueue");
            }
            this.addAsyncEventListener(listener);
            GatewaySender sender = this.create(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncQueueId));
            AsyncEventQueueImpl queue = new AsyncEventQueueImpl(sender, listener);
            asyncEventQueue = queue;
            ((GemFireCacheImpl)this.cache).addAsyncEventQueue(queue);
        } else if (this.cache instanceof CacheCreation) {
            asyncEventQueue = new AsyncEventQueueCreation(asyncQueueId, this.attrs, listener);
            ((CacheCreation)this.cache).addAsyncEventQueue(asyncEventQueue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning AsyncEventQueue" + asyncEventQueue);
        }
        return asyncEventQueue;
    }

    private GatewaySender create(String id) {
        this.attrs.id = id;
        AbstractGatewaySender sender = null;
        if (this.attrs.getDispatcherThreads() <= 0) {
            throw new AsyncEventQueueConfigurationException(LocalizedStrings.AsyncEventQueue_0_CANNOT_HAVE_DISPATCHER_THREADS_LESS_THAN_1.toLocalizedString(id));
        }
        if (this.attrs.isParallel()) {
            if (this.attrs.getOrderPolicy() != null && this.attrs.getOrderPolicy().equals((Object)GatewaySender.OrderPolicy.THREAD)) {
                throw new AsyncEventQueueConfigurationException(LocalizedStrings.AsyncEventQueue_0_CANNOT_BE_CREATED_WITH_ORDER_POLICY_1.toLocalizedString(new Object[]{id, this.attrs.getOrderPolicy()}));
            }
            if (this.cache instanceof GemFireCacheImpl) {
                sender = new ParallelAsyncEventQueueImpl(this.cache, this.attrs);
                ((GemFireCacheImpl)this.cache).addGatewaySender(sender);
                if (!this.attrs.isManualStart()) {
                    sender.start();
                }
            } else if (this.cache instanceof CacheCreation) {
                sender = new ParallelAsyncEventQueueCreation(this.cache, this.attrs);
                ((CacheCreation)this.cache).addGatewaySender(sender);
            }
        } else {
            if (this.attrs.getOrderPolicy() == null && this.attrs.getDispatcherThreads() > 1) {
                this.attrs.policy = GatewaySender.DEFAULT_ORDER_POLICY;
            }
            if (this.cache instanceof GemFireCacheImpl) {
                sender = new SerialAsyncEventQueueImpl(this.cache, this.attrs);
                ((GemFireCacheImpl)this.cache).addGatewaySender(sender);
                if (!this.attrs.isManualStart()) {
                    sender.start();
                }
            } else if (this.cache instanceof CacheCreation) {
                sender = new SerialAsyncEventQueueCreation(this.cache, this.attrs);
                ((CacheCreation)this.cache).addGatewaySender(sender);
            }
        }
        return sender;
    }

    public void configureAsyncEventQueue(AsyncEventQueue asyncQueueCreation) {
        this.attrs.batchSize = asyncQueueCreation.getBatchSize();
        this.attrs.batchTimeInterval = asyncQueueCreation.getBatchTimeInterval();
        this.attrs.isBatchConflationEnabled = asyncQueueCreation.isBatchConflationEnabled();
        this.attrs.isPersistenceEnabled = asyncQueueCreation.isPersistent();
        this.attrs.diskStoreName = asyncQueueCreation.getDiskStoreName();
        this.attrs.isDiskSynchronous = asyncQueueCreation.isDiskSynchronous();
        this.attrs.maximumQueueMemory = asyncQueueCreation.getMaximumQueueMemory();
        this.attrs.isParallel = asyncQueueCreation.isParallel();
        this.attrs.isBucketSorted = ((AsyncEventQueueCreation)asyncQueueCreation).isBucketSorted();
        this.attrs.isHDFSQueue = ((AsyncEventQueueCreation)asyncQueueCreation).isHDFSQueue();
        this.attrs.dispatcherThreads = asyncQueueCreation.getDispatcherThreads();
        this.attrs.policy = asyncQueueCreation.getOrderPolicy();
        this.attrs.eventFilters = asyncQueueCreation.getGatewayEventFilters();
        this.attrs.eventSubstitutionFilter = asyncQueueCreation.getGatewayEventSubstitutionFilter();
        this.attrs.isForInternalUse = true;
    }

    @Override
    public AsyncEventQueueFactory setParallel(boolean isParallel) {
        this.attrs.isParallel = isParallel;
        return this;
    }

    public AsyncEventQueueFactory setBucketSorted(boolean isbucketSorted) {
        this.attrs.isBucketSorted = isbucketSorted;
        return this;
    }

    public AsyncEventQueueFactory setIsHDFSQueue(boolean isHDFSQueue) {
        this.attrs.isHDFSQueue = isHDFSQueue;
        return this;
    }

    public AsyncEventQueueFactory setIsMetaQueue(boolean isMetaQueue) {
        this.attrs.isMetaQueue = isMetaQueue;
        return this;
    }
}

