/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Scope
implements Serializable {
    private static final long serialVersionUID = 5534399159504301602L;
    public static final Scope LOCAL = new Scope("LOCAL");
    public static final Scope DISTRIBUTED_NO_ACK = new Scope("DISTRIBUTED_NO_ACK");
    public static final Scope DISTRIBUTED_ACK = new Scope("DISTRIBUTED_ACK");
    public static final Scope GLOBAL = new Scope("GLOBAL");
    private final transient String name;
    public final int ordinal = nextOrdinal++;
    private static int nextOrdinal = 0;
    private static final Scope[] VALUES = new Scope[]{LOCAL, DISTRIBUTED_NO_ACK, DISTRIBUTED_ACK, GLOBAL};
    static final int SCOPE_LOCAL = 0;
    static final int SCOPE_DISTRIBUTED_NO_ACK = 1;
    static final int SCOPE_DISTRIBUTED_ACK = 2;
    static final int SCOPE_GLOBAL = 3;

    private Object readResolve() throws ObjectStreamException {
        return Scope.fromOrdinal(this.ordinal);
    }

    private Scope(String name) {
        this.name = name;
    }

    public static Scope fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public boolean isLocal() {
        return this == LOCAL;
    }

    public boolean isDistributed() {
        return this != LOCAL;
    }

    public boolean isDistributedNoAck() {
        return this == DISTRIBUTED_NO_ACK;
    }

    public boolean isDistributedAck() {
        return this == DISTRIBUTED_ACK;
    }

    public boolean isGlobal() {
        return this == GLOBAL;
    }

    public boolean isAck() {
        return this == DISTRIBUTED_ACK || this == GLOBAL;
    }

    public String toString() {
        return this.name;
    }

    public static Scope fromString(String scope) {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].toString().equals(scope)) continue;
            return VALUES[i];
        }
        throw new IllegalArgumentException(LocalizedStrings.Scope_0_IS_NOT_A_VALID_STRING_REPRESENTATION_OF_1.toLocalizedString(scope, Scope.class.getName()));
    }
}

