/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.internal.SystemMemberBridgeServerImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheImpl;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResourceType;
import com.gemstone.gemfire.internal.admin.AdminBridgeServer;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;

public class SystemMemberBridgeServerJmxImpl
extends SystemMemberBridgeServerImpl
implements ManagedResource {
    private ObjectName objectName;
    private String mbeanName;
    private ModelMBean modelMBean;

    SystemMemberBridgeServerJmxImpl(SystemMemberCacheImpl cache, AdminBridgeServer bridgeInfo) throws AdminException {
        super(cache, bridgeInfo);
        this.initializeMBean(cache);
    }

    private void initializeMBean(SystemMemberCacheImpl cache) throws AdminException {
        GemFireVM vm = cache.getVM();
        this.mbeanName = new StringBuffer("GemFire.Cache:").append("name=").append(MBeanUtil.makeCompliantMBeanNameProperty(cache.getName())).append(",id=").append(this.getBridgeId()).append(",owner=").append(MBeanUtil.makeCompliantMBeanNameProperty(vm.getId().toString())).append(",type=CacheServer").toString();
        this.objectName = MBeanUtil.createMBean(this);
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.SYSTEM_MEMBER_CACHE_SERVER;
    }

    @Override
    public void cleanupResource() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemMemberBridgeServerJmxImpl)) {
            return false;
        }
        SystemMemberBridgeServerJmxImpl other = (SystemMemberBridgeServerJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

