/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.admin.jmx.internal.RMIRegistryServiceMBean;
import com.gemstone.gemfire.admin.jmx.internal.RMIServerSocketFactoryImpl;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;

public class RMIRegistryService
implements RMIRegistryServiceMBean {
    private String host;
    private int port;
    private Registry registry;
    private RMIServerSocketFactory ssf;
    private boolean isRunning;

    public RMIRegistryService() {
        this(1099);
    }

    public RMIRegistryService(int port) {
        this.setPort(port);
    }

    public RMIRegistryService(String host, int port) throws UnknownHostException {
        this.setPort(port);
        this.setHost(host);
        if (host != null && !host.trim().equals("")) {
            this.ssf = new RMIServerSocketFactoryImpl(host);
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    protected void setHost(String host) {
        if (this.isRunning()) {
            throw new IllegalStateException("RMIRegistryService is running, cannot change the host");
        }
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("RMIRegistryService is running, cannot change the port");
        }
        this.port = port;
    }

    @Override
    public synchronized void start() throws RemoteException {
        if (!this.isRunning()) {
            this.registry = this.ssf != null ? LocateRegistry.createRegistry(this.port, null, this.ssf) : LocateRegistry.createRegistry(this.port);
            this.isRunning = true;
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public synchronized void stop() throws NoSuchObjectException {
        if (this.isRunning()) {
            this.isRunning = !UnicastRemoteObject.unexportObject(this.registry, true);
        }
    }

    @Override
    public String[] list() throws RemoteException {
        if (!this.isRunning()) {
            throw new IllegalStateException("RMIRegistryService is not running");
        }
        return this.registry.list();
    }

    @Override
    public void unbind(String name) throws RemoteException, NotBoundException {
        if (!this.isRunning()) {
            throw new IllegalStateException("RMIRegistryService is not running");
        }
        this.registry.unbind(name);
    }
}

