/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.admin.internal.GemFireHealthImpl;
import com.gemstone.gemfire.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.DistributedSystemHealthConfigJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.GemFireHealthConfigJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResourceType;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.logging.log4j.Logger;

public class GemFireHealthJmxImpl
extends GemFireHealthImpl
implements ManagedResource {
    private static final Logger logger = LogService.getLogger();
    private String mbeanName;
    private ModelMBean modelMBean;
    private final ObjectName objectName;

    GemFireHealthJmxImpl(GfManagerAgent agent, AdminDistributedSystemJmxImpl system) throws AdminException {
        super(agent, system);
        this.mbeanName = new StringBuffer().append("GemFire:type=").append("GemFireHealth,id=").append(MBeanUtil.makeCompliantMBeanNameProperty(system.getId())).toString();
        this.objectName = MBeanUtil.createMBean(this);
    }

    public String getHealthStatus() {
        return this.getHealth().toString();
    }

    public ObjectName manageGemFireHealthConfig(String hostName) throws MalformedObjectNameException {
        try {
            GemFireHealthConfig config = this.getGemFireHealthConfig(hostName);
            GemFireHealthConfigJmxImpl jmx = (GemFireHealthConfigJmxImpl)config;
            return new ObjectName(jmx.getMBeanName());
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected DistributedSystemHealthConfig createDistributedSystemHealthConfig() {
        try {
            return new DistributedSystemHealthConfigJmxImpl(this);
        }
        catch (AdminException ex) {
            throw new RuntimeAdminException(LocalizedStrings.GemFireHealthJmxImpl_WHILE_GETTING_THE_DISTRIBUTEDSYSTEMHEALTHCONFIG.toLocalizedString(), ex);
        }
    }

    @Override
    protected GemFireHealthConfig createGemFireHealthConfig(String hostName) {
        try {
            return new GemFireHealthConfigJmxImpl(this, hostName);
        }
        catch (AdminException ex) {
            throw new RuntimeAdminException(LocalizedStrings.GemFireHealthJmxImpl_WHILE_GETTING_THE_GEMFIREHEALTHCONFIG.toLocalizedString(), ex);
        }
    }

    protected void ensureMBeansAreRegistered() {
        MBeanUtil.ensureMBeanIsRegistered(this);
        MBeanUtil.ensureMBeanIsRegistered((ManagedResource)((Object)this.defaultConfig));
        MBeanUtil.ensureMBeanIsRegistered((ManagedResource)((Object)this.dsHealthConfig));
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.GEMFIRE_HEALTH;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public void cleanupResource() {
        this.close();
    }
}

