/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheServer;
import com.gemstone.gemfire.admin.CacheServerConfig;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.CacheVmConfig;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.admin.DistributionLocatorConfig;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCacheEvent;
import com.gemstone.gemfire.admin.SystemMemberRegionEvent;
import com.gemstone.gemfire.admin.SystemMemberType;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.internal.CacheServerConfigImpl;
import com.gemstone.gemfire.admin.internal.DistributionLocatorImpl;
import com.gemstone.gemfire.admin.jmx.internal.AgentConfigImpl;
import com.gemstone.gemfire.admin.jmx.internal.CacheAndRegionListenerImpl;
import com.gemstone.gemfire.admin.jmx.internal.CacheServerJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.DistributionLocatorJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.GemFireHealthJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.admin.jmx.internal.MailManager;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResourceType;
import com.gemstone.gemfire.admin.jmx.internal.StatAlertNotification;
import com.gemstone.gemfire.admin.jmx.internal.StatAlertsAggregator;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberJmx;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberJmxImpl;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.Alert;
import com.gemstone.gemfire.internal.admin.ApplicationVM;
import com.gemstone.gemfire.internal.admin.ClientMembershipMessage;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.StatAlert;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class AdminDistributedSystemJmxImpl
extends AdminDistributedSystemImpl
implements ManagedResource,
DistributedSystemConfig,
StatAlertsAggregator {
    private static final Logger logger = LogService.getLogger();
    private Properties mailProps;
    private String statAlertDefnSerFile = System.getProperty("user.dir");
    private final AtomicInteger notificationSequenceNumber = new AtomicInteger();
    private volatile boolean isRmiClientCountZero;
    private volatile boolean canPersistStatAlertDefs = true;
    private CacheAndRegionListenerImpl cacheRegionListener;
    public static final String NOTIF_MEMBER_JOINED = "gemfire.distributedsystem.member.joined";
    public static final String NOTIF_MEMBER_LEFT = "gemfire.distributedsystem.member.left";
    public static final String NOTIF_MEMBER_CRASHED = "gemfire.distributedsystem.member.crashed";
    public static final String NOTIF_ALERT = "gemfire.distributedsystem.alert";
    public static final String NOTIF_STAT_ALERT = "gemfire.distributedsystem.statalert";
    public static final String NOTIF_ADMIN_SYSTEM_DISCONNECT = "gemfire.distributedsystem.disconnect";
    private static final String EML_SUBJ_PRFX_GFE_ALERT = "[GemFire Alert] ";
    private static final String EML_SUBJ_PRFX_GFE_NOTFY = "[GemFire Notification] ";
    private static final String EML_SUBJ_ITEM_GFE_DS = "Distributed System: ";
    private String mbeanName;
    private final ObjectName objectName;
    private ModelMBean modelMBean;
    private static final String[] PERSISTENT_ID_FIELDS = new String[]{"host", "directory", "uuid"};
    private static final String[] PERSISTENT_ID_DESCRIPTIONS = new String[]{"The host that was persisting the missing files", "The directory where the files were persisted", "The unique id for the persistent files"};
    private final CompositeType PERSISTENT_ID_TYPE;
    private final TabularType PERSISTENT_ID_TABLE_TYPE;
    private final Map ALERT_DEFINITIONS;
    private int refreshIntervalForStatAlerts;
    private final HashMap alertsStore;
    private MailManager mailManager;
    private final boolean isEmailNotificationEnabled;

    public AdminDistributedSystemJmxImpl(AgentConfigImpl config) throws AdminException {
        super(config);
        try {
            this.PERSISTENT_ID_TYPE = new CompositeType(PersistentID.class.getCanonicalName(), "A single member's a set of persistent files for a region", PERSISTENT_ID_FIELDS, PERSISTENT_ID_DESCRIPTIONS, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            this.PERSISTENT_ID_TABLE_TYPE = new TabularType("TABLE_" + this.PERSISTENT_ID_TYPE.getTypeName(), "A table of persistent member ids", this.PERSISTENT_ID_TYPE, PERSISTENT_ID_FIELDS);
        }
        catch (OpenDataException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.ALERT_DEFINITIONS = new Hashtable();
        this.refreshIntervalForStatAlerts = 20;
        this.alertsStore = new HashMap();
        this.mailManager = null;
        this.mbeanName = "GemFire:type=AdminDistributedSystem,id=" + MBeanUtil.makeCompliantMBeanNameProperty(this.getId());
        this.objectName = MBeanUtil.createMBean(this);
        this.isEmailNotificationEnabled = config.isEmailNotificationEnabled();
        if (this.isEmailNotificationEnabled) {
            this.initMailProps(config);
        }
        this.initStateSaveFile(config);
        Assert.assertTrue(this.objectName != null);
        this.cacheRegionListener = new CacheAndRegionListenerImpl(this);
    }

    private void initMailProps(AgentConfigImpl config) {
        this.mailProps = new Properties();
        this.mailProps.put("mail.from", config.getEmailNotificationFrom());
        this.mailProps.put("mail.host", config.getEmailNotificationHost());
        this.mailProps.put("mail.toList", config.getEmailNotificationToList());
    }

    private void initStateSaveFile(AgentConfigImpl agentConfig) {
        AgentConfigImpl impl = agentConfig;
        File propFile = impl.getPropertyFile();
        if (propFile != null) {
            if (propFile.isDirectory()) {
                this.statAlertDefnSerFile = propFile.getAbsolutePath();
            } else if (propFile.getParentFile() != null) {
                this.statAlertDefnSerFile = propFile.getParentFile().getAbsolutePath();
            }
        }
        this.statAlertDefnSerFile = this.statAlertDefnSerFile + File.separator + agentConfig.getStateSaveFile();
    }

    public ObjectName monitorGemFireHealth() throws MalformedObjectNameException {
        GemFireHealthJmxImpl health = (GemFireHealthJmxImpl)this.getGemFireHealth();
        health.ensureMBeansAreRegistered();
        return health.getObjectName();
    }

    public ObjectName createDistributionLocator(String host, int port, String workingDirectory, String productDirectory) throws MalformedObjectNameException {
        return this.createDistributionLocator(host, port, workingDirectory, productDirectory, this.getRemoteCommand());
    }

    public ObjectName createDistributionLocator(String host, int port, String workingDirectory, String productDirectory, String remoteCommand) throws MalformedObjectNameException {
        try {
            DistributionLocatorJmxImpl locator = (DistributionLocatorJmxImpl)this.addDistributionLocator();
            DistributionLocatorConfig config = locator.getConfig();
            config.setHost(host);
            config.setPort(port);
            config.setWorkingDirectory(workingDirectory);
            config.setProductDirectory(productDirectory);
            config.setRemoteCommand(remoteCommand);
            return new ObjectName(locator.getMBeanName());
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected SystemMember createSystemMember(ApplicationVM app) throws AdminException {
        return new SystemMemberJmxImpl(this, app);
    }

    @Override
    protected SystemMember createSystemMember(InternalDistributedMember member) throws AdminException {
        return new SystemMemberJmxImpl(this, member);
    }

    @Override
    protected CacheServer createCacheServer(ApplicationVM member) throws AdminException {
        return new CacheServerJmxImpl(this, (GemFireVM)member);
    }

    @Override
    protected CacheServer createCacheServer(CacheServerConfigImpl config) throws AdminException {
        return new CacheServerJmxImpl(this, (CacheVmConfig)config);
    }

    @Override
    protected GemFireHealth createGemFireHealth(GfManagerAgent system) throws AdminException {
        if (system == null) {
            throw new IllegalStateException(LocalizedStrings.AdminDistributedSystemJmxImpl_GFMANAGERAGENT_MUST_NOT_BE_NULL.toLocalizedString());
        }
        return new GemFireHealthJmxImpl(system, this);
    }

    @Override
    protected DistributionLocatorImpl createDistributionLocatorImpl(DistributionLocatorConfig config) {
        return new DistributionLocatorJmxImpl(config, this);
    }

    @Override
    public void nodeJoined(GfManagerAgent source, GemFireVM joined) {
        try {
            super.nodeJoined(source, joined);
            SystemMember member = this.findSystemMember(joined);
            if (null == member) {
                if (logger.isDebugEnabled()) {
                    logger.debug("AdminDistributedSystemJmxImpl.nodeJoined(), Could not find SystemMember for VM {}", new Object[]{joined});
                }
                return;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing node joined for: {}", new Object[]{member});
                    logger.debug("RemoteGemFireVM.nodeJoined(), setting alerts manager *************");
                }
                this.setAlertsManager(joined);
                this.modelMBean.sendNotification(new Notification(NOTIF_MEMBER_JOINED, (Object)((ManagedResource)((Object)member)).getObjectName(), (long)this.notificationSequenceNumber.addAndGet(1), joined.getId().toString()));
                if (this.isEmailNotificationEnabled) {
                    String mess = LocalizedStrings.AdminDistributedSystemJmxImpl_MEMBER_JOINED_THE_DISTRIBUTED_SYSTEM_MEMBER_ID_0.toLocalizedString(joined.getId().toString());
                    this.sendEmail("[GemFire Notification] Distributed System: " + this.getName() + " <" + LocalizedStrings.AdminDistributedSystemJmxImpl_MEMBER_JOINED.toLocalizedString() + ">", mess);
                }
            }
            catch (MBeanException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void nodeLeft(GfManagerAgent source, GemFireVM left) {
        try {
            SystemMember member = this.findSystemMember(left, false);
            super.nodeLeft(source, left);
            if (logger.isDebugEnabled()) {
                logger.debug("Processing node left for: {}", new Object[]{member});
            }
            try {
                this.modelMBean.sendNotification(new Notification(NOTIF_MEMBER_LEFT, (Object)((ManagedResource)((Object)member)).getObjectName(), (long)this.notificationSequenceNumber.addAndGet(1), left.getId().toString()));
                if (this.isEmailNotificationEnabled) {
                    String mess = LocalizedStrings.AdminDistributedSystemJmxImpl_MEMBER_LEFT_THE_DISTRIBUTED_SYSTEM_MEMBER_ID_0.toLocalizedString(left.getId().toString());
                    this.sendEmail("[GemFire Notification] Distributed System: " + this.getName() + " <" + LocalizedStrings.AdminDistributedSystemJmxImpl_MEMBER_LEFT.toLocalizedString() + ">", mess);
                }
            }
            catch (MBeanException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            SystemMemberType memberType = member.getType();
            if (memberType.isApplication() || memberType.isCacheVm()) {
                MBeanUtil.unregisterMBean((ManagedResource)((Object)member));
            }
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void nodeCrashed(GfManagerAgent source, GemFireVM crashed) {
        try {
            SystemMember member = this.findSystemMember(crashed, false);
            super.nodeCrashed(source, crashed);
            if (logger.isDebugEnabled()) {
                logger.debug("Processing node crash for: {}", new Object[]{member});
            }
            try {
                this.modelMBean.sendNotification(new Notification(NOTIF_MEMBER_CRASHED, (Object)((ManagedResource)((Object)member)).getObjectName(), (long)this.notificationSequenceNumber.addAndGet(1), crashed.getId().toString()));
                if (this.isEmailNotificationEnabled) {
                    String mess = LocalizedStrings.AdminDistributedSystemJmxImpl_MEMBER_CRASHED_IN_THE_DISTRIBUTED_SYSTEM_MEMBER_ID_0.toLocalizedString(crashed.getId().toString());
                    this.sendEmail("[GemFire Alert] Distributed System: " + this.getName() + " <" + LocalizedStrings.AdminDistributedSystemJmxImpl_MEMBER_CRASHED.toLocalizedString() + ">", mess);
                }
            }
            catch (MBeanException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            SystemMemberType memberType = member.getType();
            if (memberType.isApplication() || memberType.isCacheVm()) {
                MBeanUtil.unregisterMBean((ManagedResource)((Object)member));
            }
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void alert(Alert alert) {
        try {
            super.alert(alert);
            try {
                String strAlert = alert.toString();
                this.modelMBean.sendNotification(new Notification(NOTIF_ALERT, (Object)this.mbeanName, (long)this.notificationSequenceNumber.addAndGet(1), strAlert));
                if (this.isEmailNotificationEnabled) {
                    String mess = LocalizedStrings.AdminDistributedSystemJmxImpl_SYSTEM_ALERT_FROM_DISTRIBUTED_SYSTEM_0.toLocalizedString(strAlert);
                    this.sendEmail("[GemFire Alert] Distributed System: " + this.getName() + " <System Alert>", mess);
                }
            }
            catch (MBeanException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void onDisconnect(InternalDistributedSystem sys) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling AdminDistributedSystemJmxImpl#onDisconnect");
        }
        try {
            super.onDisconnect(sys);
            try {
                this.modelMBean.sendNotification(new Notification(NOTIF_ADMIN_SYSTEM_DISCONNECT, (Object)this.mbeanName, (long)this.notificationSequenceNumber.addAndGet(1), null));
            }
            catch (MBeanException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Completed AdminDistributedSystemJmxImpl#onDisconnect");
        }
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.DISTRIBUTED_SYSTEM;
    }

    @Override
    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void start() throws AdminException {
        try {
            super.start();
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void stop() throws AdminException {
        try {
            super.stop();
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean waitToBeConnected(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            return super.waitToBeConnected(timeout);
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String displayMergedLogs() {
        try {
            return super.displayMergedLogs();
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public ObjectName manageDistributionLocator() throws MalformedObjectNameException {
        try {
            return new ObjectName(((ManagedResource)((Object)this.addDistributionLocator())).getMBeanName());
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public ObjectName[] manageDistributionLocators() throws MalformedObjectNameException {
        try {
            DistributionLocator[] locs = this.getDistributionLocators();
            ObjectName[] onames = new ObjectName[locs.length];
            for (int i = 0; i < locs.length; ++i) {
                DistributionLocatorJmxImpl loc = (DistributionLocatorJmxImpl)locs[i];
                onames[i] = new ObjectName(loc.getMBeanName());
            }
            return onames;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public ObjectName manageCacheServer() throws AdminException, MalformedObjectNameException {
        return this.manageCacheVm();
    }

    public ObjectName manageCacheVm() throws AdminException, MalformedObjectNameException {
        try {
            return new ObjectName(((ManagedResource)((Object)this.addCacheVm())).getMBeanName());
        }
        catch (AdminException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public ObjectName[] manageCacheServers() throws AdminException, MalformedObjectNameException {
        return this.manageCacheVms();
    }

    public ObjectName[] manageCacheVms() throws AdminException, MalformedObjectNameException {
        try {
            CacheVm[] mgrs = this.getCacheVms();
            ObjectName[] onames = new ObjectName[mgrs.length];
            for (int i = 0; i < mgrs.length; ++i) {
                CacheServerJmxImpl mgr = (CacheServerJmxImpl)mgrs[i];
                onames[i] = new ObjectName(mgr.getMBeanName());
            }
            return onames;
        }
        catch (AdminException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public ObjectName[] manageSystemMemberApplications() throws AdminException, MalformedObjectNameException {
        try {
            SystemMember[] apps = this.getSystemMemberApplications();
            ObjectName[] onames = new ObjectName[apps.length];
            for (int i = 0; i < apps.length; ++i) {
                SystemMemberJmxImpl app = (SystemMemberJmxImpl)apps[i];
                onames[i] = new ObjectName(app.getMBeanName());
            }
            return onames;
        }
        catch (AdminException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public ObjectName manageSystemMember(DistributedMember distributedMember) throws AdminException, MalformedObjectNameException {
        try {
            SystemMember member = this.lookupSystemMember(distributedMember);
            if (member == null) {
                return null;
            }
            SystemMemberJmxImpl jmx = (SystemMemberJmxImpl)member;
            ObjectName oname = new ObjectName(jmx.getMBeanName());
            return oname;
        }
        catch (AdminException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void connect(InternalLogWriter logWriter) {
        try {
            super.connect(logWriter);
            this.readAlertDefinitionsAsSerializedObjects();
            if (logger.isDebugEnabled()) {
                logger.debug("Adding CacheAndRegionListener .... ");
            }
            this.addCacheListener(this.cacheRegionListener);
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void disconnect() {
        try {
            super.disconnect();
            this.saveAlertDefinitionsAsSerializedObjects();
            if (logger.isDebugEnabled()) {
                logger.debug("Removing CacheAndRegionListener .... ");
            }
            this.removeCacheListener(this.cacheRegionListener);
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void cleanupResource() {
        this.disconnect();
    }

    public boolean isRmiClientCountZero() {
        return this.isRmiClientCountZero;
    }

    void setRmiClientCountZero(boolean isRmiClientCountZero) {
        this.isRmiClientCountZero = isRmiClientCountZero;
        if (isRmiClientCountZero) {
            logger.info((Object)LocalizedStrings.AdminDistributedSystemJmxImpl_JMX_CLIENT_COUNT_HAS_DROPPED_TO_ZERO);
        }
    }

    @Override
    public String getEntityConfigXMLFile() {
        return this.getConfig().getEntityConfigXMLFile();
    }

    @Override
    public void setEntityConfigXMLFile(String xmlFile) {
        this.getConfig().setEntityConfigXMLFile(xmlFile);
    }

    @Override
    public String getSystemId() {
        return this.getConfig().getSystemId();
    }

    @Override
    public void setSystemId(String systemId) {
        this.getConfig().setSystemId(systemId);
    }

    @Override
    public String getSystemName() {
        return this.getConfig().getSystemName();
    }

    @Override
    public void setSystemName(String name) {
        this.getConfig().setSystemName(name);
    }

    @Override
    public boolean getDisableTcp() {
        return this.getConfig().getDisableTcp();
    }

    @Override
    public void setEnableNetworkPartitionDetection(boolean newValue) {
        this.getConfig().setEnableNetworkPartitionDetection(newValue);
    }

    @Override
    public boolean getEnableNetworkPartitionDetection() {
        return this.getConfig().getEnableNetworkPartitionDetection();
    }

    @Override
    public int getMemberTimeout() {
        return this.getConfig().getMemberTimeout();
    }

    @Override
    public void setMemberTimeout(int value) {
        this.getConfig().setMemberTimeout(value);
    }

    @Override
    public String getMcastAddress() {
        return this.getConfig().getMcastAddress();
    }

    @Override
    public void setMcastAddress(String mcastAddress) {
        this.getConfig().setMcastAddress(mcastAddress);
    }

    @Override
    public int getMcastPort() {
        return this.getConfig().getMcastPort();
    }

    @Override
    public void setMcastPort(int mcastPort) {
        this.getConfig().setMcastPort(mcastPort);
    }

    @Override
    public int getAckWaitThreshold() {
        return this.getConfig().getAckWaitThreshold();
    }

    @Override
    public void setAckWaitThreshold(int seconds) {
        this.getConfig().setAckWaitThreshold(seconds);
    }

    @Override
    public int getAckSevereAlertThreshold() {
        return this.getConfig().getAckSevereAlertThreshold();
    }

    @Override
    public void setAckSevereAlertThreshold(int seconds) {
        this.getConfig().setAckSevereAlertThreshold(seconds);
    }

    @Override
    public String getLocators() {
        return this.getConfig().getLocators();
    }

    @Override
    public void setLocators(String locators) {
        this.getConfig().setLocators(locators);
    }

    @Override
    public String getBindAddress() {
        return this.getConfig().getBindAddress();
    }

    @Override
    public void setBindAddress(String bindAddress) {
        this.getConfig().setBindAddress(bindAddress);
    }

    @Override
    public String getServerBindAddress() {
        return this.getConfig().getServerBindAddress();
    }

    @Override
    public void setServerBindAddress(String bindAddress) {
        this.getConfig().setServerBindAddress(bindAddress);
    }

    @Override
    public String getRemoteCommand() {
        return this.getConfig().getRemoteCommand();
    }

    @Override
    public void setRemoteCommand(String command) {
        this.getConfig().setRemoteCommand(command);
    }

    @Override
    public boolean isSSLEnabled() {
        return this.getConfig().isSSLEnabled();
    }

    @Override
    public void setSSLEnabled(boolean enabled) {
        this.getConfig().setSSLEnabled(enabled);
    }

    @Override
    public String getSSLProtocols() {
        return this.getConfig().getSSLProtocols();
    }

    @Override
    public void setSSLProtocols(String protocols) {
        this.getConfig().setSSLProtocols(protocols);
    }

    @Override
    public String getSSLCiphers() {
        return this.getConfig().getSSLCiphers();
    }

    @Override
    public void setSSLCiphers(String ciphers) {
        this.getConfig().setSSLCiphers(ciphers);
    }

    @Override
    public boolean isSSLAuthenticationRequired() {
        return this.getConfig().isSSLAuthenticationRequired();
    }

    @Override
    public void setSSLAuthenticationRequired(boolean authRequired) {
        this.getConfig().setSSLAuthenticationRequired(authRequired);
    }

    @Override
    public Properties getSSLProperties() {
        return this.getConfig().getSSLProperties();
    }

    @Override
    public void setSSLProperties(Properties sslProperties) {
        this.getConfig().setSSLProperties(sslProperties);
    }

    @Override
    public void addSSLProperty(String key, String value) {
        this.getConfig().addSSLProperty(key, value);
    }

    @Override
    public void removeSSLProperty(String key) {
        this.getConfig().removeSSLProperty(key);
    }

    @Override
    public String getLogFile() {
        return this.getConfig().getLogFile();
    }

    @Override
    public void setLogFile(String logFile) {
        this.getConfig().setLogFile(logFile);
    }

    @Override
    public String getLogLevel() {
        return this.getConfig().getLogLevel();
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.getConfig().setLogLevel(logLevel);
    }

    @Override
    public int getLogDiskSpaceLimit() {
        return this.getConfig().getLogDiskSpaceLimit();
    }

    @Override
    public void setLogDiskSpaceLimit(int limit) {
        this.getConfig().setLogDiskSpaceLimit(limit);
    }

    @Override
    public int getLogFileSizeLimit() {
        return this.getConfig().getLogFileSizeLimit();
    }

    @Override
    public void setLogFileSizeLimit(int limit) {
        this.getConfig().setLogFileSizeLimit(limit);
    }

    @Override
    public void setDisableTcp(boolean flag) {
        this.getConfig().setDisableTcp(flag);
    }

    @Override
    public int getRefreshInterval() {
        return this.getConfig().getRefreshInterval();
    }

    @Override
    public void setRefreshInterval(int interval) {
        this.getConfig().setRefreshInterval(interval);
    }

    @Override
    public CacheServerConfig[] getCacheServerConfigs() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheServerConfig createCacheServerConfig() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeCacheServerConfig(CacheServerConfig config) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheVmConfig[] getCacheVmConfigs() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheVmConfig createCacheVmConfig() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeCacheVmConfig(CacheVmConfig config) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DistributionLocatorConfig[] getDistributionLocatorConfigs() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DistributionLocatorConfig createDistributionLocatorConfig() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeDistributionLocatorConfig(DistributionLocatorConfig config) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addListener(DistributedSystemConfig.ConfigListener listener) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeListener(DistributedSystemConfig.ConfigListener listener) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void validate() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public TabularData getMissingPersistentMembersJMX() throws AdminException {
        try {
            Set<PersistentID> members = super.getMissingPersistentMembers();
            TabularDataSupport results = new TabularDataSupport(this.PERSISTENT_ID_TABLE_TYPE);
            int index = 0;
            for (PersistentID id : members) {
                CompositeDataSupport idData = new CompositeDataSupport(this.PERSISTENT_ID_TYPE, PERSISTENT_ID_FIELDS, new Object[]{id.getHost().toString(), id.getDirectory(), id.getUUID().toString()});
                results.put(idData);
                ++index;
            }
            return results;
        }
        catch (OpenDataException e) {
            logger.warn("Exception occurred while getting missing persistent members.", (Throwable)e);
            throw new AdminException(e);
        }
    }

    public void revokePersistentMember(String host, String directory) throws AdminException, UnknownHostException {
        super.revokePersistentMember(InetAddress.getByName(host), directory);
    }

    public void revokePersistentMember(String uuid) throws AdminException, UnknownHostException {
        super.revokePersistentMember(UUID.fromString(uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatAlertDefinition getAlertDefinition(int alertDefinitionId) {
        Map map = this.ALERT_DEFINITIONS;
        synchronized (map) {
            return (StatAlertDefinition)this.ALERT_DEFINITIONS.get(alertDefinitionId);
        }
    }

    @Override
    public StatAlertDefinition getAlertDefinition(StatAlertDefinition alertDefinition) {
        return this.getAlertDefinition(alertDefinition.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAlertDefinitionsAsSerializedObjects() {
        StatAlertDefinition[] defns = new StatAlertDefinition[]{};
        File serFile = null;
        FileInputStream foStr = null;
        FilterInputStream ooStr = null;
        try {
            serFile = new File(this.statAlertDefnSerFile);
            if (!this.canWriteToFile(serFile)) {
                this.canPersistStatAlertDefs = false;
            }
            if (!serFile.exists()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("AdminDistributedSystemJmxImpl.readAlertDefinitionsAsSerializedObjects: File: {}", new Object[]{serFile.getPath()});
            }
            foStr = new FileInputStream(serFile);
            ooStr = new DataInputStream(foStr);
            defns = (StatAlertDefinition[])DataSerializer.readObjectArray((DataInput)((Object)ooStr));
        }
        catch (ClassNotFoundException cnfEx) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystem_ENCOUNTERED_A_0_WHILE_LOADING_STATALERTDEFINITIONS_1, new Object[]{cnfEx.getClass().getName(), this.statAlertDefnSerFile}), (Throwable)cnfEx);
            this.canPersistStatAlertDefs = false;
        }
        catch (IOException ex) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystem_ENCOUNTERED_A_0_WHILE_LOADING_STATALERTDEFINITIONS_1_LOADING_ABORTED, new Object[]{ex.getClass().getName(), this.statAlertDefnSerFile}), (Throwable)ex);
            this.canPersistStatAlertDefs = false;
        }
        finally {
            if (foStr != null) {
                try {
                    foStr.close();
                }
                catch (IOException cnfEx) {}
            }
            if (ooStr != null) {
                try {
                    ooStr.close();
                }
                catch (IOException cnfEx) {}
            }
        }
        for (int i = 0; i < defns.length; ++i) {
            this.updateAlertDefinition(defns[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAlertDefinitionsAsSerializedObjects() {
        File serFile = null;
        FileOutputStream foStr = null;
        FilterOutputStream ooStr = null;
        try {
            serFile = new File(this.statAlertDefnSerFile);
            if (logger.isDebugEnabled()) {
                logger.debug("AdminDistributedSystemJmxImpl.saveAlertDefinitionsAsSerializedObjects: File: {}", new Object[]{serFile.getPath()});
            }
            if (!this.canWriteToFile(serFile)) {
                return;
            }
            foStr = new FileOutputStream(serFile);
            ooStr = new DataOutputStream(foStr);
            int numOfAlerts = 0;
            Object[] defs = null;
            Map map = this.ALERT_DEFINITIONS;
            synchronized (map) {
                numOfAlerts = this.ALERT_DEFINITIONS.size();
                defs = new StatAlertDefinition[numOfAlerts];
                int i = 0;
                for (Integer key : this.ALERT_DEFINITIONS.keySet()) {
                    StatAlertDefinition readDefn = (StatAlertDefinition)this.ALERT_DEFINITIONS.get(key);
                    defs[i] = readDefn;
                    ++i;
                }
            }
            DataSerializer.writeObjectArray(defs, (DataOutput)((Object)ooStr));
        }
        catch (IOException ex) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystem_ENCOUNTERED_A_0_WHILE_SAVING_STATALERTDEFINITIONS_1, new Object[]{ex.getClass().getName(), this.statAlertDefnSerFile}), (Throwable)ex);
        }
        finally {
            if (foStr != null) {
                try {
                    foStr.close();
                }
                catch (IOException iOException) {}
            }
            if (ooStr != null) {
                try {
                    ooStr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canWriteToFile(File file) {
        boolean fileIsWritable = true;
        if (file.exists()) {
            if (file.canWrite()) return fileIsWritable;
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystemJmxImpl_READONLY_STAT_ALERT_DEF_FILE_0, new Object[]{file}));
            return false;
        }
        try {
            file.createNewFile();
            if (!file.exists()) return fileIsWritable;
            if (file.delete()) return fileIsWritable;
        }
        catch (IOException e) {
            try {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystemJmxImpl_FAILED_TO_CREATE_STAT_ALERT_DEF_FILE_0, new Object[]{file}), (Throwable)e);
                fileIsWritable = false;
                if (!file.exists()) return fileIsWritable;
                if (file.delete()) return fileIsWritable;
            }
            catch (Throwable throwable) {
                if (!file.exists()) throw throwable;
                if (file.delete()) throw throwable;
                if (!logger.isDebugEnabled()) throw throwable;
                logger.debug("Could not delete file :'{}' which is created for checking permissions.", new Object[]{file.getAbsolutePath()});
                throw throwable;
            }
            if (!logger.isDebugEnabled()) return fileIsWritable;
            logger.debug("Could not delete file :'{}' which is created for checking permissions.", new Object[]{file.getAbsolutePath()});
            return fileIsWritable;
        }
        if (!logger.isDebugEnabled()) return fileIsWritable;
        logger.debug("Could not delete file :'{}' which is created for checking permissions.", new Object[]{file.getAbsolutePath()});
        return fileIsWritable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAlertDefinition(StatAlertDefinition alertDefinition) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered AdminDistributedSystemJmxImpl.updateAlertDefinition(StatAlertDefinition) *****");
        }
        Map map = this.ALERT_DEFINITIONS;
        synchronized (map) {
            this.ALERT_DEFINITIONS.put(alertDefinition.getId(), alertDefinition);
            if (logger.isDebugEnabled()) {
                logger.debug("AdminDistributedSystemJmxImpl.updateAlertDefinition : alertDefinition :: id={} :: {}", new Object[]{alertDefinition.getId(), alertDefinition.getStringRepresentation()});
            }
            this.notifyMembersForAlertDefinitionChange(alertDefinition);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting AdminDistributedSystemJmxImpl.updateAlertDefinition(StatAlertDefinition) *****");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlertDefinition(Integer defId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered AdminDistributedSystemJmxImpl.removeAlertDefinition id *****");
        }
        Map map = this.ALERT_DEFINITIONS;
        synchronized (map) {
            StatAlertDefinition alertDefinition = (StatAlertDefinition)this.ALERT_DEFINITIONS.get(defId);
            if (alertDefinition != null) {
                this.ALERT_DEFINITIONS.remove(defId);
                HashMap hashMap = this.alertsStore;
                synchronized (hashMap) {
                    this.alertsStore.remove(defId);
                }
                this.notifyMembersForAlertDefinitionRemoval(alertDefinition);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting AdminDistributedSystemJmxImpl.removeAlertDefinition() *****");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlertDefinitionCreated(StatAlertDefinition alertDefinition) {
        Map map = this.ALERT_DEFINITIONS;
        synchronized (map) {
            return this.ALERT_DEFINITIONS.containsKey(alertDefinition.getId());
        }
    }

    @Override
    public synchronized int getRefreshIntervalForStatAlerts() {
        return this.refreshIntervalForStatAlerts;
    }

    @Override
    public synchronized void setRefreshIntervalForStatAlerts(int refreshIntervalForStatAlerts) {
        this.refreshIntervalForStatAlerts = refreshIntervalForStatAlerts;
        this.notifyMembersForRefreshIntervalChange((long)this.refreshIntervalForStatAlerts * 1000L);
    }

    public boolean canPersistStatAlertDefs() {
        return this.canPersistStatAlertDefs;
    }

    private void notifyMembersForRefreshIntervalChange(long newInterval) {
        GfManagerAgent agent = this.getGfManagerAgent();
        ApplicationVM[] VMs = agent.listApplications();
        for (int i = 0; i < VMs.length; ++i) {
            VMs[i].setRefreshInterval(newInterval);
        }
    }

    private void notifyMembersForAlertDefinitionChange(StatAlertDefinition alertDef) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered AdminDistributedSystemJmxImpl.notifyMembersForAlertDefinitionChange(StatAlertDefinition) *****");
        }
        GfManagerAgent agent = this.getGfManagerAgent();
        StatAlertDefinition[] alertDefs = new StatAlertDefinition[]{alertDef};
        ApplicationVM[] VMs = agent.listApplications();
        for (int i = 0; i < VMs.length; ++i) {
            VMs[i].updateAlertDefinitions(alertDefs, 2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting AdminDistributedSystemJmxImpl.notifyMembersForAlertDefinitionChange(StatAlertDefinition) " + VMs.length + " members notified.*****");
        }
    }

    private void notifyMembersForAlertDefinitionRemoval(StatAlertDefinition alertDef) {
        GfManagerAgent agent = this.getGfManagerAgent();
        StatAlertDefinition[] alertDefs = new StatAlertDefinition[]{alertDef};
        ApplicationVM[] VMs = agent.listApplications();
        for (int i = 0; i < VMs.length; ++i) {
            VMs[i].updateAlertDefinitions(alertDefs, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAlertsManager(GemFireVM memberVM) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered AdminDistributedSystemJmxImpl.setAlertsManager(GemFireVM) *****");
        }
        StatAlertDefinition[] alertDefs = new StatAlertDefinition[]{};
        Collection alertDefsCollection = null;
        Map map = this.ALERT_DEFINITIONS;
        synchronized (map) {
            alertDefsCollection = this.ALERT_DEFINITIONS.values();
        }
        alertDefs = alertDefsCollection.toArray(alertDefs);
        memberVM.setAlertsManager(alertDefs, (long)this.getRefreshIntervalForStatAlerts() * 1000L, true);
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting AdminDistributedSystemJmxImpl.setAlertsManager(GemFireVM) *****");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatAlertDefinition[] getAllStatAlertDefinitions() {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered AdminDistributedSystemJmxImpl.getAllStatAlertDefinitions() *****");
        }
        Collection alertDefs = null;
        Map map = this.ALERT_DEFINITIONS;
        synchronized (map) {
            alertDefs = this.ALERT_DEFINITIONS.values();
        }
        StatAlertDefinition[] alertDefsArr = null;
        if (alertDefs != null) {
            alertDefsArr = new StatAlertDefinition[alertDefs.size()];
            alertDefsArr = alertDefs.toArray(alertDefsArr);
        } else {
            alertDefsArr = new StatAlertDefinition[]{};
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting AdminDistributedSystemJmxImpl.getAllStatAlertDefinitions() *****");
        }
        return alertDefsArr;
    }

    @Override
    public void processNotifications(StatAlert[] alerts, GemFireVM remoteVM) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered AdminDistributedSystemJmxImpl.processNotifications(StatAlert[{}], GemFireVM) *************", new Object[]{alerts.length});
        }
        if (remoteVM == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not process stat alert notifications as given GemFireVM is null.");
            }
            return;
        }
        ArrayList<StatAlertNotification> notificationObjects = new ArrayList<StatAlertNotification>();
        String memberId = remoteVM.getId().getId();
        boolean isSystemWide = false;
        StatAlert alert = null;
        Object defId = null;
        for (int i = 0; i < alerts.length; ++i) {
            alert = alerts[i];
            if (this.getAlertDefinition(alert.getDefinitionId()) == null) continue;
            StatAlertNotification alertNotification = new StatAlertNotification(alert, memberId);
            notificationObjects.add(alertNotification);
        }
        if (!notificationObjects.isEmpty()) {
            this.sendNotifications(notificationObjects, this.getObjectName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting AdminDistributedSystemJmxImpl.processNotifications(StatAlert[], GemFireVM) *************");
        }
    }

    private byte[] convertNotificationsDataToByteArray(ArrayList notificationObjects) {
        if (logger.isDebugEnabled()) {
            logger.debug("AdminDistributedSystemJmxImpl#convertNotificationsDataToByteArray: {} notifications", new Object[]{notificationObjects.size()});
        }
        byte[] arr = null;
        try {
            ByteArrayOutputStream byteArrStr = new ByteArrayOutputStream();
            DataOutputStream str = new DataOutputStream(byteArrStr);
            DataSerializer.writeArrayList(notificationObjects, str);
            str.flush();
            arr = byteArrStr.toByteArray();
        }
        catch (IOException ex) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystem_ENCOUNTERED_AN_IOEXCEPTION_0, ex.getLocalizedMessage()));
        }
        return arr;
    }

    private void sendNotifications(ArrayList notificationObjects, ObjectName objName) {
        try {
            byte[] notifBytes;
            if (logger.isDebugEnabled()) {
                logger.debug("AdminDistributedSystemJmxImpl#sendNotifications: sending {} notifications", new Object[]{notificationObjects.size()});
            }
            if ((notifBytes = this.convertNotificationsDataToByteArray(notificationObjects)) != null) {
                Notification notif = new Notification(NOTIF_STAT_ALERT, (Object)objName, (long)this.notificationSequenceNumber.addAndGet(1), "StatAlert Notifications");
                notif.setUserData(notifBytes);
                this.modelMBean.sendNotification(notif);
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < notificationObjects.size(); ++i) {
                StatAlertNotification not = (StatAlertNotification)notificationObjects.get(i);
                buf.append(not.toString(this.getAlertDefinition(not.getDefinitionId())));
            }
            if (this.isEmailNotificationEnabled) {
                String mess = LocalizedStrings.AdminDistributedSystemJmxImpl_STATISTICS_ALERT_FROM_DISTRIBUTED_SYSTEM_MEMBER_0_STATISTICS_1.toLocalizedString(objName.getCanonicalName(), buf.toString());
                this.sendEmail("[GemFire Alert] Distributed System: " + this.getName() + " <" + LocalizedStrings.AdminDistributedSystemJmxImpl_STATISTICS_ALERT_FOR_MEMBER.toLocalizedString() + ">", mess);
            }
        }
        catch (MBeanException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void sendEmail(String subject, String message) {
        if (this.mailManager == null) {
            this.mailManager = new MailManager(this.mailProps);
        }
        this.mailManager.sendEmail(subject, message);
    }

    @Override
    public void processSystemwideNotifications() {
    }

    @Override
    public String getId() {
        String myId = super.getId();
        return MBeanUtil.makeCompliantMBeanNameProperty(myId);
    }

    @Override
    public void processClientMembership(String senderId, String clientId, String clientHost, int eventType) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystemJmxImpl_PROCESSING_CLIENT_MEMBERSHIP_EVENT_0_FROM_1_FOR_2_RUNNING_ON_3, new String[]{ClientMembershipMessage.getEventTypeString(eventType), senderId, clientId, clientHost}));
        try {
            CacheVm[] cacheVms;
            SystemMemberJmx systemMemberJmx = null;
            for (CacheVm cacheVm : cacheVms = this.getCacheVms()) {
                if (!cacheVm.getId().equals(senderId) || !(cacheVm instanceof CacheServerJmxImpl)) continue;
                systemMemberJmx = (CacheServerJmxImpl)cacheVm;
                break;
            }
            if (systemMemberJmx == null) {
                SystemMember[] appVms;
                for (SystemMember appVm : appVms = this.getSystemMemberApplications()) {
                    if (!appVm.getId().equals(senderId) || !(appVm instanceof SystemMemberJmxImpl)) continue;
                    systemMemberJmx = (SystemMemberJmxImpl)appVm;
                    break;
                }
            }
            if (systemMemberJmx != null) {
                systemMemberJmx.handleClientMembership(clientId, eventType);
            }
        }
        catch (AdminException e) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.AdminDistributedSystemJmxImpl_FAILED_TO_PROCESS_CLIENT_MEMBERSHIP_FROM_0_FOR_1, new Object[]{senderId, clientId}), (Throwable)e);
            return;
        }
        catch (RuntimeOperationsException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getAlertLevelAsString() {
        return super.getAlertLevelAsString();
    }

    @Override
    public void setAlertLevelAsString(String level) {
        String newLevel = level != null ? level.trim() : null;
        try {
            super.setAlertLevelAsString(newLevel);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeMBeanException(e, e.getMessage());
        }
    }

    public void handleCacheCreateEvent(SystemMemberCacheEvent event) {
        String memberId = event.getMemberId();
        SystemMemberJmx systemMemberJmx = (SystemMemberJmx)this.findCacheOrAppVmById(memberId);
        if (systemMemberJmx != null) {
            systemMemberJmx.handleCacheCreate(event);
        }
    }

    public void handleCacheCloseEvent(SystemMemberCacheEvent event) {
        String memberId = event.getMemberId();
        SystemMemberJmx systemMemberJmx = (SystemMemberJmx)this.findCacheOrAppVmById(memberId);
        if (systemMemberJmx != null) {
            systemMemberJmx.handleCacheClose(event);
        }
    }

    public void handleRegionCreateEvent(SystemMemberRegionEvent event) {
        String memberId = event.getMemberId();
        SystemMemberJmx systemMemberJmx = (SystemMemberJmx)this.findCacheOrAppVmById(memberId);
        if (systemMemberJmx != null) {
            systemMemberJmx.handleRegionCreate(event);
        }
    }

    public void handleRegionLossEvent(SystemMemberRegionEvent event) {
        String memberId = event.getMemberId();
        SystemMemberJmx systemMemberJmx = (SystemMemberJmx)this.findCacheOrAppVmById(memberId);
        if (systemMemberJmx != null) {
            systemMemberJmx.handleRegionLoss(event);
        }
    }

    @Override
    public void setDisableAutoReconnect(boolean newValue) {
        this.getConfig().setDisableAutoReconnect(newValue);
    }

    @Override
    public boolean getDisableAutoReconnect() {
        return this.getConfig().getDisableAutoReconnect();
    }
}

