/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.MemberHealthConfig;
import com.gemstone.gemfire.admin.internal.AbstractHealthEvaluator;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.ProcessStats;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.List;

class MemberHealthEvaluator
extends AbstractHealthEvaluator {
    private MemberHealthConfig config;
    private String description;
    private ProcessStats processStats;
    private DMStats dmStats;
    private long prevReplyTimeouts;

    MemberHealthEvaluator(GemFireHealthConfig config, DM dm) {
        super(config, dm);
        this.config = config;
        InternalDistributedSystem system = dm.getSystem();
        GemFireStatSampler sampler = system.getStatSampler();
        if (sampler != null) {
            this.processStats = sampler.getProcessStats();
        }
        this.dmStats = dm.getStats();
        StringBuffer sb = new StringBuffer();
        sb.append("Application VM member ");
        sb.append(dm.getId());
        int pid = OSProcess.getId();
        if (pid != 0) {
            sb.append(" with pid ");
            sb.append(pid);
        }
        this.description = sb.toString();
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    void checkVMProcessSize(List status) {
        long threshold;
        if (this.processStats == null) {
            return;
        }
        long vmSize = this.processStats.getProcessSize();
        if (vmSize > (threshold = this.config.getMaxVMProcessSize())) {
            String s = LocalizedStrings.MemberHealthEvaluator_THE_SIZE_OF_THIS_VM_0_MEGABYTES_EXCEEDS_THE_THRESHOLD_1_MEGABYTES.toLocalizedString(vmSize, threshold);
            status.add(this.okayHealth(s));
        }
    }

    void checkMessageQueueSize(List status) {
        long threshold = this.config.getMaxMessageQueueSize();
        long overflowSize = this.dmStats.getOverflowQueueSize();
        if (overflowSize > threshold) {
            String s = LocalizedStrings.MemberHealthEvaluator_THE_SIZE_OF_THE_OVERFLOW_QUEUE_0_EXCEEDS_THE_THRESHOLD_1.toLocalizedString(overflowSize, threshold);
            status.add(this.okayHealth(s));
        }
    }

    void checkReplyTimeouts(List status) {
        if (this.isFirstEvaluation()) {
            return;
        }
        long threshold = this.config.getMaxReplyTimeouts();
        long deltaReplyTimeouts = this.dmStats.getReplyTimeouts() - this.prevReplyTimeouts;
        if (deltaReplyTimeouts > threshold) {
            String s = LocalizedStrings.MemberHealthEvaluator_THE_NUMBER_OF_MESSAGE_REPLY_TIMEOUTS_0_EXCEEDS_THE_THRESHOLD_1.toLocalizedString(deltaReplyTimeouts, threshold);
            status.add(this.okayHealth(s));
        }
    }

    void checkRetransmissionRatio(List status) {
        double ratio;
        double threshold = this.config.getMaxRetransmissionRatio();
        int mcastMessages = this.dmStats.getMcastWrites();
        if (mcastMessages > 100000 && (ratio = (double)this.dmStats.getMcastRetransmits() * 1.0 / ((double)this.dmStats.getMcastWrites() * 1.0)) > threshold) {
            String s = "The number of message retransmissions (" + ratio + ") exceeds the threshold (" + threshold + ")";
            status.add(this.okayHealth(s));
        }
    }

    void checkCacheRequiredRolesMeet(List status) {
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            CachePerfStats cPStats = null;
            cPStats = cache.getCachePerfStats();
            if (cPStats.getReliableRegionsMissingFullAccess() > 0) {
                int numRegions = cPStats.getReliableRegionsMissingFullAccess();
                status.add(this.okayHealth(LocalizedStrings.MemberHealthEvaluator_THERE_ARE_0_REGIONS_MISSING_REQUIRED_ROLES_BUT_ARE_CONFIGURED_FOR_FULL_ACCESS.toLocalizedString(numRegions)));
            } else if (cPStats.getReliableRegionsMissingLimitedAccess() > 0) {
                int numRegions = cPStats.getReliableRegionsMissingLimitedAccess();
                status.add(this.poorHealth(LocalizedStrings.MemberHealthEvaluator_THERE_ARE_0_REGIONS_MISSING_REQUIRED_ROLES_AND_CONFIGURED_WITH_LIMITED_ACCESS.toLocalizedString(numRegions)));
            } else if (cPStats.getReliableRegionsMissingNoAccess() > 0) {
                int numRegions = cPStats.getReliableRegionsMissingNoAccess();
                status.add(this.poorHealth(LocalizedStrings.MemberHealthEvaluator_THERE_ARE_0_REGIONS_MISSING_REQUIRED_ROLES_AND_CONFIGURED_WITHOUT_ACCESS.toLocalizedString(numRegions)));
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void updatePrevious() {
        this.prevReplyTimeouts = this.dmStats.getReplyTimeouts();
    }

    @Override
    protected void check(List status) {
        this.checkVMProcessSize(status);
        this.checkMessageQueueSize(status);
        this.checkReplyTimeouts(status);
        this.checkCacheRequiredRolesMeet(status);
        this.updatePrevious();
    }

    @Override
    void close() {
    }
}

