/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.internal.DisabledManagedEntityController;
import com.gemstone.gemfire.admin.internal.EnabledManagedEntityController;
import com.gemstone.gemfire.admin.internal.ManagedEntityController;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class ManagedEntityControllerFactory {
    private static final Logger logger = LogService.getLogger();
    private static final String ENABLED_MANAGED_ENTITY_CONTROLLER_CLASS_NAME = "com.gemstone.gemfire.admin.internal.EnabledManagedEntityController";

    static ManagedEntityController createManagedEntityController(AdminDistributedSystem system) {
        if (ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            logger.info(LogMarker.CONFIG, "Local and remote OS command invocations are enabled for the Admin API.");
            return ManagedEntityControllerFactory.createEnabledManagedEntityController(system);
        }
        logger.info(LogMarker.CONFIG, "Local and remote OS command invocations are disabled for the Admin API.");
        return new DisabledManagedEntityController();
    }

    public static boolean isEnabledManagedEntityController() {
        try {
            ClassPathLoader.getLatest().forName(ENABLED_MANAGED_ENTITY_CONTROLLER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ManagedEntityController createEnabledManagedEntityController(AdminDistributedSystem system) {
        return new EnabledManagedEntityController(system);
    }
}

