/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.internal.DistributedSystemHealthConfigImpl;
import com.gemstone.gemfire.admin.internal.DistributedSystemHealthEvaluator;
import com.gemstone.gemfire.admin.internal.DistributedSystemHealthMonitor;
import com.gemstone.gemfire.admin.internal.GemFireHealthConfigImpl;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.ApplicationVM;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.HealthListener;
import com.gemstone.gemfire.internal.admin.JoinLeaveListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GemFireHealthImpl
implements GemFireHealth,
JoinLeaveListener,
HealthListener {
    private final GfManagerAgent agent;
    protected GemFireHealthConfig defaultConfig;
    private final Map hostConfigs;
    private final Map hostMembers;
    private Collection okayHealth;
    private Collection poorHealth;
    private GemFireHealth.Health overallHealth;
    private boolean isClosed;
    protected volatile DistributedSystemHealthConfig dsHealthConfig;
    private DistributedSystemHealthMonitor dsHealthMonitor = null;
    private final AdminDistributedSystem system;

    protected GemFireHealthImpl(GfManagerAgent agent, AdminDistributedSystem system) {
        this.agent = agent;
        this.system = system;
        this.hostConfigs = new HashMap();
        this.hostMembers = new HashMap();
        this.okayHealth = new HashSet();
        this.poorHealth = new HashSet();
        this.overallHealth = GOOD_HEALTH;
        this.isClosed = false;
        ApplicationVM[] apps = this.agent.listApplications();
        for (int i = 0; i < apps.length; ++i) {
            ApplicationVM member = apps[i];
            this.noteNewMember(member);
        }
        agent.addJoinLeaveListener(this);
        this.setDefaultGemFireHealthConfig(this.createGemFireHealthConfig(null));
        this.setDistributedSystemHealthConfig(this.createDistributedSystemHealthConfig());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("closed=" + this.isClosed);
        sb.append("; hostMembers=" + this.hostMembers);
        sb.append("; okayHealth=" + this.okayHealth);
        sb.append("; poorHealth=" + this.poorHealth);
        sb.append("; overallHealth=" + this.overallHealth);
        sb.append("; diagnosis=" + this.getDiagnosis());
        return sb.toString();
    }

    public AdminDistributedSystem getDistributedSystem() {
        return this.system;
    }

    protected DistributedSystemHealthConfig createDistributedSystemHealthConfig() {
        return new DistributedSystemHealthConfigImpl();
    }

    protected GemFireHealthConfig createGemFireHealthConfig(String hostName) {
        return new GemFireHealthConfigImpl(hostName);
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException(LocalizedStrings.GemFireHealthImpl_CANNOT_ACCESS_A_CLOSED_GEMFIREHEALTH_INSTANCE.toLocalizedString());
        }
    }

    @Override
    public GemFireHealth.Health getHealth() {
        this.checkClosed();
        return this.overallHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHealth() {
        this.checkClosed();
        this.overallHealth = GOOD_HEALTH;
        this.okayHealth.clear();
        this.poorHealth.clear();
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            for (List members : this.hostMembers.values()) {
                for (GemFireVM member : members) {
                    member.resetHealthStatus();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnosis() {
        this.checkClosed();
        StringBuffer sb = new StringBuffer();
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            for (List members : this.hostMembers.values()) {
                for (GemFireVM member : members) {
                    String[] diagnoses = member.getHealthDiagnosis(this.overallHealth);
                    for (int i = 0; i < diagnoses.length; ++i) {
                        sb.append(diagnoses[i]).append("\n");
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDistributedSystemHealthConfig(DistributedSystemHealthConfig config) {
        Map map = this.hostConfigs;
        synchronized (map) {
            if (this.dsHealthMonitor != null) {
                this.dsHealthMonitor.stop();
            }
            this.dsHealthConfig = config;
            DistributedSystemHealthEvaluator eval = new DistributedSystemHealthEvaluator(config, this.agent.getDM());
            int interval = this.getDefaultGemFireHealthConfig().getHealthEvaluationInterval();
            this.dsHealthMonitor = new DistributedSystemHealthMonitor(eval, this, interval);
            this.dsHealthMonitor.start();
        }
    }

    @Override
    public DistributedSystemHealthConfig getDistributedSystemHealthConfig() {
        this.checkClosed();
        return this.dsHealthConfig;
    }

    @Override
    public GemFireHealthConfig getDefaultGemFireHealthConfig() {
        this.checkClosed();
        return this.defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultGemFireHealthConfig(GemFireHealthConfig config) {
        this.checkClosed();
        if (config.getHostName() != null) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireHealthImpl_THE_GEMFIREHEALTHCONFIG_FOR_FOR_0_CANNOT_SERVE_AS_THE_DEFAULT_HEALTH_CONFIG.toLocalizedString(config.getHostName()));
        }
        this.defaultConfig = config;
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            for (Map.Entry entry : this.hostMembers.entrySet()) {
                InetAddress hostIpAddress = (InetAddress)entry.getKey();
                List members = (List)entry.getValue();
                GemFireHealthConfig hostConfig = (GemFireHealthConfig)this.hostConfigs.get(hostIpAddress);
                if (hostConfig == null) {
                    hostConfig = config;
                }
                for (GemFireVM member : members) {
                    Assert.assertTrue(member.getHost().equals(hostIpAddress));
                    member.addHealthListener(this, hostConfig);
                }
            }
        }
        if (this.dsHealthConfig != null) {
            this.setDistributedSystemHealthConfig(this.dsHealthConfig);
        }
    }

    @Override
    public synchronized GemFireHealthConfig getGemFireHealthConfig(String hostName) {
        this.checkClosed();
        InetAddress hostIpAddress = null;
        try {
            hostIpAddress = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireHealthImpl_COULD_NOT_FIND_A_HOST_WITH_NAME_0.toLocalizedString(hostName), e);
        }
        GemFireHealthConfig config = (GemFireHealthConfig)this.hostConfigs.get(hostIpAddress);
        if (config == null) {
            config = this.createGemFireHealthConfig(hostName);
            this.hostConfigs.put(hostIpAddress, config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGemFireHealthConfig(String hostName, GemFireHealthConfig config) {
        this.checkClosed();
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            String configHost = config.getHostName();
            if (configHost == null || !configHost.equals(hostName)) {
                StringBuffer sb = new StringBuffer();
                sb.append("The GemFireHealthConfig configures ");
                if (configHost == null) {
                    sb.append("the default host ");
                } else {
                    sb.append("host \"");
                    sb.append(config.getHostName());
                    sb.append("\" ");
                }
                sb.append("not \"" + hostName + "\"");
                throw new IllegalArgumentException(sb.toString());
            }
            InetAddress hostIpAddress = null;
            try {
                hostIpAddress = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(LocalizedStrings.GemFireHealthImpl_COULD_NOT_FIND_A_HOST_WITH_NAME_0.toLocalizedString(hostName), e);
            }
            List members = (List)this.hostMembers.get(hostIpAddress);
            if (members == null || members.isEmpty()) {
                throw new IllegalArgumentException(LocalizedStrings.GemFireHealthImpl_THERE_ARE_NO_GEMFIRE_COMPONENTS_ON_HOST_0.toLocalizedString(hostName));
            }
            for (GemFireVM member : members) {
                member.addHealthListener(this, config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.agent.removeJoinLeaveListener(this);
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.dsHealthMonitor != null) {
                this.dsHealthMonitor.stop();
                this.dsHealthMonitor = null;
            }
            try {
                for (List members : this.hostMembers.values()) {
                    for (GemFireVM member : members) {
                        member.removeHealthListener();
                    }
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            this.hostConfigs.clear();
            this.hostMembers.clear();
            this.okayHealth.clear();
            this.poorHealth.clear();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void noteNewMember(GemFireVM member) {
        InetAddress hostIpAddress = member.getHost();
        ArrayList<GemFireVM> members = (ArrayList<GemFireVM>)this.hostMembers.get(hostIpAddress);
        if (members == null) {
            members = new ArrayList<GemFireVM>();
            this.hostMembers.put(hostIpAddress, members);
        }
        members.add(member);
    }

    @Override
    public synchronized void nodeJoined(GfManagerAgent source, GemFireVM joined) {
        this.noteNewMember(joined);
        InetAddress hostIpAddress = joined.getHost();
        GemFireHealthConfig config = (GemFireHealthConfig)this.hostConfigs.get(hostIpAddress);
        if (config == null) {
            config = this.getDefaultGemFireHealthConfig();
        }
        joined.addHealthListener(this, config);
    }

    @Override
    public synchronized void nodeLeft(GfManagerAgent source, GemFireVM left) {
        InetAddress hostIpAddress = left.getHost();
        List members = (List)this.hostMembers.get(hostIpAddress);
        if (members != null) {
            members.remove(left);
            if (members.isEmpty()) {
                this.hostConfigs.remove(hostIpAddress);
                this.hostMembers.remove(hostIpAddress);
            }
        }
        this.okayHealth.remove(left);
        this.poorHealth.remove(left);
        this.reevaluateHealth();
    }

    @Override
    public void nodeCrashed(GfManagerAgent source, GemFireVM crashed) {
        this.nodeLeft(source, crashed);
    }

    private void reevaluateHealth() {
        this.overallHealth = !this.poorHealth.isEmpty() ? POOR_HEALTH : (!this.okayHealth.isEmpty() ? OKAY_HEALTH : GOOD_HEALTH);
    }

    @Override
    public void healthChanged(GemFireVM member, GemFireHealth.Health status) {
        if (status == GOOD_HEALTH) {
            this.okayHealth.remove(member);
            this.poorHealth.remove(member);
        } else if (status == OKAY_HEALTH) {
            this.okayHealth.add(member);
            this.poorHealth.remove(member);
        } else if (status == POOR_HEALTH) {
            this.okayHealth.remove(member);
            this.poorHealth.add(member);
        } else {
            Assert.assertTrue(false, "Unknown health code: " + status);
        }
        this.reevaluateHealth();
    }
}

