/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.DistributedSystemHealthConfig;
import com.gemstone.gemfire.admin.internal.AbstractHealthEvaluator;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.List;
import java.util.Set;

class DistributedSystemHealthEvaluator
extends AbstractHealthEvaluator
implements MembershipListener {
    private DistributedSystemHealthConfig config;
    private DM dm;
    private String description;
    private int crashedApplications;

    DistributedSystemHealthEvaluator(DistributedSystemHealthConfig config, DM dm) {
        super(null, dm);
        this.config = config;
        this.dm = dm;
        this.dm.addMembershipListener(this);
        StringBuffer sb = new StringBuffer();
        sb.append("Distributed System ");
        String desc = null;
        if (dm instanceof DistributionManager) {
            desc = ((DistributionManager)dm).getDistributionConfigDescription();
        }
        if (desc != null) {
            sb.append(desc);
        } else {
            DistributionConfig dsc = dm.getSystem().getConfig();
            String locators = dsc.getLocators();
            if (locators == null || locators.equals("")) {
                sb.append("using multicast ");
                sb.append(dsc.getMcastAddress());
                sb.append(":");
                sb.append(dsc.getMcastPort());
            } else {
                sb.append("using locators ");
                sb.append(locators);
            }
        }
        this.description = sb.toString();
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDepartedApplications(List status) {
        DistributedSystemHealthEvaluator distributedSystemHealthEvaluator = this;
        synchronized (distributedSystemHealthEvaluator) {
            long threshold = this.config.getMaxDepartedApplications();
            if ((long)this.crashedApplications > threshold) {
                String s = LocalizedStrings.DistributedSystemHealth_THE_NUMBER_OF_APPLICATIONS_THAT_HAVE_LEFT_THE_DISTRIBUTED_SYSTEM_0_EXCEEDS_THE_THRESHOLD_1.toLocalizedString(this.crashedApplications, threshold);
                status.add(this.poorHealth(s));
            }
            this.crashedApplications = 0;
        }
    }

    @Override
    protected void check(List status) {
        this.checkDepartedApplications(status);
    }

    @Override
    void close() {
        this.dm.removeMembershipListener(this);
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        if (!crashed) {
            return;
        }
        DistributedSystemHealthEvaluator distributedSystemHealthEvaluator = this;
        synchronized (distributedSystemHealthEvaluator) {
            int kind = id.getVmKind();
            switch (kind) {
                case 10: 
                case 11: {
                    ++this.crashedApplications;
                    break;
                }
            }
        }
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }
}

