/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.internal.BackupDataStoreResult;
import com.gemstone.gemfire.admin.internal.FinishBackupRequest;
import com.gemstone.gemfire.admin.internal.FlushToDiskRequest;
import com.gemstone.gemfire.admin.internal.PrepareBackupRequest;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.Assert;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class BackupDataStoreHelper {
    public static String LOCK_SERVICE_NAME = BackupDataStoreHelper.class.getSimpleName();
    private static String LOCK_NAME = LOCK_SERVICE_NAME + "_token";
    private static Object LOCK_SYNC = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupDataStoreResult backupAllMembers(DM dm, Set recipients, File targetDir, File baselineDir) {
        Map<DistributedMember, Set<PersistentID>> successfulMembers;
        Map<DistributedMember, Set<PersistentID>> existingDataStores;
        FlushToDiskRequest.send(dm, recipients);
        boolean abort = true;
        try {
            existingDataStores = PrepareBackupRequest.send(dm, recipients);
            abort = false;
        }
        finally {
            successfulMembers = FinishBackupRequest.send(dm, recipients, targetDir, baselineDir, abort);
        }
        return new BackupDataStoreResult(existingDataStores, successfulMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DistributedLockService getLockService(DM dm) {
        DistributedLockService dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
        if (dls == null) {
            Object object = LOCK_SYNC;
            synchronized (object) {
                dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                if (dls == null) {
                    dls = DistributedLockService.create(LOCK_SERVICE_NAME, dm.getSystem());
                }
            }
        }
        Assert.assertTrue(dls != null);
        return dls;
    }

    public static boolean obtainLock(DM dm) {
        return BackupDataStoreHelper.getLockService(dm).lock(LOCK_NAME, 0L, -1L);
    }

    public static void releaseLock(DM dm) {
        BackupDataStoreHelper.getLockService(dm).unlock(LOCK_NAME);
    }
}

