/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractHealthEvaluator {
    private static final Logger logger = LogService.getLogger();
    private int numEvaluations = 0;

    protected AbstractHealthEvaluator(GemFireHealthConfig config, DM dm) {
    }

    public final void evaluate(List status) {
        ++this.numEvaluations;
        this.check(status);
    }

    protected abstract void check(List var1);

    protected final boolean isFirstEvaluation() {
        return this.numEvaluations <= 1;
    }

    protected HealthStatus okayHealth(String diagnosis) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.AbstractHealthEvaluator_OKAY_HEALTH__0, diagnosis));
        return new HealthStatus(GemFireHealth.OKAY_HEALTH, diagnosis);
    }

    protected HealthStatus poorHealth(String diagnosis) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.AbstractHealthEvaluator_POOR_HEALTH__0, diagnosis));
        return new HealthStatus(GemFireHealth.POOR_HEALTH, diagnosis);
    }

    protected abstract String getDescription();

    abstract void close();

    public class HealthStatus {
        private GemFireHealth.Health healthCode;
        private String diagnosis;

        HealthStatus(GemFireHealth.Health healthCode, String diagnosis) {
            this.healthCode = healthCode;
            this.diagnosis = "[" + AbstractHealthEvaluator.this.getDescription() + "] " + diagnosis;
        }

        public GemFireHealth.Health getHealthCode() {
            return this.healthCode;
        }

        public String getDiagnosis() {
            return this.diagnosis;
        }
    }
}

